/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.model.impl;

import com.adobe.aemds.guide.model.ReCaptchaConfiguration;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class ReCaptchaConfigurationModel
implements ReCaptchaConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ReCaptchaConfigurationModel.class);
    @OSGiService
    private CryptoSupport cryptoSupport;
    @Inject
    private String siteKey;
    @Inject
    private String secretKey;
    @Inject
    private String name;
    @Inject
    @Optional
    @Named(value="jcr:title")
    private String title;
    @Inject
    @Optional
    private String description;
    @Inject
    @Optional
    private String thumbnailPath;

    @Override
    public String siteKey() {
        return this.siteKey;
    }

    @Override
    public String secretKey() {
        String unprotectedSecretKey = null;
        try {
            unprotectedSecretKey = this.cryptoSupport.unprotect(this.secretKey);
        }
        catch (CryptoException cryptoException) {
            logger.error("Error while decrypting the Secret Key:" + this.secretKey, cryptoException);
        }
        return unprotectedSecretKey;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String thumbnailPath() {
        return this.thumbnailPath;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return null;
    }
}

