/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.theme.model.impl;

import com.adobe.aemds.guide.themes.model.Component;
import com.adobe.aemds.guide.themes.model.Theme;
import com.adobe.aemds.guide.themes.model.ThemeClientLib;
import com.adobe.aemds.guide.themes.model.ThemeMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={Theme.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class ThemeImpl
implements Theme {
    private static Logger logger = LoggerFactory.getLogger(ThemeImpl.class);
    private final Resource resource;
    @Inject
    @Named(value="metadata")
    private ThemeMetadata metadata;
    @Inject
    @Named(value="renditions/theme-json/jcr:content/components")
    List<Component> components;
    @Inject
    @Named(value="renditions/theme-json/jcr:content/rawCss")
    InputStream rawCss;

    public ThemeImpl(Resource resource) {
        this.resource = resource;
    }

    @Override
    public List<Component> getComponents() {
        return this.components;
    }

    @Override
    public ThemeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getThemeNodeName() {
        ResourceResolver resolver = this.resource.getResourceResolver();
        return this.resource.getParent().getName();
    }

    @Override
    public ThemeClientLib getClientLib() {
        String themeNodeName = this.getThemeNodeName();
        ResourceResolver resolver = this.resource.getResourceResolver();
        Resource clientLibResource = resolver.getResource(this.getMetadata().getClientlibRef() + "/" + themeNodeName);
        return clientLibResource.adaptTo(ThemeClientLib.class);
    }

    @Override
    public String getRawCss() {
        String rawCssString = "";
        try {
            if (this.rawCss != null) {
                rawCssString = IOUtils.toString(this.rawCss);
            }
        }
        catch (IOException ioe) {
            logger.error("Unable to get Raw CSS.", ioe);
        }
        return rawCssString;
    }
}

