/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.utils.GuideHTMLParserOptions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideHTMLParser {
    static Logger logger = LoggerFactory.getLogger(GuideHTMLParser.class);

    public static String stripAllOnDemandChildren(GuideHTMLParserOptions guideHTMLParserOptions) {
        String html = guideHTMLParserOptions.getHtml();
        return GuideHTMLParser.stripLazyHtml(html);
    }

    public static String getAssetHTMLFromFullHTML(String documentHtml, String templateId) {
        String lazyFragmentMarkerBeginText = GuideHTMLParser.lazyFragmentMarkerBegin(templateId);
        int lazyFragmentMarkerStartIndex = StringUtils.indexOf(documentHtml, lazyFragmentMarkerBeginText + " ");
        int lazyFragmentMarkerEndIndex = lazyFragmentMarkerStartIndex + GuideHTMLParser.lazyFragmentMarkerStaticLength(templateId);
        String lazyFragMarkerText = StringUtils.substring(documentHtml, lazyFragmentMarkerStartIndex, lazyFragmentMarkerEndIndex);
        Pattern pattern = Pattern.compile("data-guide-asset-ref-length=(.*?)-->");
        Matcher matcher = pattern.matcher(lazyFragMarkerText);
        int lazyLength = -1;
        if (matcher.find()) {
            lazyLength = Integer.parseInt(matcher.group(1).trim());
        }
        String assetHtml = StringUtils.substring(documentHtml, lazyFragmentMarkerEndIndex, lazyFragmentMarkerEndIndex + lazyLength);
        return GuideHTMLParser.stripLazyHtml(assetHtml);
    }

    private static String stripLazyHtml(String htmlContent) {
        Pattern pattern = Pattern.compile("<!--data-guide-asset-ref=(.*?) data-guide-asset-ref-length=(.*?)-->");
        String strippedString = htmlContent;
        Matcher matcher = pattern.matcher(strippedString);
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            int lazyLength = Integer.parseInt(matcher.group(2).trim());
            strippedString = strippedString.substring(0, startIndex) + strippedString.substring(endIndex + lazyLength);
            matcher = pattern.matcher(strippedString);
        }
        return strippedString;
    }

    public static String lazyFragmentMarker(String templateId, String bodyContent) {
        return GuideHTMLParser.lazyFragmentMarkerBegin(templateId) + GuideHTMLParser.lazyFragmentMarkerEnd(bodyContent);
    }

    private static String lazyFragmentMarkerBegin(String templateId) {
        return "<!--data-guide-asset-ref=" + templateId;
    }

    private static String lazyFragmentMarkerEnd(String bodyContent) {
        String paddedBodyLength = StringUtils.leftPad("" + StringUtils.length(bodyContent), 30);
        return " data-guide-asset-ref-length=" + paddedBodyLength + "-->";
    }

    private static int lazyFragmentMarkerStaticLength(String templateId) {
        String lazyFragmentMarker = GuideHTMLParser.lazyFragmentMarker(templateId, "");
        return lazyFragmentMarker.length();
    }
}

