/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.screens.impl.aemio;

import com.adobe.cq.screens.assignment.AssignmentService;
import com.adobe.cq.screens.impl.aemio.ScreensModelLookup;
import com.adobe.cq.screens.impl.util.AdaptableUtil;
import com.adobe.cq.screens.offlinecontent.OfflineContentService;
import com.adobe.granite.haf.annotations.ApiAction;
import com.adobe.granite.haf.annotations.ApiLink;
import com.adobe.granite.haf.annotations.ApiModel;
import com.adobe.granite.haf.annotations.ApiProperty;
import com.adobe.granite.haf.api.ApiResponse;
import com.adobe.granite.haf.api.ApiResponseBuilder;
import com.adobe.granite.haf.api.ApiResponseBuilderFactory;
import java.util.Date;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
@ApiModel(category="screens", type={"aem-io/screens/assignment"}, modelLookup=ScreensModelLookup.class)
public class ScreensAssignmentModel {
    private Logger log = LoggerFactory.getLogger(ScreensAssignmentModel.class);
    @OSGiService
    private ApiResponseBuilderFactory arbFactory;
    @Inject
    @Self
    protected Resource baseResource;

    @ApiLink(rel="about")
    public String entity() {
        String url = (String)((Object)ResourceUtil.getValueMap(this.baseResource).get("path", String.class));
        return url == null ? null : url + ".json";
    }

    @ApiProperty
    public String getRole() {
        return (String)((Object)ResourceUtil.getValueMap(this.baseResource).get("role", String.class));
    }

    @ApiProperty
    public String getSchedule() {
        return (String)((Object)ResourceUtil.getValueMap(this.baseResource).get("schedule", String.class));
    }

    @ApiProperty
    public long getStartDate() {
        Date date = (Date)((Object)ResourceUtil.getValueMap(this.baseResource).get("startDate", Date.class));
        return date != null ? DateUtils.truncate(date, 5).getTime() : 0L;
    }

    @ApiProperty
    public long getEndDate() {
        Date date = (Date)((Object)ResourceUtil.getValueMap(this.baseResource).get("endDate", Date.class));
        return date != null ? DateUtils.addMilliseconds(DateUtils.ceiling(date, 5), -1).getTime() : 0L;
    }

    @ApiProperty
    public long getPriority() {
        return ResourceUtil.getValueMap(this.baseResource).get("priority", 1L);
    }

    @ApiAction(method="POST", name="update-cache")
    public void executeCommand() throws JSONException, PersistenceException, RepositoryException {
        OfflineContentService offlineContentSvc = (OfflineContentService)AdaptableUtil.safeAdaptTo((Adaptable)this.baseResource.getResourceResolver(), OfflineContentService.class);
        offlineContentSvc.prepareOfflineContentForAssignment(this.baseResource);
    }

    @ApiAction(method="DELETE", name="delete")
    public ApiResponse delete() {
        ResourceResolver resolver = this.baseResource.getResourceResolver();
        ApiResponseBuilder builder = this.arbFactory.createBuilder();
        try {
            AssignmentService assignmentService = resolver.adaptTo(AssignmentService.class);
            if (assignmentService != null) {
                assignmentService.delete(this.baseResource);
                resolver.commit();
            }
        }
        catch (PersistenceException e) {
            this.log.warn("Cannot delete the assignment.");
        }
        return builder.setStatus(204, "Deleted").build();
    }
}

