/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.calendar.client.api;

import com.day.cq.commons.date.DateUtil;
import com.day.cq.commons.date.InvalidDateException;
import java.util.Calendar;

public interface DateRangeFilter {
    public String getLowerBound();

    public Calendar getLowerBoundCalendar();

    public UpperBoundedValue getUpperBoundedValue();

    public Calendar getUpperBoundCalendar();

    public boolean includeLowerBoundValue();

    public boolean includeUpperBoundValue();

    public static class UpperBoundedValue {
        public static UpperBoundedValue ONE_MONTH_OFFSET;
        final DateRangeType type;
        final int offset;
        Calendar cal;
        final String value;

        public UpperBoundedValue(String value) throws InvalidDateException {
            this.value = value;
            this.type = this.getDateRangeFilter(value);
            if (this.type != DateRangeType.RANGE) {
                String s = value.substring(0, value.length() - 1);
                try {
                    this.offset = Integer.parseInt(s);
                    this.cal = null;
                }
                catch (NumberFormatException e) {
                    throw new InvalidDateException("Invalid date range: " + s);
                }
            } else {
                this.offset = -1;
            }
        }

        public DateRangeType getType() {
            return this.type;
        }

        public String value() {
            return this.value;
        }

        public int getOffset() {
            if (this.type != DateRangeType.RANGE) {
                return this.offset;
            }
            throw new UnsupportedOperationException("getOffset is not supported for DateRangeType.RANGE");
        }

        public Calendar getCalendar(Calendar start) {
            if (this.type != DateRangeType.RANGE) {
                Calendar retVal = (Calendar)start.clone();
                retVal.add(this.type.getCalendarFieldNumber(), this.offset);
                return retVal;
            }
            return this.cal;
        }

        public Calendar getOffset(Calendar start, int offset) {
            Calendar retVal = (Calendar)start.clone();
            retVal.add(this.type.getCalendarFieldNumber(), offset);
            return retVal;
        }

        public int daysBetween(Calendar c1, Calendar c2) {
            return (int)((c2.getTimeInMillis() - c1.getTimeInMillis()) / 86400000L);
        }

        private DateRangeType getDateRangeFilter(String date) throws InvalidDateException {
            String suffix = "" + date.charAt(date.length() - 1);
            if (suffix.equals(DateRangeType.DAYOFFSET.getSuffix())) {
                return DateRangeType.DAYOFFSET;
            }
            if (suffix.equals(DateRangeType.WEEKOFFSET.getSuffix())) {
                return DateRangeType.WEEKOFFSET;
            }
            if (suffix.equals(DateRangeType.MONTHOFFSET.getSuffix())) {
                return DateRangeType.MONTHOFFSET;
            }
            if (suffix.equals(DateRangeType.YEAROFFSET.getSuffix())) {
                return DateRangeType.YEAROFFSET;
            }
            this.cal = DateUtil.parseISO8601(date);
            return DateRangeType.RANGE;
        }

        static {
            try {
                ONE_MONTH_OFFSET = new UpperBoundedValue("1M");
            }
            catch (InvalidDateException invalidDateException) {
                // empty catch block
            }
        }
    }

    public static enum DateRangeType {
        DAYOFFSET("D", 5),
        WEEKOFFSET("W", 4),
        MONTHOFFSET("M", 2),
        YEAROFFSET("Y", 1),
        RANGE("", 5);

        final String suffix;
        final int calendarFieldNumber;

        private DateRangeType(String suffix, int calendarFieldNumber) {
            this.suffix = suffix;
            this.calendarFieldNumber = calendarFieldNumber;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public int getCalendarFieldNumber() {
            return this.calendarFieldNumber;
        }
    }
}

