/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.ugc.api.ComparisonType;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.Operator;
import com.adobe.cq.social.ugc.api.SearchResults;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.UgcSearch;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CommentUtil.class);
    private static final String ACTIVITY_RESOURCE_TYPE = "social/activitystreams/components/activity";
    private static final Integer MAX_UGC_LIMIT = 2147473647;

    public static boolean isPending(Resource resource, Resource component) {
        return !CommentUtil.isSpam(resource) && CommentUtil.isSystemModerated(component) && "".equals(CommentUtil.getProperty(resource, "approved", ""));
    }

    public static boolean isApproved(Resource resource, Resource component) {
        return !CommentUtil.isSpam(resource) && (!CommentUtil.isSystemModerated(component) || CommentUtil.getProperty(resource, "approved", false) != false);
    }

    public static boolean isSpam(Resource resource) {
        return CommentUtil.getProperty(resource, "isSpam", false);
    }

    public static boolean isFlagged(Resource resource) {
        return CommentUtil.getProperty(resource, "isFlagged", false);
    }

    public static boolean isClosed(Resource resource) {
        return CommentUtil.getProperty(resource, "isClosed", false);
    }

    public static boolean isFlaggedHidden(Resource resource) {
        return CommentUtil.getProperty(resource, "isFlaggedHidden", false);
    }

    public static boolean isSystemModerated(Resource component) {
        return CommentUtil.getProperty(component, "moderateComments", false);
    }

    public static boolean isSystemClosed(Resource component) {
        return CommentUtil.getProperty(component, "closed", false);
    }

    public static <T> T getProperty(Resource resource, String name, T defaultValue) {
        try {
            return resource.adaptTo(ValueMap.class).get(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isAllowVoting(Resource component) {
        return CommentUtil.getProperty(component, "allowVoting", false);
    }

    public static String getVotingType(Resource component) {
        return CommentUtil.getDesignConfig(component, "votingType", "social/tally/components/hbs/voting");
    }

    public static String getVotingRoot(Resource component) {
        return CommentUtil.getDesignConfig(component, "votingRoot", "voting");
    }

    public static boolean isAllowFollowing(Resource component) {
        return CommentUtil.getProperty(component, "allowFollowing", false);
    }

    public static boolean isAllowSubscriptions(Resource component) {
        return CommentUtil.getProperty(component, "allowSubscriptions", false);
    }

    public static boolean showBadges(Resource component) {
        return CommentUtil.getProperty(component, "allowBadges", false);
    }

    public static <T> T getDesignConfig(Resource component, String configName, T defaultValue) {
        ResourceResolver resolver = component.getResourceResolver();
        Designer commentDesign = resolver.adaptTo(Designer.class);
        if (null != commentDesign) {
            Style style = null;
            try {
                style = commentDesign.getStyle(component);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (null != style) {
                return style.get(configName, defaultValue);
            }
        }
        return defaultValue;
    }

    public static List<String> getPrivilegedGroups(Resource cs) {
        ValueMap props = cs.adaptTo(ValueMap.class);
        if (props != null) {
            String[] privilegedUserGroups = (String[])props.get("cq:privilegedMembers", String[].class);
            List<String> groupIds = Collections.EMPTY_LIST;
            if (privilegedUserGroups != null && privilegedUserGroups.length > 0) {
                groupIds = Arrays.asList(privilegedUserGroups);
                return groupIds;
            }
            return null;
        }
        return null;
    }

    public static void getComments(Comment comment, List<String> comments) {
        if (comment != null) {
            comments.add(comment.getPath());
            Iterator<Comment> iterator = comment.getComments();
            while (iterator.hasNext()) {
                Comment c = iterator.next();
                if (c.hasComments()) {
                    CommentUtil.getComments(c, comments);
                    continue;
                }
                comments.add(c.getPath());
            }
        }
    }

    @Deprecated
    public static Resource getActivityForComment(ResourceResolver resolver, String commentPath) {
        if (resolver == null || commentPath == null) {
            return null;
        }
        UgcSearch ugcSearch = resolver.adaptTo(UgcSearch.class);
        UgcFilter filter = new UgcFilter();
        ConstraintGroup constraintGroup = new ConstraintGroup();
        constraintGroup.and(new ValueConstraint<String>("objectid_s", commentPath, ComparisonType.Equals));
        constraintGroup.and(new ValueConstraint<String>("sling:resourceType", ACTIVITY_RESOURCE_TYPE, ComparisonType.Equals));
        filter.addConstraint(constraintGroup);
        Resource activityResource = null;
        try {
            SearchResults<Resource> searchResults = ugcSearch.find(null, resolver, filter, 0, 1, false);
            if (searchResults.getResults() != null && searchResults.getResults().size() > 0) {
                activityResource = searchResults.getResults().get(0);
            }
        }
        catch (RepositoryException e) {
            LOG.error("Unable to get activity for the comment: " + commentPath);
        }
        return activityResource;
    }

    public static List<Resource> getActivitiesForComment(ResourceResolver resolver, String commentPath) {
        if (resolver == null || commentPath == null) {
            return null;
        }
        UgcSearch ugcSearch = resolver.adaptTo(UgcSearch.class);
        UgcFilter filter = new UgcFilter();
        ConstraintGroup commentPathGroup = new ConstraintGroup();
        commentPathGroup.addConstraint(new ValueConstraint<String>("objectid_s", commentPath, ComparisonType.Equals, Operator.Or));
        commentPathGroup.addConstraint(new ValueConstraint<String>("targetid_s", commentPath, ComparisonType.Equals, Operator.Or));
        ConstraintGroup resourceTypeGroup = new ConstraintGroup();
        resourceTypeGroup.and(new ValueConstraint<String>("sling:resourceType", ACTIVITY_RESOURCE_TYPE, ComparisonType.Equals));
        ConstraintGroup constraintGroup = new ConstraintGroup(Operator.And);
        constraintGroup.addConstraint(commentPathGroup);
        constraintGroup.addConstraint(resourceTypeGroup);
        filter.addConstraint(constraintGroup);
        try {
            SearchResults<Resource> searchResults = ugcSearch.find(null, resolver, filter, 0, MAX_UGC_LIMIT, false);
            if (searchResults.getResults() != null && searchResults.getResults().size() > 0) {
                return searchResults.getResults();
            }
        }
        catch (RepositoryException e) {
            LOG.error("Unable to get activity for the comment: " + commentPath);
        }
        return null;
    }

    public static boolean isUserPrivileged(Resource cs, ResourceResolver resolver, String userId) {
        ValueMap props;
        String currentUserId = userId;
        if (StringUtils.isBlank(currentUserId)) {
            currentUserId = resolver.getUserID();
        }
        if ((props = cs.adaptTo(ValueMap.class)).containsKey("allowPrivilegedMembers") && !((Boolean)((Object)props.get("allowPrivilegedMembers", Boolean.class))).booleanValue()) {
            return true;
        }
        List<String> groupIds = CommentUtil.getPrivilegedGroups(cs);
        if (groupIds != null && !groupIds.isEmpty()) {
            try {
                String userIdWithSocialPrefix = "/social/authors/" + userId;
                if (groupIds.contains(userId) || groupIds.contains(userIdWithSocialPrefix)) {
                    return true;
                }
                UserManager userManager = resolver.adaptTo(UserManager.class);
                Authorizable user = userManager.getAuthorizable(currentUserId);
                Iterator<Group> groupIterator = user.memberOf();
                while (groupIterator.hasNext()) {
                    String groupId = groupIterator.next().getID();
                    String groupIdWithSocialPrefix = "/social/groups/" + groupId;
                    if (!groupIds.contains(groupId) && !groupIds.contains(groupIdWithSocialPrefix)) continue;
                    return true;
                }
                return false;
            }
            catch (RepositoryException e) {
                LOG.error("Failed to get user for " + String.valueOf(userId), e);
            }
        }
        return true;
    }
}

