/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.client.api;

import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.comments.api.AbstractCommentCollection;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.forum.client.api.BaseForumConfiguration;
import com.adobe.cq.social.forum.client.api.Forum;
import com.adobe.cq.social.forum.client.api.ForumConfiguration;
import com.adobe.cq.social.forum.client.api.Post;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public abstract class AbstractForum<P extends Post, C extends ForumConfiguration>
extends AbstractCommentCollection<P, C>
implements Forum<P, C> {
    private final String title;
    private final boolean isClosed;
    private ForumConfiguration configuration;

    public AbstractForum(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager listProviderManager) {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager);
    }

    public AbstractForum(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager listProviderManager) {
        super(resource, clientUtils, queryInfo, listProviderManager);
        Page page;
        ResourceResolver resolver = resource.getResourceResolver();
        PageManager pageManager = resolver.adaptTo(PageManager.class);
        ValueMap properties = ResourceUtil.getValueMap(resource);
        SocialUtils socialUtils = clientUtils.getSocialUtils();
        this.title = socialUtils != null ? ((page = socialUtils.getContainingPage(resource)) != null ? page.getTitle() : null) : null;
        this.isClosed = properties.get("closed", false);
    }

    @Override
    @JsonProperty(value="isClosed")
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean getMayPost() {
        boolean mayPost = super.getMayPost();
        boolean isUserPrivileged = CommentUtil.isUserPrivileged(this.resource, this.resource.getResourceResolver(), this.clientUtils.getAuthorizedUserId());
        if (mayPost && !isUserPrivileged && Boolean.parseBoolean(CommentUtil.getProperty(this.resource, "allowAllMembers", "false"))) {
            return true;
        }
        return mayPost && isUserPrivileged;
    }

    public boolean getIsUserInPrivilegedGroups() {
        return CommentUtil.isUserPrivileged(this.resource, this.resource.getResourceResolver(), this.clientUtils.getAuthorizedUserId());
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTitle() {
        return this.title;
    }

    @Override
    protected C createConfiguration(Resource resource) {
        return (C)new BaseForumConfiguration(resource);
    }
}

