/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.client.endpoints;

import com.adobe.cq.social.blueprint.api.SiteActivationService;
import com.adobe.cq.social.blueprint.api.TemplateRolloutService;
import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.FunctionValidationUtil;
import com.adobe.cq.social.commons.exception.FunctionValidationException;
import com.adobe.cq.social.community.api.CommunityConstants;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.community.api.CommunityUserGroup;
import com.adobe.cq.social.console.utils.api.FunctionDefinitionUtils;
import com.adobe.cq.social.console.utils.api.internal.PropertiesUtils;
import com.adobe.cq.social.group.api.GroupException;
import com.adobe.cq.social.group.api.GroupService;
import com.adobe.cq.social.group.api.GroupUtil;
import com.adobe.cq.social.group.bundleactivator.impl.Activator;
import com.adobe.cq.social.group.client.api.CommunityGroup;
import com.adobe.cq.social.group.client.api.CommunityGroupCollection;
import com.adobe.cq.social.group.client.api.CommunityGroupService;
import com.adobe.cq.social.group.client.endpoints.CommunityGroupOperationExtension;
import com.adobe.cq.social.group.client.endpoints.CommunityGroupOperations;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.site.api.CommunitySiteService;
import com.adobe.cq.social.site.endpoints.AbstractPublishOperationService;
import com.adobe.cq.social.site.endpoints.SiteOperationUtils;
import com.adobe.cq.social.ugcbase.AsyncReverseReplicator;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.confmgr.Conf;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.text.Text;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.activation.DataSource;
import javax.annotation.Nullable;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractCommunityGroupOperationService<T extends CommunityGroupOperationExtension, U extends Operation>
extends AbstractPublishOperationService<T, U, CommunityGroup>
implements CommunityGroupOperations {
    private static final String MSM_SERVICE = "msm-service";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunityGroupOperationService.class);
    private static final String PROPERTY_IMAGE_NAME = "image";
    private static final String PROPERTY_BANNER_IMAGE_NAME = "pagebanner";
    private static final int PARAM_NAME_INDEX = 0;
    private static final int PARAM_CLASS_INDEX = 1;
    private static final int PARAM_REQUIRED_INDEX = 2;
    private static final Object[][] requestParams = new Object[][]{{"jcr:description", String.class, Boolean.FALSE}, {"urlName", String.class, Boolean.TRUE}, {"name", String.class, Boolean.FALSE}, {"type", String.class, Boolean.FALSE}, {"invite", String[].class, Boolean.FALSE}, {"includeSiteModerators", Boolean.class, Boolean.FALSE}, {"moderators", String[].class, Boolean.FALSE}, {"admins", String[].class, Boolean.FALSE}, {"initialLanguages", String[].class, Boolean.FALSE}, {"complTableData", String[].class, Boolean.FALSE}, {"functions", String.class, Boolean.FALSE}, {"theme", String.class, Boolean.FALSE}, {"blueprint", String.class, Boolean.TRUE}};
    private static final String[] specialParams = new String[]{"file", "pagebanner"};
    private static final String[] unchangeableParams = new String[]{"urlName", "file", "pagebanner"};
    private static final int ATTACHMENT_FILE_LIMIT = Integer.MAX_VALUE;
    private static final List<String> WHITE_LIST = new ArrayList<String>();
    private static final String[] BLACK_LIST = new String[0];
    private static final String USER_ADMIN = "communities-user-admin";
    private static final String DEFAULT_GROUP_ROOTTEMPLATE_ROOT = "/etc/community/templates/groups";
    private static final String DEFAULT_GROUP_TEMPLATE_ROOT = "/etc/community/templates/groups" + CommunityConstants.REFERENCE_SUBPATH;
    private static final String CUSTOM_GROUP_TEMPLATE_ROOT = "/etc/community/templates/groups" + CommunityConstants.CUSTOM_SUBPATH;
    private static final String DEFAULT_GROUP_ROOTTEMPLATE_RELATIVIEPATH_ROOT = "community/templates/groups";
    private static final String CUSTOM_GROUP_TEMPLATE_ROOT_CONF = "/conf/global/settings/community/templates/groups";
    private static final String CUSTOM_GROUP_TEMPLATE_ROOT_LIBS = "/libs/settings/community/templates/groups";
    private static final String PATH = "path";
    private static final String NAME = "name";
    private static final String NODE_PROPERTY_COMMENTATTACHMENT = "cq:CommentAttachment";
    protected ClientUtilities clientUtils;
    public static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";
    private final String delimiters = "[\\s,;]";
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private AsyncReverseReplicator replicator;
    @Reference
    private GroupService groupService;
    @Reference
    private CommunityGroupService communityGroupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    protected SlingSettingsService settingsService;
    @Reference
    CommunitySiteService siteService;
    @Reference
    SiteActivationService activationService;
    @Reference
    private SocialUtils socialUtils;
    @Reference
    private FunctionDefinitionUtils funcDefUtils;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private TemplateRolloutService siteBlueprintService;
    protected String[] fieldWhitelist;

    private void cleanupFailure(Session session) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failure cleanup invoked.", new Throwable());
            }
            session.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.info("Failed to refresh the session", e);
        }
    }

    @Override
    protected ResourceResolverFactory getBundleLocalResourceResolverFactory() {
        if (this.resourceResolverFactory == null) {
            this.resourceResolverFactory = (ResourceResolverFactory)Activator.getService(ResourceResolverFactory.class);
        }
        return this.resourceResolverFactory;
    }

    @Override
    protected ServiceUserWrapper getServiceUserWrapper() {
        if (this.serviceUserWrapper == null) {
            this.serviceUserWrapper = (ServiceUserWrapper)Activator.getService(ServiceUserWrapper.class);
        }
        return this.serviceUserWrapper;
    }

    @Override
    public Resource create(SlingHttpServletRequest request) throws OperationException {
        Resource groupPageResource;
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        boolean validPath = false;
        CommunityGroupCollection groupCollection = null;
        ArrayList<Resource> returnresourceList = new ArrayList<Resource>();
        if (resource.isResourceType("social/group/components/hbs/communitygroups")) {
            validPath = true;
            groupCollection = this.getCommunityGroupCollectionForResource(resource, request);
        } else {
            PageManager pm = resolver.adaptTo(PageManager.class);
            Page page = pm.getPage(resource.getPath());
            if (page != null) {
                Resource r = resolver.getResource(resource.getPath() + "/" + "folderConfiguration");
                if (r != null) {
                    validPath = true;
                    groupCollection = this.getCommunityGroupCollectionForResource(resource, request);
                } else {
                    r = resolver.getResource(resource.getPath() + "/" + "configuration");
                    if (r != null) {
                        validPath = true;
                    }
                }
            }
        }
        if (!validPath) {
            throw new OperationException("Invalid Group Path:" + resource.getPath(), 400);
        }
        if (groupCollection != null && !groupCollection.isCanAdd()) {
            throw new OperationException("No permission to create a community group.", 500);
        }
        if (!this.isPublishMode() && !this.siteService.mayPost(request, session)) {
            throw new OperationException("Access violation.", 403);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, true);
            this.getCustomProperties(request, props, session);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to obtain community group parameters.", e, 500);
        }
        U createOperation = this.getCreateOperation();
        this.getExtensionParameters(createOperation, request, props);
        String invites = (String)props.get("invite");
        props.put("invite", invites);
        props.put("owner", session.getUserID());
        String name = null;
        name = (String)props.get("urlName");
        PageManager pm = resolver.adaptTo(PageManager.class);
        Page groupPage = pm.getContainingPage(resource);
        String root = groupPage.getPath();
        Resource firstGroupPageResource = groupPageResource = resolver.getResource(root);
        if (!GroupUtil.validateGroupName(resolver, name, root)) {
            throw new OperationException("Community group name is badly formatted " + name, 400);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, "file");
        List<DataSource> banner = this.getAttachmentsFromRequest(request, PROPERTY_BANNER_IMAGE_NAME);
        List<DataSource> cssFiles = this.getAttachmentsFromRequest(request, "pagecss");
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            returnresourceList.add(this.create(groupPageResource, name, props, attachments, banner, cssFiles, userAdminResolver.adaptTo(Session.class)));
            if (this.isPublishMode()) {
                Resource resource2 = groupPageResource;
                return resource2;
            }
            String initialLanguage = (String)props.get("initialLanguages");
            if (initialLanguage != null) {
                String[] initialLangLen = initialLanguage.split(",");
                String pathmk = null;
                LanguageUtil languageCode = new LanguageUtil();
                int i = 0;
                for (i = 0; i < initialLangLen.length; ++i) {
                    String languageCodePath = LanguageUtil.getLanguageRoot(root);
                    int codelanPath = languageCodePath.length();
                    int rootlanPath = root.length();
                    pathmk = root.substring(codelanPath, rootlanPath);
                    String currentLanguage = initialLangLen[i];
                    String relativeparent = Text.getRelativeParent(languageCodePath, 1);
                    root = relativeparent.concat("/" + currentLanguage + pathmk);
                    groupPageResource = resolver.getResource(root);
                    Page group = pm.getPage(root + "/" + name);
                    if (group != null) {
                        LOG.info("Group {} already exists in {}", (Object)name, (Object)root);
                        continue;
                    }
                    if (!GroupUtil.validateGroupName(resolver, name, root)) {
                        throw new OperationException("Community group name is badly formatted " + name, 400);
                    }
                    if (groupPageResource == null) continue;
                    userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
                    returnresourceList.add(this.create(groupPageResource, name, props, attachments, banner, cssFiles, userAdminResolver.adaptTo(Session.class)));
                    userAdminResolver.close();
                }
            }
            Resource resource3 = firstGroupPageResource;
            return resource3;
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null && userAdminResolver.isLive()) {
                userAdminResolver.close();
            }
        }
    }

    protected Resource create(Resource root, String name, Map<String, Object> properties, List<DataSource> attachments, Session session) throws OperationException {
        return this.create(root, name, properties, attachments, Collections.<DataSource>emptyList(), Collections.<DataSource>emptyList(), session);
    }

    protected Resource create(Resource root, String name, Map<String, Object> properties, List<DataSource> attachments, List<DataSource> banner, Session session) throws OperationException {
        return this.create(root, name, properties, attachments, banner, Collections.<DataSource>emptyList(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource create(Resource root, String name, Map<String, Object> properties, List<DataSource> attachments, List<DataSource> banner, List<DataSource> cssFiles, Session session) throws OperationException {
        try {
            boolean hasCSS;
            boolean hasBanner;
            HashMap<String, Object> authInfo = new HashMap<String, Object>();
            authInfo.put("user.jcr.session", session);
            ResourceResolver resolver = this.resourceResolverFactory.getResourceResolver(authInfo);
            U createOperation = this.getCreateOperation();
            this.performBeforeActions(createOperation, session, root, properties);
            String groupPath = root.getPath() + "/" + name;
            CommunityContext context = root.adaptTo(CommunityContext.class);
            String nuggetRoot = context != null ? context.getSitePayloadPath() : "/var/community/publish";
            nuggetRoot = StringUtils.replace(nuggetRoot, "/publish", "/create");
            String nuggetPath = nuggetRoot + groupPath;
            Node folder = JcrUtil.createPath(nuggetPath, "sling:Folder", session);
            Node nugget = folder.addNode("created", "oak:Unstructured");
            nugget.setProperty(PATH, root.getPath());
            nugget.setProperty("action", "Create Community Group");
            nugget.setProperty("formPayload", nuggetPath);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                String key = property.getKey();
                if (this.isSpecialRequestParam(key)) continue;
                JcrUtil.setProperty(nugget, key, property.getValue());
            }
            if (attachments != null && !attachments.isEmpty()) {
                DataSource ds = attachments.get(0);
                this.addImage(nuggetPath, resolver, ds.getInputStream(), ds.getContentType(), PROPERTY_IMAGE_NAME, ds.getName());
            } else {
                ResourceResolver serviceResolver = null;
                try {
                    serviceResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
                }
                catch (LoginException e) {
                    LOG.error("Unable to add default group image", e);
                }
                if (serviceResolver != null) {
                    Resource image = serviceResolver.getResource("/libs/social/group/components/hbs/communitygroups/communitygroup/content/resources/default.png");
                    if (image != null) {
                        this.addImage(nuggetPath, resolver, image.adaptTo(InputStream.class), "image/png", PROPERTY_IMAGE_NAME, "default.png");
                    } else {
                        LOG.error("Unable to find default group image");
                    }
                    serviceResolver.close();
                }
            }
            boolean bl = hasBanner = banner != null && !banner.isEmpty();
            if (hasBanner) {
                DataSource ds = banner.get(0);
                this.addImage(nuggetPath, resolver, ds.getInputStream(), ds.getContentType(), PROPERTY_BANNER_IMAGE_NAME, ds.getName());
            }
            boolean bl2 = hasCSS = cssFiles != null && !cssFiles.isEmpty();
            if (hasCSS) {
                DataSource ds = cssFiles.get(0);
                this.addCSS(nuggetPath, resolver, ds.getInputStream(), ds.getContentType(), "theme", ds.getName());
            }
            boolean publishRunMode = this.isPublishMode();
            nugget.setProperty("publishRunMode", Boolean.toString(publishRunMode));
            session.save();
            if (resolver.getResource(nuggetPath) != null && publishRunMode) {
                ArrayList<String> paths = new ArrayList<String>(2);
                paths.add(nuggetPath);
                paths.add(nuggetPath + "/" + PROPERTY_IMAGE_NAME);
                if (hasBanner) {
                    paths.add(nuggetPath + "/" + PROPERTY_BANNER_IMAGE_NAME);
                }
                if (hasCSS) {
                    paths.add(nuggetPath + "/" + "theme");
                }
                this.replicator.reverseReplicate(ReplicationActionType.ACTIVATE, paths);
            }
            ResourceResolver msmResolver = null;
            try {
                msmResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
                GroupUtil.waitForPageCreation(msmResolver, groupPath, 120000L, 15000L);
            }
            finally {
                if (msmResolver != null) {
                    msmResolver.close();
                }
            }
            Resource communityGroupResource = root.getResourceResolver().resolve(groupPath + "/" + "configuration");
            SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(communityGroupResource);
            CommunityGroup communityGroup = (CommunityGroup)(factory != null ? factory.getSocialComponent(communityGroupResource) : null);
            this.performAfterActions(createOperation, session, communityGroup, properties);
            return communityGroupResource;
        }
        catch (OperationException e) {
            this.cleanupFailure(session);
            throw e;
        }
        catch (Exception e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to create community group.", e, 500);
        }
    }

    @Override
    public Resource update(SlingHttpServletRequest request) throws OperationException {
        JSONArray functions;
        Resource resource = request.getResource();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        if (context.getCommunityGroupId() == null) {
            throw new OperationException("Not a valid Group resource", 400);
        }
        if (!this.siteService.mayPost(resource, session)) {
            throw new OperationException("Access violation.", 403);
        }
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(resource, request);
        if (group != null) {
            String name = group.getUrl();
        } else {
            String name = resource.getName();
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, false);
            this.getCustomProperties(request, props, session);
            String structureString = (String)props.get("functions");
            if (!this.validateFunctionValue(structureString)) {
                LOG.error("Malformed Function property " + structureString);
                throw new OperationException("Malformed Function property ", 400);
            }
            JSONObject structure = new JSONObject(structureString);
            functions = structure.getJSONArray("functions");
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to obtain community group properties.", e, 500);
        }
        catch (JSONException e1) {
            throw new OperationException("Failed to create community site.", e1, 500);
        }
        try {
            FunctionValidationUtil.validateFunctions(resource.getParent(), functions);
        }
        catch (FunctionValidationException e) {
            LOG.error("Community functions malformed", e);
            throw new OperationException("Community functions malformed\n" + e.getMessage(), 409);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, "file");
        if (attachments != null && !attachments.isEmpty()) {
            props.put("file", attachments);
        }
        List<DataSource> banner = this.getAttachmentsFromRequest(request, PROPERTY_BANNER_IMAGE_NAME);
        List<DataSource> groupCSS = this.getAttachmentsFromRequest(request, "pagecss");
        List<DataSource> groupThumbnail = this.getAttachmentsFromRequest(request, "pagethumbnail");
        if (banner != null && !banner.isEmpty()) {
            props.put(PROPERTY_BANNER_IMAGE_NAME, banner);
        }
        U updateOperation = this.getUpdateOperation();
        this.getExtensionParameters(updateOperation, request, props);
        ResourceResolver msmResolver = null;
        ResourceResolver userManagerResolver = null;
        try {
            msmResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            userManagerResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            Resource resource2 = this.update(this.siteBlueprintService, resource, group, props, banner, groupThumbnail, groupCSS, session, msmResolver, userManagerResolver, this.funcDefUtils);
            return resource2;
        }
        catch (LoginException e) {
            LOG.error("Failed to login as service user.", e);
            throw new OperationException(e, 500);
        }
        finally {
            if (msmResolver != null) {
                msmResolver.close();
            }
            if (userManagerResolver != null) {
                userManagerResolver.close();
            }
        }
    }

    protected Resource update(TemplateRolloutService siteBlueprintService, Resource root, CommunityGroup group, Map<String, Object> properties, List<DataSource> attachments, List<DataSource> groupThumbnail, List<DataSource> groupCSS, Session session, ResourceResolver msmResolver, ResourceResolver userManagerResolver, FunctionDefinitionUtils funcDefUtils) throws OperationException {
        if (ResourceUtil.isNonExistingResource(root)) {
            throw new OperationException("Invalid group resource '" + root.getPath() + "'", 400);
        }
        if (group == null) {
            throw new OperationException("Invalid community group " + root.getPath(), 400);
        }
        try {
            SocialComponentFactory factory;
            U updateOperation = this.getUpdateOperation();
            this.performBeforeActions(updateOperation, session, root, properties);
            Resource siteRoot = this.updateGroup(siteBlueprintService, group, attachments, groupThumbnail, groupCSS, properties, msmResolver, userManagerResolver, funcDefUtils);
            if (msmResolver.hasChanges()) {
                msmResolver.commit();
            }
            CommunityGroup updatedGroup = (CommunityGroup)((factory = this.componentFactoryManager.getSocialComponentFactory(root)) != null ? factory.getSocialComponent(root) : null);
            this.performAfterActions(updateOperation, session, updatedGroup, properties);
            return siteRoot;
        }
        catch (OperationException e) {
            this.cleanupFailure(session);
            throw e;
        }
        catch (Exception e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to update community site.", e, 500);
        }
    }

    private boolean validateFunctionValue(String structureString) {
        if (StringUtils.isBlank(structureString)) {
            return false;
        }
        try {
            JSONObject structure = new JSONObject(structureString);
            JSONArray functions = structure.getJSONArray("functions");
            return functions.length() > 0;
        }
        catch (JSONException e) {
            LOG.debug("Malformed json for Function property {}", (Object)structureString, (Object)e);
            return false;
        }
    }

    private void updateGroupStructure(TemplateRolloutService siteBlueprintService, Node configNode, Resource site, String structureString, ResourceResolver resolver, FunctionDefinitionUtils funcDefUtils) throws JSONException, RepositoryException, PersistenceException, WCMException, OperationException {
        JSONObject structure = new JSONObject(structureString);
        if (structure.has("functions")) {
            PageManager pageMgr = resolver.adaptTo(PageManager.class);
            JSONArray functions = structure.getJSONArray("functions");
            JSONArray newStructure = new JSONArray();
            ArrayList<String> deletedPages = new ArrayList<String>(3);
            if (functions.length() > 0) {
                SiteOperationUtils groupOperationUtils = SiteOperationUtils.getInstance();
                groupOperationUtils.applyActions(siteBlueprintService, site, resolver, funcDefUtils, functions, newStructure);
                groupOperationUtils.reorderFunctions(siteBlueprintService, functions, site, resolver, configNode.getProperty("blueprint").getString(), deletedPages);
                Node functionsNode = funcDefUtils.createFunctions(newStructure, configNode, resolver);
                groupOperationUtils.deleteFunctions(functionsNode, deletedPages, site, pageMgr, resolver);
                groupOperationUtils.applyConfigurations(siteBlueprintService, functionsNode, site, resolver);
            }
        }
    }

    protected Resource updateGroup(TemplateRolloutService siteBlueprintService, CommunityGroup group, List<DataSource> attachments, List<DataSource> groupThumbnail, List<DataSource> siteCSS, Map<String, Object> properties, ResourceResolver msmResolver, ResourceResolver userManagerResolver, FunctionDefinitionUtils funcDefUtils) throws OperationException {
        ResourceResolver resolver = group.getResource().getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        try {
            Session msmSession = msmResolver.adaptTo(Session.class);
            Session userManagerSession = userManagerResolver.adaptTo(Session.class);
            String siteName = (String)properties.get(NAME);
            CommunityContext context = group.getResource().adaptTo(CommunityContext.class);
            Node configNode = msmSession.getNode(group.getResource().getPath());
            String title = (String)properties.get(NAME);
            String description = (String)properties.get("jcr:description");
            String type = (String)properties.get("type");
            if (StringUtils.isBlank(siteName)) {
                siteName = (String)properties.get("urlName");
            }
            String currentThemeId = "";
            if (configNode.hasProperty("theme")) {
                currentThemeId = configNode.getProperty("theme").getString();
            }
            if (StringUtils.isBlank(currentThemeId)) {
                currentThemeId = "/libs/clientlibs/social/themes/sitethemes/bootstrap-default/clientlibs";
            }
            U operation = this.getUpdateOperation();
            Resource groupRoot = msmResolver.getResource(group.getResource().getPath()).getParent();
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                String key = property.getKey();
                if (!this.isConfigurationParameter(operation, key) || !this.isUpdatedParameter(key, property.getValue(), configNode)) continue;
                if (!ArrayUtils.contains(this.fieldWhitelist, key)) {
                    if (StringUtils.equals("functions", key)) {
                        if (!this.validateFunctionValue((String)property.getValue())) continue;
                        JcrUtil.setProperty(configNode, key, property.getValue());
                        continue;
                    }
                    JcrUtil.setProperty(configNode, key, property.getValue());
                    continue;
                }
                if (configNode.hasProperty(key)) {
                    if (!configNode.getProperty(key).getClass().equals(property.getValue().getClass())) {
                        configNode.getProperty(key).remove();
                        JcrUtil.setProperty(configNode, key, property.getValue());
                        continue;
                    }
                    JcrUtil.setProperty(configNode, key, property.getValue());
                    continue;
                }
                JcrUtil.setProperty(configNode, key, property.getValue());
            }
            ValueMapDecorator props = new ValueMapDecorator(properties);
            props.put("blueprint", configNode.getProperty("blueprint").getString());
            props.put("groupId", configNode.getProperty("groupId").getString());
            if (configNode.hasProperty("invite")) {
                props.put("invite", configNode.getProperty("invite").getString());
            }
            props.put("type", configNode.getProperty("type").getString());
            props.put("urlName", configNode.getProperty("urlName").getString());
            props.put("owner", configNode.getProperty("owner").getString());
            this.communityGroupService.prepareUserGroups(userManagerResolver, groupRoot, groupRoot.getParent().getPath(), props);
            String structureString = (String)properties.get("functions");
            if (!StringUtils.isEmpty(structureString)) {
                try {
                    this.updateGroupStructure(siteBlueprintService, configNode, group.getResource().getParent(), structureString, msmResolver.getResource(group.getResource().getPath()).getResourceResolver(), funcDefUtils);
                    ModifiableValueMap pageProps = userManagerResolver.getResource(group.getResource().getParent().getPath()).getChild("jcr:content").adaptTo(ModifiableValueMap.class);
                    pageProps.put("jcr:title", siteName);
                    pageProps.put("pageTitle", siteName);
                }
                catch (JSONException e) {
                    throw new OperationException("Malformed group structure", e, 400);
                }
            }
            this.communityGroupService.setCommunityGroupConfigure(msmResolver, groupRoot.getPath(), props);
            Node photoFolder = configNode.getParent().hasNode("photos") ? configNode.getParent().getNode("photos") : configNode.getParent().addNode("photos", "sling:Folder");
            String themeId = (String)PropertiesUtils.get(properties, (String)"theme", (Object)currentThemeId);
            if (group.isUsingCustomCSS() && !themeId.equals(currentThemeId)) {
                try {
                    Node themeNode = session.getNode(currentThemeId);
                    if (themeNode != null) {
                        themeNode.remove();
                    }
                }
                catch (PathNotFoundException e) {
                    LOG.error("Path not found", e);
                }
            }
            Node image = null;
            String photoFolderPath = photoFolder.getPath();
            for (DataSource ds : groupThumbnail) {
                image = AbstractCommunityGroupOperationService.addThemeAsset(userManagerResolver, context, photoFolderPath, ds.getName(), resolver.adaptTo(Session.class).getValueFactory().createBinary(ds.getInputStream()), ds.getContentType());
            }
            Node groupThumbnailImage = this.createThumbnailAsset(groupThumbnail, groupRoot, userManagerResolver, context);
            Node groupCSSNode = this.createCSSAsset(siteCSS, userManagerSession, context);
            if (groupCSSNode != null) {
                JcrUtil.setProperty(configNode, "theme", groupCSSNode.getPath());
            } else {
                String themeProp = (String)PropertiesUtils.get(properties, (String)"theme", (Object)"/libs/clientlibs/social/themes/sitethemes/bootstrap-default/clientlibs");
                JcrUtil.setProperty(configNode, "theme", themeProp);
            }
            this.updateImage(groupRoot, groupThumbnail, PROPERTY_IMAGE_NAME);
            this.updateImage(groupRoot, attachments, PROPERTY_BANNER_IMAGE_NAME);
            this.updateImage(groupRoot, (List)properties.get("file"), PROPERTY_IMAGE_NAME);
            JcrUtil.setProperty(configNode, "jcr:lastModified", Calendar.getInstance());
            session.save();
            return resolver.getResource(configNode.getPath());
        }
        catch (Exception e) {
            LOG.error("Error updating Community site.", e);
            throw new OperationException("Error updating community site.", e, 500);
        }
    }

    @Nullable
    private Node createCSSAsset(List<DataSource> siteThumbnail, Session session, CommunityContext context) throws RepositoryException, IOException {
        String absolutePath = context.getPageThemePath();
        String nodeType = "cq:ClientLibraryFolder";
        for (DataSource cssFile : siteThumbnail) {
            boolean isCss = cssFile.getContentType().equalsIgnoreCase("text/css");
            if (!isCss) continue;
            String assetName = JcrUtil.createValidName(cssFile.getName());
            Node assetRootNode = JcrUtil.createPath(absolutePath, false, "sling:Folder", "sling:Folder", session, false);
            Node assetNode = JcrUtil.createUniqueNode(assetRootNode, assetName, "cq:ClientLibraryFolder", session);
            Node cssNode = JcrUtils.putFile(assetNode, assetName, "text/css", cssFile.getInputStream());
            String themeCategoryName = "cq.social.console.theme.custom." + context.getCommunityGroupUniqueId() + "." + assetNode.getName();
            if (context.isMultiTenantSupported()) {
                themeCategoryName = "cq.social.console.theme.custom." + context.getTenantId() + "." + context.getSiteId() + "." + assetNode.getName();
            }
            JcrUtil.setProperty(assetNode, "categories", new String[]{themeCategoryName});
            JcrUtils.putFile(assetNode, "css.txt", "text/plain", new ByteArrayInputStream(cssNode.getName().getBytes()));
            return assetNode;
        }
        return null;
    }

    protected static Node addThemeAsset(ResourceResolver resolver, CommunityContext context, String photoFolderPath, String name, Binary data, String contentType) throws OperationException {
        Session session = resolver.adaptTo(Session.class);
        try {
            Node photoRootNode = JcrUtils.getOrCreateByPath(photoFolderPath, "sling:Folder", resolver.adaptTo(Session.class));
            if (photoRootNode.hasNode(PROPERTY_IMAGE_NAME)) {
                photoRootNode.getNode(PROPERTY_IMAGE_NAME).remove();
                resolver.adaptTo(Session.class).save();
            }
            return AbstractCommunityGroupOperationService.createFile(resolver, PROPERTY_IMAGE_NAME, data, contentType, photoRootNode, "", name, context);
        }
        catch (RepositoryException e) {
            try {
                session.refresh(false);
            }
            catch (RepositoryException e1) {
                LOG.error("Repository error while adding theme asset.");
                throw new OperationException("Repository error while adding theme asset.", 500);
            }
            LOG.error("Repository error while adding theme asset.");
            throw new OperationException("Repository error while adding theme asset.", 500);
        }
    }

    private Node createThumbnailAsset(List<DataSource> siteThumbnail, Resource site, ResourceResolver resolver, CommunityContext context) throws RepositoryException, IOException {
        if (siteThumbnail != null && !siteThumbnail.isEmpty()) {
            Iterator<DataSource> iterator;
            Node siteNode = site.getChild("jcr:content").adaptTo(Node.class);
            if (siteNode.hasNode(PROPERTY_IMAGE_NAME)) {
                Node fileNode = siteNode.getNode(PROPERTY_IMAGE_NAME);
                fileNode.remove();
                resolver.adaptTo(Session.class).save();
            }
            if ((iterator = siteThumbnail.iterator()).hasNext()) {
                DataSource ds = iterator.next();
                return AbstractCommunityGroupOperationService.createFile(resolver, "file", resolver.adaptTo(Session.class).getValueFactory().createBinary(ds.getInputStream()), ds.getContentType(), siteNode, PROPERTY_IMAGE_NAME, ds.getName(), context);
            }
        }
        return null;
    }

    protected static Node createFile(ResourceResolver resolver, String name, Binary data, String contentType, Node themeIdNode, String assetRootName, String fileNameProperty, CommunityContext context) throws RepositoryException {
        Node resNode;
        Node assetNode;
        int pos;
        Session session = resolver.adaptTo(Session.class);
        boolean isCss = contentType.equalsIgnoreCase("text/css");
        String nodeType = "nt:unstructured";
        boolean createUniqueLeaf = false;
        String aRootName = assetRootName;
        Node assetRootNode = JcrUtil.createPath(themeIdNode, aRootName, false, "nt:unstructured", "nt:unstructured", session, false);
        String assetName = name;
        if (assetName == null) {
            assetName = "a" + System.currentTimeMillis() + ".bin";
        } else {
            int pos2 = assetName.lastIndexOf(47);
            if (pos2 < 0) {
                pos2 = assetName.lastIndexOf(92);
            }
            if (pos2 >= 0) {
                assetName = name.substring(pos2 + 1);
            }
        }
        String assetContentType = contentType;
        if (assetContentType == null) {
            assetContentType = "application/octet-stream";
        }
        if ((pos = assetContentType.indexOf(59)) > 0) {
            assetContentType = assetContentType.substring(0, pos);
        }
        String fileNameWithoutExtension = FilenameUtils.getBaseName(assetName);
        String fileNameExtension = FilenameUtils.getExtension(assetName);
        fileNameWithoutExtension = JcrUtil.isValidName(fileNameWithoutExtension) ? fileNameWithoutExtension : JcrUtil.createValidName(fileNameWithoutExtension);
        String fileName = "";
        fileName = StringUtils.isBlank(fileNameExtension) ? fileNameWithoutExtension : fileNameWithoutExtension + "." + fileNameExtension;
        if (assetRootNode.hasNode(fileName)) {
            assetNode = assetRootNode.getNode(fileName);
            resNode = assetNode.getNode("jcr:content");
        } else {
            assetNode = assetRootNode.addNode(fileName, NODE_PROPERTY_COMMENTATTACHMENT);
            resNode = assetNode.addNode("jcr:content", "nt:resource");
        }
        resNode.setProperty("jcr:mimeType", assetContentType);
        resNode.setProperty("jcr:data", data);
        resNode.setProperty("jcr:lastModified", Calendar.getInstance());
        assetNode.setProperty(NAME, fileNameProperty);
        return assetNode;
    }

    private Node getThemeNode(CommunityContext context, String themeId, Session session) throws PathNotFoundException, RepositoryException {
        String themePath = context.getSiteThemePath() + 47 + themeId;
        return session.getNode(themePath);
    }

    protected void updateImage(Resource groupRoot, List<DataSource> dataSources, String name) throws OperationException {
        if (dataSources != null && !dataSources.isEmpty()) {
            Resource imgResource = groupRoot.getChild("photos/" + name);
            DataSource dataSource = dataSources.get(0);
            try {
                if (imgResource != null) {
                    Node bannerNode = imgResource.adaptTo(Node.class);
                    if (bannerNode != null && StringUtils.isNotBlank(dataSource.getName())) {
                        bannerNode.setProperty(NAME, dataSource.getName());
                    }
                    Node imageContentNode = bannerNode.getNode("jcr:content");
                    Binary data = groupRoot.getResourceResolver().adaptTo(Session.class).getValueFactory().createBinary(dataSource.getInputStream());
                    imageContentNode.setProperty("jcr:mimeType", dataSource.getContentType());
                    imageContentNode.setProperty("jcr:data", data);
                    imageContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                } else {
                    Resource photos = groupRoot.getChild("photos");
                    if (photos == null) {
                        Node groupRootNode = groupRoot.adaptTo(Node.class);
                        groupRootNode.addNode("photos", "sling:Folder");
                    }
                    this.addImage(groupRoot.getPath() + "/" + "photos", groupRoot.getResourceResolver(), dataSource.getInputStream(), dataSource.getContentType(), name, dataSource.getName());
                }
            }
            catch (RepositoryException e) {
                throw new OperationException("Failed to create image " + name, e, 500);
            }
            catch (IOException e) {
                throw new OperationException("Failed to read image " + name, e, 500);
            }
        }
    }

    protected boolean isConfigurationParameter(U operation, String parameterName) throws OperationException {
        for (String key : unchangeableParams) {
            if (!key.equals(parameterName)) continue;
            return false;
        }
        if (this.extensionProviders.containsKey(operation)) {
            for (CommunityGroupOperationExtension extension : (SortedSet)this.extensionProviders.get(operation)) {
                try {
                    return extension.isConfigurationParameter((Operation)operation, parameterName);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                }
            }
        }
        return true;
    }

    @Override
    protected void getExtensionParameters(U operation, SlingHttpServletRequest request, Map<String, Object> requestParameters) throws OperationException {
        if (this.extensionProviders.containsKey(operation)) {
            for (CommunityGroupOperationExtension extension : (SortedSet)this.extensionProviders.get(operation)) {
                try {
                    extension.getExtensionRequestParameters((Operation)operation, request, requestParameters);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
            }
        }
    }

    private boolean isUpdatedParameter(String key, Object value, Node configNode) throws RepositoryException {
        if (configNode.hasProperty(key)) {
            Property prop = configNode.getProperty(key);
            if (!prop.isMultiple()) {
                Value currentValue = prop.getValue();
                Value newValue = JcrUtil.createValue(value, configNode.getSession());
                if (newValue != null) {
                    return !newValue.equals(currentValue);
                }
                return true;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean isPublishMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("publish");
    }

    @Override
    public boolean approveJoin(ResourceResolver resolver, CommunityGroup group) throws OperationException {
        Session session = resolver.adaptTo(Session.class);
        if (StringUtils.endsWithIgnoreCase(session.getUserID(), "anonymous")) {
            return false;
        }
        return group != null && "Open".equals(group.getType());
    }

    @Override
    public Resource join(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String groupUrl = request.getParameter(PATH);
        if (StringUtils.isBlank(groupUrl)) {
            return null;
        }
        Resource groupPageResource = resolver.resolve(groupUrl);
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        return this.join(resolver, group, session);
    }

    protected Resource join(ResourceResolver resolver, CommunityGroup group, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return null;
        }
        if (!this.approveJoin(resolver, group)) {
            throw new OperationException("Deny " + session.getUserID() + "'s request to join community group " + group.getName(), 406);
        }
        ResourceResolver userAdminResolver = null;
        try {
            String authorizableId = session.getUserID();
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            this.groupService.addGroupMember(userAdminResolver, group.getMemberGroupId(), authorizableId);
            resolver.adaptTo(Session.class).refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
        return group.getResource();
    }

    @Override
    public Resource leave(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String groupUrl = request.getParameter(PATH);
        if (StringUtils.isBlank(groupUrl)) {
            return null;
        }
        Resource groupPageResource = resolver.resolve(groupUrl);
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        return this.leave(resolver, group, session);
    }

    protected Resource leave(ResourceResolver resolver, CommunityGroup group, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return null;
        }
        ResourceResolver userAdminResolver = null;
        try {
            String authorizableId = session.getUserID();
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            this.groupService.removeGroupMember(userAdminResolver, group.getMemberGroupId(), authorizableId);
            resolver.adaptTo(Session.class).refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
        return group.getResource();
    }

    @Override
    public Resource invite(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String[] inviteList = request.getParameterValues("users");
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        Resource groupPageResource = resolver.resolve(context.getCommunityGroupPath());
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        this.invite(resolver, group, inviteList, context, session);
        return resource;
    }

    protected void invite(ResourceResolver resolver, CommunityGroup group, String[] inviteList, CommunityContext context, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return;
        }
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            UserManager um = ((JackrabbitSession)userAdminResolver.adaptTo(Session.class)).getUserManager();
            if (!GroupUtil.canInviteGroupMember(resolver, context, this.serviceUserWrapper, this.repository, um)) {
                throw new OperationException("Deny " + session.getUserID() + "'s request to invite users to community group " + group.getName(), 406);
            }
            this.groupService.addGroupMembers(userAdminResolver, group.getMemberGroupId(), inviteList);
            session.refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    @Override
    public Resource uninvite(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String invite = request.getParameter("users");
        if (StringUtils.isEmpty(invite)) {
            return null;
        }
        String[] inviteList = invite.split("[\\s,;]");
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        Resource groupPageResource = resolver.resolve(context.getCommunityGroupPath());
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        this.uninvite(resolver, group, inviteList, context, session);
        return resource;
    }

    protected void uninvite(ResourceResolver resolver, CommunityGroup group, String[] inviteList, CommunityContext context, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return;
        }
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            UserManager um = ((JackrabbitSession)userAdminResolver.adaptTo(Session.class)).getUserManager();
            if (!GroupUtil.canInviteGroupMember(resolver, context, this.serviceUserWrapper, this.repository, um)) {
                throw new OperationException("Deny " + session.getUserID() + "'s request to invite users to community group " + group.getName(), 406);
            }
            this.groupService.removeGroupMembers(userAdminResolver, group.getMemberGroupId(), inviteList);
            session.refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to uninvite member from community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to uninvite member from community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    @Override
    public Resource promoteMember(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String[] inviteList = request.getParameterValues("users");
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        Resource groupPageResource = resolver.resolve(context.getCommunityGroupPath());
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        LOG.debug("promoteMember: resource {} groupPageResource {}", (Object)resource, (Object)groupPageResource);
        LOG.debug("promoteMember: communityGroupPath {}", (Object)context.getCommunityGroupPath());
        this.promoteMember(resolver, group, context, inviteList, session);
        return resource;
    }

    protected void promoteMember(ResourceResolver resolver, CommunityGroup group, CommunityContext context, String[] inviteList, Session session) throws OperationException {
        String groupAdminID = context.getSiteUserGroupName(CommunityUserGroup.GROUP_ADMIN);
        if (LOG.isDebugEnabled()) {
            LOG.debug("promoteMember: {} to {}", (Object)Arrays.asList(inviteList), (Object)groupAdminID);
        }
        if (resolver == null) {
            throw new IllegalArgumentException("resolver not allowed to be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("group not allowed to be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("session not allowed to be null");
        }
        LOG.debug("promoteMember: {} is authorized.", (Object)resolver.getUserID());
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            UserManager um = ((JackrabbitSession)userAdminResolver.adaptTo(Session.class)).getUserManager();
            if (!GroupUtil.canPromoteGroupMember(resolver, context, this.serviceUserWrapper, this.repository, um)) {
                throw new OperationException("Deny " + session.getUserID() + "'s request to invite users to community group " + group.getName(), 406);
            }
            LOG.debug("promoteMember: calling addGroupMembers adding {} to {}.", (Object)Arrays.asList(inviteList), (Object)groupAdminID);
            this.groupService.addGroupMembers(userAdminResolver, groupAdminID, inviteList);
            session.refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    @Override
    public Resource demoteMember(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String[] inviteList = request.getParameterValues("users");
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        Resource groupPageResource = resolver.resolve(context.getCommunityGroupPath());
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        this.demoteMember(resolver, group, context, inviteList, session);
        return resource;
    }

    protected void demoteMember(ResourceResolver resolver, CommunityGroup group, CommunityContext context, String[] inviteList, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return;
        }
        String groupAdminID = context.getSiteUserGroupName(CommunityUserGroup.GROUP_ADMIN);
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            UserManager um = ((JackrabbitSession)userAdminResolver.adaptTo(Session.class)).getUserManager();
            if (!GroupUtil.canPromoteGroupMember(resolver, context, this.serviceUserWrapper, this.repository, um)) {
                throw new OperationException("Deny " + session.getUserID() + "'s request to invite users to community group " + group.getName(), 406);
            }
            this.groupService.removeGroupMembers(userAdminResolver, groupAdminID, inviteList);
            this.groupService.addGroupMembers(userAdminResolver, group.getMemberGroupId(), inviteList);
            session.refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    private boolean isSpecialRequestParam(String paramName) {
        for (int i = 0; i < specialParams.length; ++i) {
            if (!paramName.equals(specialParams[i])) continue;
            return true;
        }
        return false;
    }

    protected void addCSS(String path, ResourceResolver resolver, InputStream imageStream, String contentType, String nodeName, String nameProperty) throws OperationException, RepositoryException {
        try {
            if (imageStream != null && imageStream.available() > 0) {
                Resource folder = ResourceUtil.getOrCreateResource(resolver, path, "sling:Folder", null, true);
                Node folderNode = folder.adaptTo(Node.class);
                Node groupthemesFolder = folderNode.addNode("groupthemes");
                Node cssNode = groupthemesFolder.addNode(nameProperty);
                Node cssFiles = JcrUtils.putFile(cssNode, nameProperty, "text/css", imageStream);
                JcrUtils.putFile(cssNode, "css.txt", "text/plain", new ByteArrayInputStream(cssFiles.getName().getBytes()));
            }
        }
        catch (IOException e) {
            throw new OperationException("IO failure", e, 500);
        }
    }

    protected void addImage(String path, ResourceResolver resolver, InputStream imageStream, String contentType, String nodeName, String nameProperty) throws OperationException, RepositoryException {
        try {
            if (imageStream != null && imageStream.available() > 0) {
                Resource folder = ResourceUtil.getOrCreateResource(resolver, path, "sling:Folder", null, true);
                Node folderNode = folder.adaptTo(Node.class);
                Node imageNode = folderNode.addNode(nodeName, NODE_PROPERTY_COMMENTATTACHMENT);
                JcrUtil.setProperty(imageNode, NAME, nameProperty);
                Node imageContentNode = imageNode.addNode("jcr:content", "nt:resource");
                Binary data = resolver.adaptTo(Session.class).getValueFactory().createBinary(imageStream);
                imageContentNode.setProperty("jcr:mimeType", contentType);
                imageContentNode.setProperty("jcr:data", data);
                imageContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            }
        }
        catch (IOException e) {
            throw new OperationException("IO failure", e, 500);
        }
    }

    protected void replaceImage(Resource root, String name, ResourceResolver resolver, InputStream imageStream, String contentType) throws OperationException, RepositoryException {
        try {
            if (imageStream != null && imageStream.available() > 0) {
                Resource folder = root.getChild("sling:Folder");
                Node folderNode = folder.adaptTo(Node.class);
                Node imageNode = folderNode.getNode(name);
                Node imageContentNode = imageNode.addNode("jcr:content", "nt:resource");
                Binary data = resolver.adaptTo(Session.class).getValueFactory().createBinary(imageStream);
                imageContentNode.setProperty("jcr:mimeType", contentType);
                imageContentNode.setProperty("jcr:data", data);
                imageContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            }
        }
        catch (IOException e) {
            throw new OperationException("IO failure", e, 500);
        }
    }

    protected List<DataSource> getAttachmentsFromRequest(SlingHttpServletRequest request, String requestParameterName) {
        RequestParameter[] fileRequestParameters = request.getRequestParameters(requestParameterName);
        if (fileRequestParameters != null) {
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, Integer.MAX_VALUE, WHITE_LIST, BLACK_LIST);
        }
        return Collections.emptyList();
    }

    protected void getDefaultProperties(SlingHttpServletRequest request, Map<String, Object> props, boolean validateRequired) throws RepositoryException, OperationException {
        for (int i = 0; i < requestParams.length; ++i) {
            Object[] params = requestParams[i];
            Class clazz = (Class)params[1];
            String name = (String)params[0];
            if (clazz.isArray()) {
                Object[] values = request.getParameterValues(name);
                if (validateRequired && values == null && ((Boolean)params[2]).booleanValue()) {
                    throw new OperationException("Community group value '" + name + "' is empty", 400);
                }
                if (clazz != String[].class || values == null) continue;
                props.put(name, StringUtils.join(values, ","));
                continue;
            }
            String value = request.getParameter(name);
            if (validateRequired && value == null && ((Boolean)params[2]).booleanValue()) {
                throw new OperationException("Community group value '" + name + "' is empty", 400);
            }
            if (value == null) continue;
            props.put(name, GroupUtil.toObject(value, clazz));
        }
    }

    protected void getCustomProperties(SlingHttpServletRequest request, Map<String, Object> props, Session session) throws RepositoryException, OperationException {
    }

    private void addAllowedTemplate(String path, List<Object> allowedTemplates, ResourceResolver resolver) {
        Resource res = resolver.resolve(path);
        this.addAllowedTemplate(res, allowedTemplates, resolver);
    }

    private void addAllowedTemplate(Resource res, List<Object> allowedTemplates, ResourceResolver resolver) {
        ValueMap v;
        boolean isDisabled;
        if (res != null && !ResourceUtil.isNonExistingResource(res) && !(isDisabled = (v = res.adaptTo(ValueMap.class)).get("isDisabled", false).booleanValue())) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(PATH, res.getPath());
            data.put(NAME, (String)v.get("jcr:title"));
            allowedTemplates.add(data);
        }
    }

    private void addTemplatesUnderResource(String path, List<Object> allowedTemplates, ResourceResolver userAdminResolver) {
        Iterator<Resource> resourceIterator = null;
        if (path.startsWith("/")) {
            Resource templates = userAdminResolver.resolve(path);
            if (templates != null && templates.hasChildren()) {
                resourceIterator = templates.getChildren().iterator();
            }
        } else {
            Resource resource = userAdminResolver.getResource(CUSTOM_GROUP_TEMPLATE_ROOT_LIBS);
            Conf confMgr = resource.adaptTo(Conf.class);
            List<Resource> list = confMgr.getListResources(path);
            if (list != null) {
                resourceIterator = list.iterator();
            }
        }
        if (resourceIterator != null) {
            while (resourceIterator.hasNext()) {
                Resource res = resourceIterator.next();
                if (res == null || ResourceUtil.isNonExistingResource(res)) continue;
                ValueMap v = res.adaptTo(ValueMap.class);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(PATH, res.getPath());
                data.put(NAME, (String)v.get("jcr:title"));
                allowedTemplates.add(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getAllowedTemplateForEveryone(String[] paths) {
        ArrayList<Object> allowedTemplates = new ArrayList<Object>();
        ResourceResolver msmResolver = null;
        try {
            msmResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            if (paths != null && paths.length > 0) {
                for (int i = 0; i < paths.length; ++i) {
                    this.addAllowedTemplate(paths[i], allowedTemplates, msmResolver);
                }
            } else if (msmResolver.getResource(DEFAULT_GROUP_TEMPLATE_ROOT) != null) {
                this.addTemplatesUnderResource(CUSTOM_GROUP_TEMPLATE_ROOT, allowedTemplates, msmResolver);
                this.addTemplatesUnderResource(DEFAULT_GROUP_TEMPLATE_ROOT, allowedTemplates, msmResolver);
            } else {
                this.addTemplatesUnderResource(DEFAULT_GROUP_ROOTTEMPLATE_RELATIVIEPATH_ROOT, allowedTemplates, msmResolver);
            }
        }
        catch (LoginException e) {
            LOG.error("Failed to login as user admin.", e);
        }
        finally {
            if (msmResolver != null) {
                msmResolver.close();
            }
        }
        return allowedTemplates;
    }

    private CommunityGroupCollection getCommunityGroupCollectionForResource(Resource groupCollection, SlingHttpServletRequest request) {
        Resource resource;
        String path = groupCollection.getPath();
        if (!path.endsWith("configuration")) {
            path = path + "/" + "configuration";
        }
        if ((resource = request.getResourceResolver().getResource(path)) == null) {
            LOG.debug("getCommunityGroupCollectionForResource: Resource at {} not found with resolver for user {}", (Object)path, (Object)request.getResourceResolver().getUserID());
            return null;
        }
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(resource);
        if (factory == null) {
            LOG.debug("getCommunityGroupCollectionForResource: SocialComponentFactory responsible for {} not found.", (Object)resource.getPath());
            return null;
        }
        CommunityGroupCollection sc = (CommunityGroupCollection)factory.getSocialComponent(resource, request);
        if (sc == null) {
            LOG.debug("getCommunityGroupCollectionForResource: SocialComponentFactory {} returned null for {}.", (Object)sc, (Object)resource.getPath());
        }
        return sc;
    }

    @Override
    public SocialComponent getCommunityGroupComponentForResource(Resource communityGroup, SlingHttpServletRequest request) {
        Resource resource;
        String path = communityGroup.getPath();
        if (!path.endsWith("configuration")) {
            path = path + "/" + "configuration";
        }
        if ((resource = request.getResourceResolver().getResource(path)) == null) {
            LOG.debug("getCommunityGroupComponentForResource: Resource at {} not found with resolver for user {}", (Object)path, (Object)request.getResourceResolver().getUserID());
            return null;
        }
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(resource);
        if (factory == null) {
            LOG.debug("getCommunityGroupComponentForResource: SocialComponentFactory responsible for {} not found.", (Object)resource.getPath());
            return null;
        }
        SocialComponent sc = factory.getSocialComponent(resource, request);
        if (sc == null) {
            LOG.debug("getCommunityGroupComponentForResource: SocialComponentFactory {} returned null for {}.", (Object)sc, (Object)resource.getPath());
        }
        return sc;
    }

    @Override
    public SocialComponent getCommunityMemberListComponentForResource(Resource communityMembers, SlingHttpServletRequest request) {
        String path = communityMembers.getPath();
        Resource resource = request.getResourceResolver().getResource(path);
        if (resource == null) {
            return null;
        }
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(resource);
        return factory != null ? factory.getSocialComponent(resource, request) : null;
    }

    @Override
    protected CommunitySiteService getCommunitySiteService() {
        return this.siteService;
    }

    @Override
    protected SiteActivationService getActivationService() {
        return this.activationService;
    }

    @Override
    protected CommunityGroup getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        return (CommunityGroup)this.getCommunityGroupComponentForResource(resource, request);
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.fieldWhitelist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_FIELD_WHITELIST));
    }

    protected abstract U getCreateOperation();

    protected abstract U getUpdateOperation();

    protected abstract U getJoinOperation();

    protected abstract U getLeaveOperation();

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        this.replicator = asyncReverseReplicator;
    }

    protected void unbindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        if (this.replicator == asyncReverseReplicator) {
            this.replicator = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    protected void bindCommunityGroupService(CommunityGroupService communityGroupService) {
        this.communityGroupService = communityGroupService;
    }

    protected void unbindCommunityGroupService(CommunityGroupService communityGroupService) {
        if (this.communityGroupService == communityGroupService) {
            this.communityGroupService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindSiteService(CommunitySiteService communitySiteService) {
        this.siteService = communitySiteService;
    }

    protected void unbindSiteService(CommunitySiteService communitySiteService) {
        if (this.siteService == communitySiteService) {
            this.siteService = null;
        }
    }

    protected void bindActivationService(SiteActivationService siteActivationService) {
        this.activationService = siteActivationService;
    }

    protected void unbindActivationService(SiteActivationService siteActivationService) {
        if (this.activationService == siteActivationService) {
            this.activationService = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindFuncDefUtils(FunctionDefinitionUtils functionDefinitionUtils) {
        this.funcDefUtils = functionDefinitionUtils;
    }

    protected void unbindFuncDefUtils(FunctionDefinitionUtils functionDefinitionUtils) {
        if (this.funcDefUtils == functionDefinitionUtils) {
            this.funcDefUtils = null;
        }
    }

    protected void bindSiteBlueprintService(TemplateRolloutService templateRolloutService) {
        this.siteBlueprintService = templateRolloutService;
    }

    protected void unbindSiteBlueprintService(TemplateRolloutService templateRolloutService) {
        if (this.siteBlueprintService == templateRolloutService) {
            this.siteBlueprintService = null;
        }
    }
}

