/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf.core.operations;

import com.adobe.cq.social.scf.InheritedOperationExtension;
import com.adobe.cq.social.scf.InheritedOperationExtensionManager;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.OperationService;
import com.adobe.cq.social.scf.SocialComponent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperationService<T extends OperationExtension, U extends Operation, S>
implements OperationService<T, U, S> {
    protected final Map<U, SortedSet<T>> extensionProviders = new ConcurrentHashMap<U, SortedSet<T>>(10);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOperationService.class);

    @Override
    public synchronized void addOperationExtension(T extension) {
        for (Operation op : extension.getOperationsToHookInto()) {
            Operation operation = op;
            SortedSet<Object> providers = this.extensionProviders.containsKey(operation) ? this.extensionProviders.get(operation) : Collections.synchronizedSortedSet(new TreeSet(new Comparator<T>(){

                @Override
                public int compare(T a, T b) {
                    return a.getOrder() - b.getOrder();
                }
            }));
            providers.add(extension);
            this.extensionProviders.put(operation, providers);
        }
    }

    @Override
    public synchronized void removeOperationExtension(T extension) {
        for (Operation op : extension.getOperationsToHookInto()) {
            Operation operation = op;
            if (!this.extensionProviders.containsKey(operation)) continue;
            SortedSet<T> providers = this.extensionProviders.get(operation);
            providers.remove(extension);
            this.extensionProviders.put(operation, providers);
        }
    }

    @Override
    public InheritedOperationExtensionManager getInheritedOperationExtensionManager() {
        return null;
    }

    @Override
    public void performBeforeActions(U operation, Session session, Resource resource, Map<String, Object> requestParameters) throws OperationException {
        Collection<InheritedOperationExtension> extensions;
        InheritedOperationExtensionManager extensionManager;
        if (this.extensionProviders.containsKey(operation)) {
            for (OperationExtension extension : this.extensionProviders.get(operation)) {
                extension.beforeAction((Operation)operation, session, resource, requestParameters);
            }
        }
        if ((extensionManager = this.getInheritedOperationExtensionManager()) != null && (extensions = extensionManager.getOperationExtensions(resource)) != null) {
            for (InheritedOperationExtension extension : extensions) {
                List<Operation> hookedOperations = extension.getOperationsToHookInto();
                for (Operation op : hookedOperations) {
                    if (!op.toString().equals(operation.toString())) continue;
                    extension.beforeAction(op, session, resource, requestParameters);
                }
            }
        }
    }

    @Override
    public void performAfterActions(U operation, Session session, S component, Map<String, Object> requestParameters) throws OperationException {
        Collection<InheritedOperationExtension> extensions;
        Resource resource;
        InheritedOperationExtensionManager extensionManager;
        if (this.extensionProviders.containsKey(operation)) {
            for (OperationExtension extension : this.extensionProviders.get(operation)) {
                extension.afterAction((Operation)operation, session, component, requestParameters);
            }
        }
        if ((extensionManager = this.getInheritedOperationExtensionManager()) != null && (resource = component instanceof Resource ? (Resource)component : (component instanceof SocialComponent ? ((SocialComponent)component).getResource() : null)) != null && (extensions = extensionManager.getOperationExtensions(resource)) != null) {
            for (InheritedOperationExtension extension : extensions) {
                List<Operation> hookedOperations = extension.getOperationsToHookInto();
                for (Operation op : hookedOperations) {
                    if (!op.toString().equals(operation.toString())) continue;
                    extension.afterAction(op, session, component, requestParameters);
                }
            }
        }
    }

    protected Map<String, Object> getValueMapFromRequest(SlingHttpServletRequest request) throws RepositoryException {
        RequestParameterMap params = request.getRequestParameterMap();
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        for (String key : params.keySet()) {
            Object value;
            RequestParameter[] values = (RequestParameter[])params.get(key);
            if (values.length <= 0) continue;
            if (!key.equals("file")) {
                value = values.length == 1 ? values[0].getString() : request.getParameterValues(key);
                map.put(key, value);
                continue;
            }
            value = request.getRequestParameters(key);
            map.put(key, value);
        }
        return map;
    }

    protected String getReferrer(SlingHttpServletRequest request) {
        if (request != null) {
            String value = request.getHeader("referer");
            if (StringUtils.isEmpty(value)) {
                value = request.getParameter("referer");
            }
            if (StringUtils.isNotEmpty(value)) {
                try {
                    URL url = new URL(value);
                    return url.getFile();
                }
                catch (MalformedURLException e) {
                    LOG.debug("Failed to get referrer property.", e);
                }
            }
        }
        return null;
    }
}

