/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.api;

import com.adobe.cq.social.commons.Attachment;
import com.adobe.cq.social.console.utils.AttachmentUtils;
import com.adobe.cq.social.console.utils.ConsoleUtils;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.site.api.BaseSite;
import com.adobe.cq.social.site.api.CommunitySiteConstants;
import com.day.cq.wcm.api.Page;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public abstract class AbstractBaseSite
extends BaseSocialComponent
implements BaseSite {
    private final String description;
    private final String blueprintId;
    private final String creator;
    private final String theme;
    private final String siteThumbnail;
    private final String[] themeCategories;
    private final Calendar created;
    private final Calendar modified;
    private final String siteBannerUrl;
    private final String siteBannerImagePath;
    private final Resource siteBanner;

    public AbstractBaseSite(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        ValueMap propMap = resource.adaptTo(ValueMap.class);
        Resource parentResource = resource.getParent();
        this.description = this.getProperty("jcr:description", "");
        this.blueprintId = (String)((Object)this.getProperty("blueprint", String.class));
        this.creator = (String)((Object)this.getProperty("jcr:createdBy", String.class));
        this.theme = this.getProperty("theme", "/libs/clientlibs/social/themes/sitethemes/bootstrap-default/clientlibs");
        this.siteThumbnail = parentResource.getChild("jcr:content").getPath() + "/image/file";
        this.siteBannerImagePath = parentResource.getPath() + "/photos/image";
        this.siteBanner = resource.getResourceResolver().getResource(this.siteBannerImagePath);
        this.siteBannerUrl = this.siteBanner == null ? null : clientUtils.externalLink(this.siteBannerImagePath, false);
        Page page = parentResource.adaptTo(Page.class);
        this.created = (Calendar)((Object)propMap.get("jcr:created", Calendar.class));
        this.modified = page != null ? page.getLastModified() : this.created;
        this.themeCategories = this.initThemeCategories(resource.getResourceResolver());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getBlueprintId() {
        return this.blueprintId;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getThemeId() {
        return this.theme;
    }

    @Override
    public String[] getThemeCategory() {
        return this.themeCategories;
    }

    @Override
    public boolean isNew() {
        return ConsoleUtils.isNew((Calendar)this.created, (Calendar)this.modified);
    }

    @Override
    public Attachment getSiteThumbnail() {
        return this.getAttachment(this.siteThumbnail);
    }

    private Attachment getAttachment(String path) {
        Resource attResource = this.resource.getResourceResolver().getResource(path);
        return this.getAttachment(attResource);
    }

    protected Attachment getAttachment(Resource attResource) {
        if (attResource != null) {
            return AttachmentUtils.getAttachment((Resource)attResource, (ClientUtilities)this.clientUtils);
        }
        return null;
    }

    @Override
    public boolean isUsingCustomCSS() {
        String[] themes;
        for (String theme : themes = this.getThemeCategory()) {
            if (!StringUtils.contains((CharSequence)theme, "cq.social.console.theme.custom.")) continue;
            return true;
        }
        return false;
    }

    private String[] initThemeCategories(ResourceResolver resolver) {
        Resource clientLibResource;
        String theme = this.getThemeId();
        if (!StringUtils.isBlank(theme) && (clientLibResource = resolver.getResource(theme)) != null) {
            ValueMap clientLibResourceProperties = clientLibResource.adaptTo(ValueMap.class);
            return clientLibResourceProperties.get("categories", CommunitySiteConstants.DEFAULT_THEME);
        }
        return CommunitySiteConstants.DEFAULT_THEME;
    }

    @Override
    public Calendar getCreated() {
        return this.created;
    }

    @Override
    public Calendar getModified() {
        return this.modified;
    }

    @Override
    public String getSiteBannerUrl() {
        return this.siteBannerUrl;
    }

    @Override
    public Attachment getSiteBanner() {
        return this.getAttachment(this.siteBanner);
    }
}

