/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.api;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteWizardRenderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SiteWizardRenderUtil.class);

    public static void showCreateTenant(SlingHttpServletRequest request, Resource resource) {
        boolean allowed = false;
        UserManager um = resource.adaptTo(UserManager.class);
        try {
            Authorizable auth = um.getAuthorizable(resource.getResourceResolver().getUserID());
            if (!auth.isGroup() && ((User)auth).isAdmin()) {
                allowed = true;
            }
        }
        catch (RepositoryException e) {
            LOG.error("Error checking user admin", e);
        }
        request.setAttribute(RenderCondition.class.getName(), new SimpleRenderCondition(allowed));
    }

    public static void showCreateSite(SlingHttpServletRequest request, Resource resource) {
        boolean allowed = false;
        try {
            CommunityContext context = request.adaptTo(CommunityContext.class);
            UserManager um = resource.adaptTo(UserManager.class);
            if (context.checkIfUserIsAdmin(um, resource.getResourceResolver().getUserID())) {
                allowed = true;
            }
        }
        catch (RepositoryException e) {
            LOG.error("Error checking user admin", e);
        }
        catch (IllegalStateException e) {
            allowed = false;
            request.setAttribute(RenderCondition.class.getName(), new SimpleRenderCondition(allowed));
        }
        request.setAttribute(RenderCondition.class.getName(), new SimpleRenderCondition(allowed));
    }
}

