/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.endpoints;

import com.adobe.cq.social.blueprint.api.SiteActivationService;
import com.adobe.cq.social.blueprint.api.TemplateRolloutService;
import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.FunctionValidationUtil;
import com.adobe.cq.social.commons.bundleactivator.Activator;
import com.adobe.cq.social.commons.exception.FunctionValidationException;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.console.utils.CloudConfigUtils;
import com.adobe.cq.social.console.utils.api.FunctionDefinitionUtils;
import com.adobe.cq.social.console.utils.api.internal.PropertiesUtils;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.site.api.CommunitySite;
import com.adobe.cq.social.site.api.CommunitySiteService;
import com.adobe.cq.social.site.api.SiteConfigurator;
import com.adobe.cq.social.site.endpoints.AbstractPublishOperationService;
import com.adobe.cq.social.site.endpoints.SiteContentUtils;
import com.adobe.cq.social.site.endpoints.SiteOperationExtension;
import com.adobe.cq.social.site.endpoints.SiteOperationUtils;
import com.adobe.cq.social.site.endpoints.SiteOperations;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.confmgr.Conf;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.tenant.Tenant;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
@Properties(value={@org.apache.felix.scr.annotations.Property(name="fieldWhitelist", cardinality=100), @org.apache.felix.scr.annotations.Property(name="sitePathFilters", cardinality=100), @org.apache.felix.scr.annotations.Property(name="sitePackageGroup")})
public abstract class AbstractSiteOperationService<T extends SiteOperationExtension, U extends Operation>
extends AbstractPublishOperationService<T, U, CommunitySite>
implements SiteOperations {
    private static final String MSM_SERVICE = "msm-service";
    private static final String USER_ADMIN = "communities-user-admin";
    private static final String ACL_MANAGER = "communities-acl-manager";
    private static final String DAM_WRITER = "dam-writer";
    private static final String DAM_COLLECTION_SERVICE = "dam-collection-service";
    private static final String NODE_JCR_CONTENT = "jcr:content";
    private static final String PROPERTY_CQ_IS_COMMUNITY_SITE = "cq:isCommunitySite";
    private static final String PROPERTY_CQ_CLOUD_CONFIG_CONTEXT = "cq:conf";
    private static final String CONTENT_SITES = "/content/sites";
    private static final String SITES_ROOT_TITLE = "Community Sites";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSiteOperationService.class);
    private static final int PARAM_NAME_INDEX = 0;
    private static final int PARAM_CLASS_INDEX = 1;
    private static final int PARAM_REQUIRED_INDEX = 2;
    private static final Object[][] requestParams = new Object[][]{{"name", String.class, Boolean.FALSE}, {"jcr:description", String.class, Boolean.FALSE}, {"urlName", String.class, Boolean.TRUE}, {"siteRoot", String.class, Boolean.FALSE}, {"siteCloudConfig", String.class, Boolean.FALSE}, {"blueprint", String.class, Boolean.TRUE}, {"theme", String.class, Boolean.FALSE}, {"communitymanagers", String[].class, Boolean.FALSE}, {"admins", String[].class, Boolean.FALSE}, {"privilegedmembers", String[].class, Boolean.FALSE}, {"tagNameSpaces", String[].class, Boolean.FALSE}, {"moderateContent", Boolean.class, Boolean.FALSE}, {"commonStoreLanguage", String.class, Boolean.FALSE}, {"translationProviderConfig", String.class, Boolean.FALSE}, {"translationProvider", String.class, Boolean.FALSE}, {"groupAdmin", String[].class, Boolean.FALSE}, {"moderators", String[].class, Boolean.FALSE}, {"flagModerator", String.class, Boolean.FALSE}, {"createGroupPermission", String.class, Boolean.FALSE}, {"allowFacebook", Boolean.class, Boolean.FALSE}, {"allowTwitter", Boolean.class, Boolean.FALSE}, {"allowAnonymousAccess", Boolean.class, Boolean.FALSE}, {"allowUserRegistration", Boolean.class, Boolean.FALSE}, {"allowPrivateMessaging", Boolean.class, Boolean.FALSE}, {"baseLanguage", String.class, Boolean.FALSE}, {"initialLanguages", String[].class, Boolean.FALSE}, {"allowMachineTranslation", Boolean.class, Boolean.FALSE}, {"availableLanguages", String[].class, Boolean.FALSE}, {"persistTranslation", String.class, Boolean.FALSE}, {"fbconnectoauthid", String.class, Boolean.FALSE}, {"twitterconnectoauthid", String.class, Boolean.FALSE}, {"allowCaptcha", Boolean.class, Boolean.FALSE}, {"functions", String.class, Boolean.FALSE}, {"translatePageOrSection", String.class, Boolean.FALSE}, {"enableAnalytics", Boolean.class, Boolean.FALSE}, {"analyticsCloudConfigPath", String.class, Boolean.FALSE}, {"smartRender", String.class, Boolean.FALSE}};
    private static final String[] specialParams = new String[]{"availableLanguages", "tagNameSpaces", "functions"};
    private static final int ATTACHMENT_FILE_LIMIT = Integer.MAX_VALUE;
    private static final List<String> WHITE_LIST = new ArrayList<String>();
    private static final String[] BLACK_LIST = new String[0];
    private static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private SocialUtils socialUtils;
    @Reference
    private FunctionDefinitionUtils funcDefUtils;
    @Reference
    CommunitySiteService siteService;
    @Reference
    private SiteActivationService groupService;
    @Reference
    private SiteConfigurator siteConfigurator;
    private TemplateRolloutService siteBlueprintService;
    private ComponentContext context;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Packaging packaging;
    private static final String FILTER_SITE_ROOT_CONTENT = "[{\"root\":\"%s/jcr:content\",\"rules\":[]},";
    private static final String FILTER_SITE_ROOT_ACL = "{\"root\":\"%s/rep:policy\",\"rules\":[]},";
    private static final String FILTER_SITE_ROOT_FOLDER_CONF = "{\"root\":\"%s/folderConfiguration\",\"rules\":[]},";
    private static final String FILTER_SITE_PAGES = "{\"root\":\"%s\",\"rules\":[]},";
    private static final String FILTER_SITE_RESOURCES = "{\"root\":\"%s\",\"rules\":[]},";
    private static final String FILTER_SITE_UGC = "{\"root\":\"/content/usergenerated%s\",\"rules\":[],\"mode\":\"merge\"},";
    private static final String FILTER_SITE_THEME = "{\"root\":\"/libs/clientlibs/social/themes/%s\",\"rules\":[]},";
    private static final String FILTER_SITE_DAM = "{\"root\":\"/content/dam/%s\",\"rules\":[]},";
    private static final String FILTER_SITE_USER_GROUPS = "{\"root\":\"/home/groups/community/%s\",\"rules\":[]},";
    private static final String FILTER_SITE_TEMPLATES = "{\"root\":\"/conf/global/settings/community/templates\",\"rules\":[{\"modifier\":\"include\",\"pattern\":\"/conf/global/settings/community/templates/sites\"},{\"modifier\":\"include\",\"pattern\":\"/conf/global/settings/community/templates/groups\"},{\"modifier\":\"include\",\"pattern\":\"/conf/global/settings/community/templates/functions\"}],\"mode\":\"merge\"}]";
    public static final String CHARSET_PROPERTY = "_charset_";
    protected String[] fieldWhitelist;
    public static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";
    public static final String PROPERTY_FIELD_SITE_PATH_FILTERS = "sitePathFilters";
    public static final String PROPERTY_FIELD_PACKAGE_GROUP = "sitePackageGroup";
    protected String[] sitePathFiltersToPackage;
    protected String sitePackageGroup;

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
        this.fieldWhitelist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_FIELD_WHITELIST));
        this.sitePathFiltersToPackage = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_FIELD_SITE_PATH_FILTERS));
        this.sitePackageGroup = OsgiUtil.toString(context.getProperties().get(PROPERTY_FIELD_PACKAGE_GROUP), "export-socialcommunities");
        if (this.siteBlueprintService == null) {
            try {
                this.siteBlueprintService = (TemplateRolloutService)Activator.getService(TemplateRolloutService.class);
            }
            catch (IllegalStateException e) {
                LOG.info("BlueprintService is unavailable. To create/edit sites, please configure the RolloutManager service.", e);
            }
        }
    }

    private void cleanupFailure(Session session) {
        try {
            session.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.info("Failed to refresh the session", e);
        }
    }

    protected Resource create(Resource root, String name, Map<String, Object> requestParameters, List<DataSource> attachments, List<DataSource> cssFiles, List<DataSource> siteThumbnail, Session session, ResourceResolver msmResolver, ResourceResolver userManagerResolver, ResourceResolver aclResolver) throws OperationException {
        try {
            U createOperation = this.getCreateOperation();
            this.performBeforeActions(createOperation, session, root, requestParameters);
            List<Resource> siteRootList = this.createSite(root, name, attachments, cssFiles, siteThumbnail, requestParameters, msmResolver, userManagerResolver, aclResolver);
            String translationProvider = (String)requestParameters.get("translationProvider");
            String commonStoreLanguage = (String)requestParameters.get("commonStoreLanguage");
            if (StringUtils.isBlank(commonStoreLanguage) || commonStoreLanguage.equals("nc")) {
                commonStoreLanguage = "";
            }
            String translationProviderConfig = (String)requestParameters.get("translationProviderConfig");
            for (Resource siteRoot : siteRootList) {
                SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(siteRoot);
                CommunitySite site = (CommunitySite)(factory != null ? factory.getSocialComponent(siteRoot) : null);
                if (null != site && site.getConfiguration().getTranslationManagementConfiguration().isAllowMachineTranslation() && !StringUtils.isEmpty(translationProviderConfig)) {
                    CloudConfigUtils.applyCloudConfigToSite((CommunitySite)site, (ResourceResolver)root.getResourceResolver(), (String)translationProviderConfig, null);
                }
                this.siteConfigurator.setSiteLevelConfiguration(site, msmResolver, aclResolver, userManagerResolver, root.getResourceResolver());
                this.performAfterActions(createOperation, session, site, requestParameters);
            }
            return root;
        }
        catch (OperationException e) {
            this.cleanupFailure(session);
            throw e;
        }
        catch (Exception e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to create community site.", e, 500);
        }
    }

    protected Resource update(Resource siteResource, String name, Map<String, Object> requestParameters, List<DataSource> attachments, List<DataSource> siteThumbnail, List<DataSource> siteCSS, Session session, ResourceResolver msmResolver, ResourceResolver userManagerResolver, ResourceResolver aclResolver) throws OperationException {
        if (ResourceUtil.isNonExistingResource(siteResource)) {
            throw new OperationException("Invalid site resource '" + siteResource.getPath() + "'", 400);
        }
        Resource configResource = "configuration".equals(siteResource.getName()) ? siteResource : siteResource.getChild("configuration");
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(configResource);
        CommunitySite currentValue = (CommunitySite)(factory != null ? factory.getSocialComponent(configResource) : null);
        if (currentValue == null) {
            throw new OperationException("Failed to resolve updated community site " + name, 400);
        }
        try {
            U updateOperation = this.getUpdateOperation();
            this.performBeforeActions(updateOperation, session, configResource, requestParameters);
            Resource siteRoot = this.updateSite(configResource, name, attachments, siteThumbnail, siteCSS, requestParameters, currentValue, msmResolver, userManagerResolver, aclResolver);
            CommunitySite updatedSite = (CommunitySite)(factory != null ? factory.getSocialComponent(siteRoot) : null);
            this.siteConfigurator.setSiteLevelConfiguration(updatedSite, msmResolver, aclResolver, userManagerResolver, siteResource.getResourceResolver());
            this.performAfterActions(updateOperation, session, updatedSite, requestParameters);
            return siteRoot;
        }
        catch (OperationException e) {
            this.cleanupFailure(session);
            throw e;
        }
        catch (Exception e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to update community site.", e, 500);
        }
    }

    @Override
    public SocialComponent getSocialComponentForCommunitySite(Resource site, SlingHttpServletRequest request) {
        Resource resource = request.getResourceResolver().getResource(site.getPath());
        Resource siteComponent = !site.getPath().endsWith("configuration") ? resource.getChild("configuration") : resource;
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(siteComponent);
        return factory != null ? factory.getSocialComponent(siteComponent, request) : null;
    }

    @Override
    public CommunitySite getSocialComponent(Resource site, SlingHttpServletRequest request) {
        return (CommunitySite)this.getSocialComponentForCommunitySite(site, request);
    }

    /*
     * WARNING - void declaration
     */
    protected List<Resource> createSite(Resource tenantRoot, String name, List<DataSource> attachments, List<DataSource> cssFiles, List<DataSource> siteThumbnail, Map<String, Object> properties, ResourceResolver msmResolver, ResourceResolver userManagerResolver, ResourceResolver aclResolver) throws OperationException {
        ResourceResolver resolver = tenantRoot.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        if (StringUtils.equals(name, "resources")) {
            throw new OperationException("Illegal name, 'resources' is a reserved name and cannot be used for the name of site.", 400);
        }
        Node sitesRoot = this.getOrCreateSitesRootPage(tenantRoot.getPath(), resolver);
        try {
            boolean isLanguageInRoot;
            Session msmSession = msmResolver.adaptTo(Session.class);
            Session userManagerSession = userManagerResolver.adaptTo(Session.class);
            Session aclSession = aclResolver.adaptTo(Session.class);
            ArrayList<Resource> siteResources = new ArrayList<Resource>();
            String[] initialLanguages = null;
            String baseLang = (String)properties.get("baseLanguage");
            initialLanguages = StringUtils.isNotEmpty(baseLang) ? new String[]{baseLang} : (String[])properties.get("initialLanguages");
            String languageRoot = LanguageUtil.getLanguageRoot(tenantRoot.getPath());
            boolean bl = isLanguageInRoot = languageRoot != null;
            if (isLanguageInRoot) {
                initialLanguages = new String[]{Text.getName(languageRoot)};
            }
            for (int i = 0; i < initialLanguages.length; ++i) {
                String[] languages;
                Node siteCSSNode;
                String brandingImagePath;
                Node siteContentParentNode;
                void var27_34;
                String baseLanguage = initialLanguages[i];
                if (sitesRoot.hasNode(name) && sitesRoot.getNode(name).hasNode(baseLanguage)) {
                    throw new OperationException("Site with your selected language already exists", 409);
                }
                String siteId = SiteOperationUtils.generateUniqueSiteId(this.socialUtils, resolver, name, tenantRoot.getPath());
                String bluePrint = (String)properties.get("blueprint");
                String title = (String)properties.get("name");
                if (StringUtils.isBlank(title)) {
                    title = (String)properties.get("urlName");
                }
                if (isLanguageInRoot) {
                    String string = this.siteBlueprintService.rolloutBlueprint(msmSession, bluePrint, name, title, sitesRoot.getPath());
                } else {
                    if (StringUtils.isEmpty(baseLanguage)) {
                        baseLanguage = "en";
                    }
                    String string = this.siteBlueprintService.rolloutBlueprint(msmSession, bluePrint, name, title, sitesRoot.getPath(), baseLanguage);
                }
                Node site = resolver.getResource((String)var27_34).adaptTo(Node.class);
                Node configNode = site.addNode("configuration", "sling:Folder");
                U operation = this.getCreateOperation();
                for (Map.Entry<String, Object> property : properties.entrySet()) {
                    String key = property.getKey();
                    if (!this.isConfigurationParameter(operation, key) || key.equals("initialLanguages")) continue;
                    JcrUtil.setProperty(configNode, key, property.getValue());
                }
                if (null != configNode) {
                    String string = (String)properties.get("smartRender");
                    JcrUtil.setProperty(configNode, "smartRender", string);
                }
                if (null != configNode) {
                    JcrUtil.setProperty(configNode, "baseLanguage", baseLanguage);
                }
                Node node = isLanguageInRoot ? site.getNode(NODE_JCR_CONTENT) : site.getParent().getNode(NODE_JCR_CONTENT);
                JcrUtil.setProperty(node, PROPERTY_CQ_IS_COMMUNITY_SITE, true);
                JcrUtil.setProperty(configNode, SLING_RESOURCE_TYPE, "social/console/components/hbs/sitecollection/site");
                JcrUtil.setProperty(configNode, "siteId", siteId);
                String cloudConfigContext = (String)properties.get("siteCloudConfig");
                if (StringUtils.isNotBlank(cloudConfigContext)) {
                    JcrUtil.setProperty(site.getNode(NODE_JCR_CONTENT), PROPERTY_CQ_CLOUD_CONFIG_CONTEXT, cloudConfigContext);
                }
                if (node != null && (siteContentParentNode = node.getParent()) != null && !siteContentParentNode.hasNode("folderConfiguration")) {
                    siteContentParentNode.addNode("folderConfiguration", "sling:Folder");
                    Node siteContentParentconfigNode = siteContentParentNode.getNode("folderConfiguration");
                    JcrUtil.setProperty(siteContentParentconfigNode, SLING_RESOURCE_TYPE, "social/console/components/hbs/sitecollection/sitefolder");
                    JcrUtil.setProperty(siteContentParentconfigNode, "initialLanguages", initialLanguages);
                }
                Resource siteRes = resolver.getResource(site.getPath());
                Object anonymousAccess = properties.get("allowAnonymousAccess");
                Object moderators = properties.get("moderators");
                Object admins = properties.get("admins");
                Object communitymanagers = properties.get("communitymanagers");
                Object privilegedmembers = properties.get("privilegedmembers");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("allowAnonymousAccess", anonymousAccess);
                map.put("moderators", moderators);
                map.put("privilegedmembers", privilegedmembers);
                map.put("communitymanagers", communitymanagers);
                map.put("admins", admins);
                CommunityContext context = siteRes.adaptTo(CommunityContext.class);
                this.siteService.createSiteUserGroups(siteRes, context, msmSession, map, userManagerSession, aclSession);
                this.siteService.applyACLs(bluePrint, siteRes, context, msmSession, userManagerSession, aclSession);
                Node photoFolder = site.addNode("photos", "sling:Folder");
                String themeId = (String)PropertiesUtils.get(properties, (String)"theme", (Object)"/libs/clientlibs/social/themes/sitethemes/bootstrap-default/clientlibs");
                if (themeId.equals("")) {
                    themeId = "/libs/clientlibs/social/themes/sitethemes/bootstrap-default/clientlibs";
                    JcrUtil.setProperty(configNode, "theme", themeId);
                }
                if ((brandingImagePath = photoFolder.getPath()) != null && StringUtils.isNotEmpty(brandingImagePath)) {
                    Node image = null;
                    for (DataSource ds : attachments) {
                        image = AbstractSiteOperationService.addThemeAsset(resolver, context, brandingImagePath, ds.getName(), resolver.adaptTo(Session.class).getValueFactory().createBinary(ds.getInputStream()), ds.getContentType());
                        if (image != null) {
                            LOG.debug("Branding image got created at path" + image.getPath());
                            continue;
                        }
                        LOG.debug(" unable to create branding image at path" + image.getPath());
                    }
                }
                if ((siteCSSNode = this.createCSSAsset(cssFiles, session, context)) != null) {
                    JcrUtil.setProperty(configNode, "theme", siteCSSNode.getPath());
                }
                this.createThumbnailAsset(siteThumbnail, siteRes, resolver, context);
                String[] tags = (String[])properties.get("tagNameSpaces");
                if (tags != null) {
                    tags = this.trimTags(tags);
                    JcrUtil.setProperty(configNode, "tagNameSpaces", tags);
                }
                if ((languages = (String[])properties.get("availableLanguages")) != null) {
                    JcrUtil.setProperty(configNode, "availableLanguages", languages);
                }
                JcrUtil.setProperty(configNode, "commonStoreLanguages", initialLanguages);
                JcrUtil.setProperty(configNode, "jcr:lastModified", Calendar.getInstance());
                siteResources.add(resolver.getResource(configNode.getPath()));
            }
            Node content = sitesRoot.getNode(name).getNode(NODE_JCR_CONTENT);
            if (content != null) {
                String[] newValues = null;
                if (content.hasProperty("languageCopies")) {
                    Property props = content.getProperty("languageCopies");
                    Value[] values = props.getValues();
                    newValues = new String[values.length + initialLanguages.length];
                    int i = 0;
                    for (Value value : values) {
                        newValues[i++] = value.getString();
                    }
                    for (String string : initialLanguages) {
                        newValues[i++] = string;
                    }
                } else {
                    newValues = initialLanguages;
                }
                JcrUtil.setProperty(content, "languageCopies", newValues);
            }
            if (!isLanguageInRoot) {
                for (int j = 0; j < initialLanguages.length; ++j) {
                    String sub_title = (String)properties.get("name");
                    String baseLanguage = initialLanguages[j];
                    Locale locale = new Locale(baseLanguage);
                    String string = locale.getDisplayLanguage(locale);
                    String jcr_title = StringUtils.capitalize(string);
                    String set_jcr_title = sub_title + " (" + jcr_title + ")";
                    Node node = sitesRoot.getNode(name).getNode(baseLanguage).getNode(NODE_JCR_CONTENT);
                    if (node == null || !node.hasProperty("jcr:title")) continue;
                    JcrUtil.setProperty(node, "jcr:title", set_jcr_title);
                }
            }
            session.save();
            msmResolver.commit();
            return siteResources;
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error creating Community site.", e);
            throw new OperationException(e, 500);
        }
    }

    private void updateCloudConfig(Resource siteConfig, Map<String, Object> properties, ResourceResolver msmResolver, ResourceResolver userManagerResolver) throws OperationException {
        Resource site = siteConfig.getParent();
        Resource siteContent = site.getChild(NODE_JCR_CONTENT);
        Node siteContentNode = siteContent.adaptTo(Node.class);
        ValueMap vm = siteContent.adaptTo(ValueMap.class);
        String cloudConfigContext = (String)properties.get("siteCloudConfig");
        try {
            if (cloudConfigContext != null && siteContentNode != null && !cloudConfigContext.trim().equals("")) {
                JcrUtil.setProperty(siteContentNode, PROPERTY_CQ_CLOUD_CONFIG_CONTEXT, cloudConfigContext);
            }
        }
        catch (RepositoryException e) {
            throw new OperationException("Internal Operation failure.", 500);
        }
        String[] cloudConfigs = (String[])vm.get("cq:cloudserviceconfigs", String[].class);
        String cloudConfig = null;
        String translationProviderConfig = (String)properties.get("translationProviderConfig");
        if (cloudConfigs != null) {
            for (String config : cloudConfigs) {
                if (!config.startsWith("/libs/settings/cloudconfigs/translation/translationcfg")) continue;
                cloudConfig = config;
                break;
            }
        } else {
            cloudConfig = translationProviderConfig;
        }
        if (null != cloudConfig) {
            String translationProvider = (String)properties.get("translationProvider");
            String commonStoreLanguage = (String)properties.get("commonStoreLanguage");
            if (StringUtils.isBlank(commonStoreLanguage) || commonStoreLanguage.equals("nc")) {
                commonStoreLanguage = "";
            }
            try {
                CloudConfigUtils.updateCloudConfig((Resource)userManagerResolver.getResource(site.getPath()), (String)cloudConfig, (String)translationProvider, (String)commonStoreLanguage, (String)translationProviderConfig);
                Node siteConfigNode = msmResolver.getResource(siteConfig.getPath()).adaptTo(Node.class);
                JcrUtil.setProperty(siteConfigNode, "translationProvider", translationProvider);
                JcrUtil.setProperty(siteConfigNode, "commonStoreLanguage", commonStoreLanguage);
                if (!StringUtils.isEmpty(translationProviderConfig)) {
                    Resource cloudConfigResource;
                    CommunitySite communitySite = site.adaptTo(CommunitySite.class);
                    ResourceResolver rr = site.getResourceResolver();
                    if (rr != null && (cloudConfigResource = rr.getResource(translationProviderConfig)) != null) {
                        Resource cloudConfigResourceContent = cloudConfigResource.getChild(NODE_JCR_CONTENT);
                        ValueMap cloudConfigResourceContentValueMap = cloudConfigResourceContent.adaptTo(ValueMap.class);
                        String serviceName = (String)cloudConfigResourceContentValueMap.get("cq:servicename");
                        CloudConfigUtils.applyCloudConfigToSite((CommunitySite)communitySite, (ResourceResolver)msmResolver.getResource(site.getPath()).getResourceResolver(), (String)translationProviderConfig, (String)serviceName);
                    }
                }
            }
            catch (RepositoryException e) {
                throw new OperationException("Internal Operation failure.", 500);
            }
        }
    }

    private void updateSiteStructure(Node configNode, Resource site, String structureString, ResourceResolver resolver, FunctionDefinitionUtils funcDefUtils) throws JSONException, RepositoryException, PersistenceException, WCMException, OperationException {
        JSONObject structure = new JSONObject(structureString);
        PageManager pageMgr = resolver.adaptTo(PageManager.class);
        JSONArray functions = structure.getJSONArray("functions");
        JSONArray newStructure = new JSONArray();
        ArrayList<String> deletedPages = new ArrayList<String>(3);
        SiteOperationUtils siteOperationUtils = SiteOperationUtils.getInstance();
        siteOperationUtils.applyActions(this.siteBlueprintService, site, resolver, funcDefUtils, functions, newStructure);
        siteOperationUtils.reorderFunctions(this.siteBlueprintService, functions, site, resolver, configNode.getProperty("blueprint").getString(), deletedPages);
        Node functionsNode = funcDefUtils.createFunctions(newStructure, configNode, resolver);
        siteOperationUtils.deleteFunctions(functionsNode, deletedPages, site, pageMgr, resolver);
        siteOperationUtils.applyConfigurations(this.siteBlueprintService, functionsNode, site, resolver);
    }

    protected Resource updateSite(Resource site, String name, List<DataSource> attachments, List<DataSource> siteThumbnail, List<DataSource> siteCSS, Map<String, Object> properties, CommunitySite currentValue, ResourceResolver msmResolver, ResourceResolver userManagerResolver, ResourceResolver aclResolver) throws OperationException {
        ResourceResolver resolver = site.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        try {
            String[] availableLanguages;
            String structureString;
            Session msmSession = msmResolver.adaptTo(Session.class);
            Session userManagerSession = userManagerResolver.adaptTo(Session.class);
            Session aclSession = aclResolver.adaptTo(Session.class);
            String cloudConfigContext = (String)properties.get("siteCloudConfig");
            if (StringUtils.isNotBlank(cloudConfigContext)) {
                this.updateCloudConfig(site, properties, msmResolver, userManagerResolver);
            }
            CommunityContext context = site.adaptTo(CommunityContext.class);
            Node configNode = msmSession.getNode(site.getPath());
            String siteName = (String)properties.get("name");
            Boolean allowFB = (Boolean)properties.get("allowFacebook");
            Boolean allowTwitter = (Boolean)properties.get("allowTwitter");
            if ((allowFB == null || !allowFB.booleanValue()) && configNode.hasProperty("fbconnectoauthid")) {
                configNode.getProperty("fbconnectoauthid").remove();
            }
            if ((allowTwitter == null || !allowTwitter.booleanValue()) && configNode.hasProperty("twitterconnectoauthid")) {
                configNode.getProperty("twitterconnectoauthid").remove();
            }
            if (StringUtils.isBlank(siteName)) {
                siteName = (String)properties.get("urlName");
            }
            if (!StringUtils.isEmpty(structureString = (String)properties.get("functions"))) {
                try {
                    this.updateSiteStructure(configNode, site.getParent(), structureString, msmResolver, this.funcDefUtils);
                    ModifiableValueMap pageProps = msmResolver.getResource(site.getPath()).getParent().getChild(NODE_JCR_CONTENT).adaptTo(ModifiableValueMap.class);
                    pageProps.put("jcr:title", siteName);
                    pageProps.put("pageTitle", siteName);
                }
                catch (JSONException e) {
                    throw new OperationException("Malformed site structure", e, 400);
                }
            }
            String currentThemeId = "";
            if (configNode.hasProperty("theme")) {
                currentThemeId = configNode.getProperty("theme").getString();
            }
            if (StringUtils.isBlank(currentThemeId)) {
                currentThemeId = "/libs/clientlibs/social/themes/sitethemes/bootstrap-default/clientlibs";
            }
            U operation = this.getUpdateOperation();
            Resource msmSiteParent = msmResolver.getResource(site.getParent().getPath());
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                String key = property.getKey();
                if (!this.isConfigurationParameter(operation, key) || !this.isUpdatedParameter(key, property.getValue(), configNode)) continue;
                if (!ArrayUtils.contains(this.fieldWhitelist, key)) {
                    JcrUtil.setProperty(configNode, key, property.getValue());
                    continue;
                }
                if (configNode.hasProperty(key)) {
                    if (!configNode.getProperty(key).getClass().equals(property.getValue().getClass())) {
                        configNode.getProperty(key).remove();
                        JcrUtil.setProperty(configNode, key, property.getValue());
                        continue;
                    }
                    JcrUtil.setProperty(configNode, key, property.getValue());
                    continue;
                }
                JcrUtil.setProperty(configNode, key, property.getValue());
            }
            Object anonymousAccess = properties.get("allowAnonymousAccess");
            String[] groupAdmins = properties.get("groupAdmin");
            String[] moderators = properties.get("moderators");
            String[] communitymanagers = properties.get("communitymanagers");
            String[] privilegedmembers = properties.get("privilegedmembers");
            String[] communityAdmins = properties.get("admins");
            if (moderators == null && configNode.hasProperty("moderators")) {
                configNode.getProperty("moderators").remove();
            }
            if (communitymanagers == null && configNode.hasProperty("communitymanagers")) {
                configNode.getProperty("communitymanagers").remove();
            }
            if (privilegedmembers == null && configNode.hasProperty("privilegedmembers")) {
                configNode.getProperty("privilegedmembers").remove();
            }
            if (communityAdmins == null && configNode.hasProperty("admins")) {
                configNode.getProperty("admins").remove();
            }
            if (groupAdmins == null && configNode.hasProperty("groupAdmin")) {
                configNode.getProperty("groupAdmin").remove();
            }
            if (groupAdmins != null || moderators != null || privilegedmembers != null || communitymanagers != null || communityAdmins != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("allowAnonymousAccess", anonymousAccess);
                map.put("groupAdmin", groupAdmins != null ? groupAdmins : new String[]{});
                map.put("moderators", moderators != null ? moderators : new String[]{});
                map.put("privilegedmembers", privilegedmembers != null ? privilegedmembers : new String[]{});
                map.put("communitymanagers", communitymanagers != null ? communitymanagers : new String[]{});
                map.put("admins", communityAdmins != null ? communityAdmins : new String[]{});
                String bluePrint = (String)properties.get("blueprint");
                this.siteService.createSiteUserGroups(site, context, msmSession, map, userManagerSession, aclSession);
                this.siteService.applyACLs(bluePrint, site, context, msmSession, userManagerSession, aclSession);
            }
            String payload = "";
            payload = context.isMultiTenantSupported() ? context.getSitePayloadPath() + msmSiteParent.getPath() : context.getSitePayloadPath() + site.getPath();
            Node photoFolder = configNode.getParent().getNode("photos");
            String themeId = (String)PropertiesUtils.get(properties, (String)"theme", (Object)currentThemeId);
            if (currentValue.isUsingCustomCSS() && !themeId.equals(currentThemeId)) {
                try {
                    Node themeNode = msmSession.getNode(currentThemeId);
                    if (themeNode != null) {
                        themeNode.remove();
                    }
                }
                catch (PathNotFoundException e) {
                    LOG.error("Theme node path can not be found", e);
                }
            }
            if (StringUtils.isEmpty(themeId)) {
                themeId = currentThemeId;
            }
            Node image = null;
            String brandingImagePath = photoFolder.getPath();
            if (brandingImagePath != null && StringUtils.isNotEmpty(brandingImagePath)) {
                for (DataSource ds : attachments) {
                    image = AbstractSiteOperationService.addThemeAsset(msmResolver, context, brandingImagePath, ds.getName(), resolver.adaptTo(Session.class).getValueFactory().createBinary(ds.getInputStream()), ds.getContentType());
                    if (image != null) {
                        LOG.debug("Branding image got updated at path" + image.getPath());
                        continue;
                    }
                    LOG.debug(" unable to update branding image at path" + image.getPath());
                }
            }
            try {
                msmSession.save();
            }
            catch (RepositoryException e) {
                LOG.error("Error updating Community site.", e);
                throw new OperationException("Error updating community site.", e, 500);
            }
            Node siteThumbnailImage = this.createThumbnailAsset(siteThumbnail, msmSiteParent, msmResolver, context);
            Node siteCSSNode = this.createCSSAsset(siteCSS, msmSession, context);
            if (siteCSSNode != null) {
                JcrUtil.setProperty(configNode, "theme", siteCSSNode.getPath());
            } else {
                String themeProp = (String)PropertiesUtils.get(properties, (String)"theme", (Object)"/libs/clientlibs/social/themes/sitethemes/bootstrap-default/clientlibs");
                if (StringUtils.isEmpty(themeProp)) {
                    themeProp = themeId;
                }
                JcrUtil.setProperty(configNode, "theme", themeProp);
            }
            String[] tags = (String[])properties.get("tagNameSpaces");
            if (tags != null) {
                if ((tags = this.trimTags(tags)).length == 0) {
                    JcrUtil.setProperty(configNode, "tagNameSpaces", new String[0]);
                }
                JcrUtil.setProperty(configNode, "tagNameSpaces", tags);
            }
            if ((availableLanguages = (String[])properties.get("availableLanguages")) != null) {
                if (availableLanguages.length == 0) {
                    JcrUtil.setProperty(configNode, "availableLanguages", new String[0]);
                } else {
                    JcrUtil.setProperty(configNode, "availableLanguages", availableLanguages);
                }
            }
            JcrUtil.setProperty(configNode, "jcr:lastModified", Calendar.getInstance());
            this.updateDamFriendlyNames(context);
            msmSession.save();
            return resolver.getResource(configNode.getPath());
        }
        catch (Exception e) {
            LOG.error("Error updating Community site.", e);
            throw new OperationException("Error updating community site.", e, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDamFriendlyNames(CommunityContext context) throws PersistenceException, RepositoryException, LoginException {
        String siteTitle = context.getSiteName();
        ResourceResolver damWriterResolver = null;
        ResourceResolver damCollectionServiceResolver = null;
        try {
            Resource siteDamCollection;
            damWriterResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", DAM_WRITER));
            damCollectionServiceResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", DAM_COLLECTION_SERVICE));
            Resource siteDamRoot = damWriterResolver.getResource(context.getSiteDamRootPath());
            if (siteDamRoot != null && siteTitle != null) {
                Node siteDamRootNode = siteDamRoot.adaptTo(Node.class);
                siteDamRootNode.setProperty("jcr:title", siteTitle);
                damWriterResolver.commit();
            }
            if ((siteDamCollection = damCollectionServiceResolver.getResource(context.getSiteDamCollectionPath())) != null && siteTitle != null) {
                Node siteDamCollectionNode = siteDamCollection.adaptTo(Node.class);
                siteDamCollectionNode.setProperty("jcr:title", siteTitle);
                damCollectionServiceResolver.commit();
            }
        }
        catch (LoginException le) {
            LOG.error("Failed to update new site title in some places.", le);
        }
        finally {
            if (damWriterResolver != null) {
                damWriterResolver.close();
            }
            if (damCollectionServiceResolver != null) {
                damCollectionServiceResolver.close();
            }
        }
    }

    private String[] trimTags(String[] tags) {
        ArrayList<String> tagList = new ArrayList<String>(tags.length);
        for (String tag : tags) {
            if (StringUtils.isEmpty(tag)) continue;
            tagList.add(tag);
        }
        return tagList.toArray(new String[tagList.size()]);
    }

    private Node createCSSAsset(List<DataSource> siteThumbnail, Session session, CommunityContext context) throws RepositoryException, IOException {
        String absolutePath = context.getSiteThemePath();
        String nodeType = "cq:ClientLibraryFolder";
        for (DataSource cssFile : siteThumbnail) {
            boolean isCss = cssFile.getContentType().equalsIgnoreCase("text/css");
            if (!isCss) continue;
            String assetName = JcrUtil.createValidName(cssFile.getName());
            String fileName = assetName + ".css";
            Node assetRootNode = JcrUtil.createPath(absolutePath, false, "sling:Folder", "sling:Folder", session, false);
            Node assetNode = JcrUtil.createUniqueNode(assetRootNode, assetName, "cq:ClientLibraryFolder", session);
            Node cssNode = JcrUtils.putFile(assetNode, fileName, "text/css", cssFile.getInputStream());
            String themeCategoryName = "cq.social.console.theme.custom." + context.getSiteId() + "." + assetNode.getName();
            if (context.isMultiTenantSupported()) {
                themeCategoryName = "cq.social.console.theme.custom." + context.getTenantId() + "." + context.getSiteId() + "." + assetNode.getName();
            }
            JcrUtil.setProperty(assetNode, "categories", new String[]{themeCategoryName});
            JcrUtils.putFile(assetNode, "css.txt", "text/plain", new ByteArrayInputStream(cssNode.getName().getBytes()));
            return assetNode;
        }
        return null;
    }

    private Node createThumbnailAsset(List<DataSource> siteThumbnail, Resource site, ResourceResolver resolver, CommunityContext context) throws RepositoryException, IOException {
        if (siteThumbnail != null && !siteThumbnail.isEmpty()) {
            Iterator<DataSource> iterator;
            Node siteNode = site.getChild(NODE_JCR_CONTENT).adaptTo(Node.class);
            if (siteNode.hasNode("image")) {
                Node fileNode = siteNode.getNode("image");
                fileNode.remove();
                resolver.adaptTo(Session.class).save();
            }
            if ((iterator = siteThumbnail.iterator()).hasNext()) {
                DataSource ds = iterator.next();
                return AbstractSiteOperationService.createFile(resolver, "file", resolver.adaptTo(Session.class).getValueFactory().createBinary(ds.getInputStream()), ds.getContentType(), siteNode, "image", ds.getName(), context);
            }
        }
        return null;
    }

    private boolean isUpdatedParameter(String key, Object value, Node configNode) throws RepositoryException {
        if (configNode.hasProperty(key)) {
            Property prop = configNode.getProperty(key);
            if (!prop.isMultiple()) {
                Value currentValue = prop.getValue();
                Value newValue = JcrUtil.createValue(value, configNode.getSession());
                if (newValue != null) {
                    return !newValue.equals(currentValue);
                }
                return true;
            }
            return true;
        }
        return true;
    }

    private String getRootPath(Resource tenantRoot) {
        String tenantId;
        ResourceResolver resolver = tenantRoot.getResourceResolver();
        String rootPath = tenantRoot.getPath();
        Tenant tenant = tenantRoot.adaptTo(Tenant.class);
        boolean adjustRootPath = false;
        if (tenant == null) {
            tenant = resolver.adaptTo(Tenant.class);
            adjustRootPath = true;
        }
        String string = tenantId = tenant == null ? null : tenant.getId();
        if (adjustRootPath) {
            rootPath = rootPath + "/" + tenantId;
        }
        return rootPath;
    }

    private boolean isSpecialRequestParam(String paramName) {
        for (int i = 0; i < specialParams.length; ++i) {
            if (!paramName.equals(specialParams[i])) continue;
            return true;
        }
        return false;
    }

    private Node getOrCreateSitesRootPage(String contentPath, ResourceResolver resolver) throws OperationException {
        if (contentPath != null && contentPath.startsWith("/")) {
            try {
                if (resolver.getResource(contentPath) == null) {
                    PageManager pm = resolver.adaptTo(PageManager.class);
                    Page page = pm.create(Text.getRelativeParent(contentPath, 1), Text.getName(contentPath), null, SITES_ROOT_TITLE);
                }
                Session session = resolver.adaptTo(Session.class);
                return session.getNode(contentPath);
            }
            catch (WCMException e) {
                throw new OperationException("Error creating root of community site, unable to create page", e, 500);
            }
            catch (PathNotFoundException e) {
                throw new OperationException("Error creating root of community site.", e, 500);
            }
            catch (RepositoryException e) {
                throw new OperationException("Error creating root of community site.", e, 500);
            }
        }
        throw new OperationException("Error creating root of community site, content path should start with \"/\": " + contentPath, 500);
    }

    @Override
    public Resource create(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String rootPath = request.getParameter("siteRoot");
        Resource root = null;
        if (StringUtils.isBlank(rootPath)) {
            root = resource.getResourceResolver().getResource(CONTENT_SITES);
        } else {
            root = resource.getResourceResolver().getResource(rootPath);
            if (root == null) {
                root = new NonExistingResource(resource.getResourceResolver(), rootPath);
            }
        }
        if (!this.siteService.mayPost(request, session)) {
            throw new OperationException("Access violation.", 403);
        }
        if (this.siteBlueprintService == null) {
            throw new OperationException("BlueprintService unavailable.", 503);
        }
        String name = request.getParameter("urlName");
        if (StringUtils.isBlank(name) || !this.isValidUrl(name)) {
            throw new OperationException("Community site name is missing", 400);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, true);
            this.getCustomProperties(request, props, session);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to obtain community site parameters.", e, 500);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, "pagebanner");
        List<DataSource> cssFiles = this.getAttachmentsFromRequest(request, "pagecss");
        List<DataSource> siteThumbnail = this.getAttachmentsFromRequest(request, "pagethumbnail");
        U createOperation = this.getCreateOperation();
        this.getExtensionParameters(createOperation, request, props);
        ResourceResolver msmResolver = null;
        ResourceResolver userManagerResolver = null;
        ResourceResolver aclResolver = null;
        try {
            msmResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            userManagerResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            aclResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", ACL_MANAGER));
            Resource resource2 = this.create(root, name, props, attachments, cssFiles, siteThumbnail, session, msmResolver, userManagerResolver, aclResolver);
            return resource2;
        }
        catch (LoginException e) {
            LOG.error("Failed to login as service user.", e);
            throw new OperationException(e, 500);
        }
        finally {
            if (msmResolver != null) {
                msmResolver.close();
            }
            if (userManagerResolver != null) {
                userManagerResolver.close();
            }
            if (aclResolver != null) {
                aclResolver.close();
            }
        }
    }

    @Override
    public void delete(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        boolean ignoreAssets = false;
        String ignoreAssetsValue = request.getParameter("ignoreAssets");
        if (StringUtils.isNotBlank(ignoreAssetsValue)) {
            ignoreAssets = ignoreAssetsValue.equals("true");
        }
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String sitePath = "";
        CommunitySite site = resource.adaptTo(CommunitySite.class);
        if (site != null) {
            sitePath = site.getSitePagePath();
        }
        if (!this.siteService.mayPost(resource, session)) {
            throw new OperationException("Access violation.", 403);
        }
        if (StringUtils.isBlank(sitePath)) {
            throw new OperationException("Unable to find the community site.", 404);
        }
        ResourceResolver userManagerResolver = null;
        try {
            userManagerResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            Resource siteResource = resource.getResourceResolver().getResource(sitePath);
            SiteContentUtils contentUtils = new SiteContentUtils(siteResource, this.socialUtils, userManagerResolver);
            contentUtils.deleteSite(ignoreAssets);
        }
        catch (LoginException e) {
            LOG.error("Failed to login as service user.", e);
            throw new OperationException(e, 500);
        }
        finally {
            if (userManagerResolver != null) {
                userManagerResolver.close();
            }
        }
    }

    @Override
    public Resource update(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        CommunitySite site = resource.adaptTo(CommunitySite.class);
        if (!this.siteService.mayPost(resource, session)) {
            throw new OperationException("Access violation.", 403);
        }
        if (this.siteBlueprintService == null) {
            throw new OperationException("BlueprintService unavailable.", 503);
        }
        String name = site != null ? site.getSiteUrlName() : resource.getName();
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, false);
            this.getCustomProperties(request, props, session);
            String structureString = (String)props.get("functions");
            if (!StringUtils.isEmpty(structureString)) {
                JSONObject structure = new JSONObject(structureString);
                JSONArray functions = structure.getJSONArray("functions");
                FunctionValidationUtil.validateFunctions(resource, functions);
            }
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to create community site.", e, 500);
        }
        catch (JSONException e1) {
            throw new OperationException("Failed to create community site.", e1, 500);
        }
        catch (FunctionValidationException e) {
            LOG.error("Community functions malformed", e);
            throw new OperationException("Community functions malformed:\n" + e.getMessage(), 409);
        }
        List<DataSource> siteBanner = this.getAttachmentsFromRequest(request, "pagebanner");
        List<DataSource> siteCSS = this.getAttachmentsFromRequest(request, "pagecss");
        List<DataSource> siteThumbnail = this.getAttachmentsFromRequest(request, "pagethumbnail");
        U updateOperation = this.getUpdateOperation();
        this.getExtensionParameters(updateOperation, request, props);
        ResourceResolver msmResolver = null;
        ResourceResolver userManagerResolver = null;
        ResourceResolver aclResolver = null;
        try {
            msmResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            userManagerResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            aclResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", ACL_MANAGER));
            Resource resource2 = this.update(resource, name, props, siteBanner, siteThumbnail, siteCSS, session, msmResolver, userManagerResolver, aclResolver);
            return resource2;
        }
        catch (LoginException e) {
            LOG.error("Failed to login as service user.", e);
            throw new OperationException(e, 500);
        }
        finally {
            if (msmResolver != null) {
                msmResolver.close();
            }
            if (userManagerResolver != null) {
                userManagerResolver.close();
            }
            if (aclResolver != null) {
                aclResolver.close();
            }
        }
    }

    protected List<DataSource> getAttachmentsFromRequest(SlingHttpServletRequest request) {
        RequestParameter[] fileRequestParameters = request.getRequestParameters("file");
        if (fileRequestParameters != null) {
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, Integer.MAX_VALUE, WHITE_LIST, BLACK_LIST);
        }
        return Collections.emptyList();
    }

    protected List<DataSource> getSiteThumbnailAttachmentsFromRequest(SlingHttpServletRequest request) {
        RequestParameter[] fileRequestParameters = request.getRequestParameters("pagethumbnail");
        if (fileRequestParameters != null) {
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, Integer.MAX_VALUE, WHITE_LIST, BLACK_LIST);
        }
        return Collections.emptyList();
    }

    protected List<DataSource> getAttachmentsFromRequest(SlingHttpServletRequest request, String requestParameterName) {
        RequestParameter[] fileRequestParameters = request.getRequestParameters(requestParameterName);
        if (fileRequestParameters != null) {
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, Integer.MAX_VALUE, WHITE_LIST, BLACK_LIST);
        }
        return Collections.emptyList();
    }

    protected void getDefaultProperties(SlingHttpServletRequest request, Map<String, Object> props, boolean validateRequired) throws RepositoryException, OperationException {
        Resource resource = request.getResource();
        Conf conf = resource.adaptTo(Conf.class);
        for (int i = 0; i < requestParams.length; ++i) {
            Object[] params = requestParams[i];
            Class clazz = (Class)params[1];
            String name = (String)params[0];
            if (clazz.isArray()) {
                String[] values = request.getParameterValues(name);
                if (validateRequired && values == null && ((Boolean)params[2]).booleanValue()) {
                    throw new OperationException("Community site value '" + name + "' is empty", 400);
                }
                if (clazz != String[].class || values == null) continue;
                props.put(name, values);
                continue;
            }
            String value = null;
            if (name.equals("translationProviderConfig")) {
                String translationConfigName = request.getParameter(name);
                if (StringUtils.isNotEmpty(translationConfigName)) {
                    value = translationConfigName.startsWith("/etc/") ? resource.getResourceResolver().getResource(request.getParameter(name)).getPath() : conf.getItemResource(request.getParameter(name)).getPath();
                }
            } else {
                value = request.getParameter(name);
            }
            if (validateRequired && value == null && ((Boolean)params[2]).booleanValue()) {
                throw new OperationException("Community site value '" + name + "' is empty", 400);
            }
            if (value == null) continue;
            props.put(name, PropertiesUtils.toObject((String)value, (Class)clazz));
        }
    }

    protected void getCustomProperties(SlingHttpServletRequest request, Map<String, Object> map, Session session) throws RepositoryException, OperationException {
        RequestParameterMap params = request.getRequestParameterMap();
        for (String key : params.keySet()) {
            if (map.containsKey(key) || StringUtils.equals(key, CHARSET_PROPERTY)) continue;
            if (!ArrayUtils.contains(this.fieldWhitelist, key) || key.contains(":")) {
                LOG.debug("skipped custom form field [{}], not in white list.", (Object)key);
                continue;
            }
            RequestParameter[] values = (RequestParameter[])params.get(key);
            if (values.length > 0 && values[0].isFormField()) {
                if (values.length == 1) {
                    String paramVal = values[0].getString();
                    if (paramVal == null) continue;
                    map.put(key, values[0].getString());
                    continue;
                }
                String[] paramValues = request.getParameterValues(key);
                if (paramValues == null) continue;
                map.put(key, paramValues);
                continue;
            }
            LOG.debug("skipped custom form field [{}], empty or binary not allowed.", (Object)key);
        }
    }

    protected void getProp(SlingHttpServletRequest request, String key, String defaultValue, Map<String, Object> props) {
        String value = request.getParameter(key);
        props.put(key, StringUtils.isBlank(value) ? "" : value);
    }

    protected String getUserIdFromRequest(SlingHttpServletRequest request, String defaultValue) {
        String userIdentifier;
        UserProperties up = request.getResourceResolver().adaptTo(UserProperties.class);
        String string = userIdentifier = up == null ? null : up.getAuthorizableID();
        if (userIdentifier == null) {
            userIdentifier = defaultValue;
        }
        return userIdentifier;
    }

    protected static Node createFile(ResourceResolver resolver, String name, Binary data, String contentType, Node themeIdNode, String assetRootName, String fileNameProperty, CommunityContext context) throws RepositoryException {
        Node resNode;
        Node assetNode;
        int pos;
        Session session = resolver.adaptTo(Session.class);
        boolean isCss = contentType.equalsIgnoreCase("text/css");
        String nodeType = "nt:unstructured";
        boolean createUniqueLeaf = false;
        String aRootName = assetRootName;
        Node assetRootNode = null;
        assetRootNode = StringUtils.isNotEmpty(aRootName) ? JcrUtil.createPath(themeIdNode, aRootName, false, "nt:unstructured", "nt:unstructured", session, false) : themeIdNode;
        String assetName = name;
        if (assetName == null) {
            assetName = "a" + System.currentTimeMillis() + ".bin";
        } else {
            int pos2 = assetName.lastIndexOf(47);
            if (pos2 < 0) {
                pos2 = assetName.lastIndexOf(92);
            }
            if (pos2 >= 0) {
                assetName = name.substring(pos2 + 1);
            }
        }
        String assetContentType = contentType;
        if (assetContentType == null) {
            assetContentType = "application/octet-stream";
        }
        if ((pos = assetContentType.indexOf(59)) > 0) {
            assetContentType = assetContentType.substring(0, pos);
        }
        String fileNameWithoutExtension = FilenameUtils.getBaseName(assetName);
        String fileNameExtension = FilenameUtils.getExtension(assetName);
        fileNameWithoutExtension = JcrUtil.isValidName(fileNameWithoutExtension) ? fileNameWithoutExtension : JcrUtil.createValidName(fileNameWithoutExtension);
        String fileName = "";
        fileName = StringUtils.isBlank(fileNameExtension) ? fileNameWithoutExtension : fileNameWithoutExtension + "." + fileNameExtension;
        if (assetRootNode.hasNode(fileName)) {
            assetNode = assetRootNode.getNode(fileName);
            resNode = assetNode.getNode(NODE_JCR_CONTENT);
        } else {
            assetNode = assetRootNode.addNode(fileName, "cq:CommentAttachment");
            resNode = assetNode.addNode(NODE_JCR_CONTENT, "nt:resource");
        }
        resNode.setProperty("jcr:mimeType", assetContentType);
        resNode.setProperty("jcr:data", data);
        resNode.setProperty("jcr:lastModified", Calendar.getInstance());
        assetNode.setProperty("name", fileNameProperty);
        return assetNode;
    }

    protected static Node addThemeAsset(ResourceResolver resolver, CommunityContext context, String photoFolderPath, String name, Binary data, String contentType) throws OperationException {
        Session session = resolver.adaptTo(Session.class);
        try {
            Node photoRootNode = JcrUtils.getOrCreateByPath(photoFolderPath, "sling:Folder", resolver.adaptTo(Session.class));
            return AbstractSiteOperationService.createFile(resolver, "image", data, contentType, photoRootNode, "", name, context);
        }
        catch (RepositoryException e) {
            try {
                session.refresh(false);
            }
            catch (RepositoryException e1) {
                throw new OperationException("Repository error while adding theme asset.", 500);
            }
            throw new OperationException("Repository error while adding theme asset.", 500);
        }
    }

    private String getStringProperty(String key, Map<String, Object> props) throws RepositoryException {
        Object obj = props.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Value) {
            return ((Value)obj).getString();
        }
        return obj.toString();
    }

    private String composeFilters(CommunitySite site) {
        StringBuffer result = new StringBuffer();
        CommunityContext context = site.getResource().adaptTo(CommunityContext.class);
        String siteRoot = context.getSiteRootPath();
        String sitePath = site.getSitePagePath();
        String siteId = site.getSiteId();
        String siteResourcePath = context.getSiteResourcesPath();
        result.append(String.format(FILTER_SITE_ROOT_CONTENT, siteRoot));
        result.append(String.format(FILTER_SITE_ROOT_ACL, siteRoot));
        result.append(String.format(FILTER_SITE_ROOT_FOLDER_CONF, siteRoot));
        if (this.sitePathFiltersToPackage != null && this.sitePathFiltersToPackage.length > 0) {
            for (String path : this.sitePathFiltersToPackage) {
                result.append(String.format(path, siteRoot));
            }
        }
        result.append(String.format("{\"root\":\"%s\",\"rules\":[]},", sitePath));
        result.append(String.format("{\"root\":\"%s\",\"rules\":[]},", siteResourcePath));
        result.append(String.format(FILTER_SITE_UGC, siteRoot));
        result.append(String.format(FILTER_SITE_THEME, siteId));
        result.append(String.format(FILTER_SITE_DAM, siteId));
        result.append(String.format(FILTER_SITE_USER_GROUPS, siteId));
        result.append(FILTER_SITE_TEMPLATES);
        return result.toString();
    }

    @Override
    public String export(SlingHttpServletRequest request) throws OperationException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        String sitePath = request.getParameter("path");
        if (StringUtils.isEmpty(sitePath)) {
            throw new OperationException("Missing request parameter path", 400);
        }
        if (this.siteBlueprintService == null) {
            throw new OperationException("BlueprintService unavailable.", 503);
        }
        Resource resource = request.getResource();
        U exportOperation = this.getExportOperation();
        this.getExtensionParameters(exportOperation, request, props);
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        this.performBeforeActions(exportOperation, session, resolver.getResource(sitePath), props);
        if (!this.siteService.mayPost(request, session)) {
            throw new OperationException("User " + session.getUserID() + " has no permission to export community site " + sitePath, 403);
        }
        Resource community = resolver.getResource(sitePath);
        CommunitySite site = (CommunitySite)this.getSocialComponentForCommunitySite(community, request);
        JcrPackage pack = null;
        String packNodePath = null;
        ResourceResolver userAdminResolver = null;
        try {
            LOG.info("Creating package");
            userAdminResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            Session userAdminSession = userAdminResolver.adaptTo(Session.class);
            JcrPackageManager pkgMgr = this.packaging.getPackageManager(userAdminSession);
            String packageName = this.sitePackageGroup + "-" + site.getSiteId();
            LOG.info("Name: %s", (Object)packageName);
            LOG.info("Group: %s", (Object)this.sitePackageGroup);
            String version = "1.0.0";
            LOG.info("Version: %s", (Object)"1.0.0");
            try {
                pack = pkgMgr.create(this.sitePackageGroup, packageName, "1.0.0");
            }
            catch (ItemExistsException e) {
                LOG.debug("Item exists", e);
                pack = pkgMgr.open(new PackageId(this.sitePackageGroup, packageName, "1.0.0"));
            }
            if (pack == null) {
                throw new OperationException("Unable to create package.", 500);
            }
            JcrPackageDefinition def = pack.getDefinition();
            Node packNode = pack.getNode();
            packNodePath = packNode.getPath();
            LOG.info("Package created", (Object)("Package <strong>" + def.getId() + "</strong> created successfully."));
            String desc = "Package for Community Site " + site.getSiteUrlName() + " without UGC.";
            def.set("jcr:description", desc, false);
            AbstractSiteOperationService.updateFilter(def, this.composeFilters(site));
            def.set("acHandling", "overwrite", false);
            def.touch(null, false);
            userAdminSession.save();
            LOG.info("Package filter set");
            pkgMgr.assemble(pack, new SitePackageProgressTrackerListener());
            LOG.info("Package built");
        }
        catch (AccessDeniedException e) {
            LOG.error("no permission to export community site {}", (Object)sitePath, (Object)e);
            throw new OperationException("Unable to create package.", e, 500);
        }
        catch (JSONException e) {
            LOG.error("failed to export community site {}", (Object)sitePath, (Object)e);
            throw new OperationException("Unable to create package.", e, 500);
        }
        catch (PackageException e) {
            LOG.error("failed to export community site {}", (Object)sitePath, (Object)e);
            throw new OperationException("Unable to create package.", e, 500);
        }
        catch (IOException e) {
            LOG.error("failed to export community site {}", (Object)sitePath, (Object)e);
            throw new OperationException("Unable to create package.", e, 500);
        }
        catch (RepositoryException e) {
            LOG.error("failed to export community site {}", (Object)sitePath, (Object)e);
            throw new OperationException("Unable to create package.", e, 500);
        }
        catch (LoginException e) {
            LOG.error("Failed to login as service user.", e);
            throw new OperationException(e, 500);
        }
        finally {
            if (pack != null) {
                pack.close();
            }
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
        this.performAfterActions(exportOperation, session, site, props);
        return packNodePath;
    }

    private static void updateFilter(JcrPackageDefinition def, String filters) throws JSONException {
        if (StringUtils.isBlank(filters)) {
            return;
        }
        DefaultWorkspaceFilter packFilter = new DefaultWorkspaceFilter();
        JSONArray filterList = new JSONArray(filters);
        for (int i = 0; i < filterList.length(); ++i) {
            JSONObject filter = filterList.getJSONObject(i);
            String root = filter.getString("root");
            PathFilterSet filterSet = new PathFilterSet(root);
            JSONArray rules = filter.getJSONArray("rules");
            for (int j = 0; j < rules.length(); ++j) {
                JSONObject rule = rules.getJSONObject(j);
                String pattern = rule.getString("pattern");
                String modifier = rule.getString("modifier");
                if ("include".equals(modifier)) {
                    filterSet.addInclude(new DefaultPathFilter(pattern));
                    continue;
                }
                if (!"exclude".equals(modifier)) continue;
                filterSet.addExclude(new DefaultPathFilter(pattern));
            }
            if (filter.has("mode")) {
                String mode = filter.getString("mode");
                if ("merge".equals(mode)) {
                    filterSet.setImportMode(ImportMode.MERGE);
                } else if ("update".equals(mode)) {
                    filterSet.setImportMode(ImportMode.UPDATE);
                }
            }
            packFilter.add(filterSet);
        }
        def.setFilter(packFilter, false);
    }

    protected abstract U getCreateOperation();

    protected abstract U getDeleteOperation();

    protected abstract U getUpdateOperation();

    protected abstract U getExportOperation();

    @Override
    protected void getExtensionParameters(U operation, SlingHttpServletRequest request, Map<String, Object> requestParameters) throws OperationException {
        if (this.extensionProviders.containsKey(operation)) {
            for (SiteOperationExtension extension : (SortedSet)this.extensionProviders.get(operation)) {
                try {
                    extension.getExtensionRequestParameters((Operation)operation, request, requestParameters);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
            }
        }
    }

    protected boolean isConfigurationParameter(U operation, String parameterName) throws OperationException {
        for (String key : specialParams) {
            if (!key.equals(parameterName)) continue;
            return false;
        }
        if (this.extensionProviders.containsKey(operation)) {
            for (SiteOperationExtension extension : (SortedSet)this.extensionProviders.get(operation)) {
                try {
                    return extension.isConfigurationParameter((Operation)operation, parameterName);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                }
            }
        }
        return true;
    }

    @Override
    protected CommunitySiteService getCommunitySiteService() {
        return this.siteService;
    }

    @Override
    protected ResourceResolverFactory getBundleLocalResourceResolverFactory() {
        if (this.resourceResolverFactory == null) {
            this.resourceResolverFactory = (ResourceResolverFactory)Activator.getService(ResourceResolverFactory.class);
        }
        return this.resourceResolverFactory;
    }

    @Override
    protected ServiceUserWrapper getServiceUserWrapper() {
        if (this.serviceUserWrapper == null) {
            this.serviceUserWrapper = (ServiceUserWrapper)Activator.getService(ServiceUserWrapper.class);
        }
        return this.serviceUserWrapper;
    }

    @Override
    protected SiteActivationService getActivationService() {
        return this.groupService;
    }

    private boolean isValidUrl(String siteUrlName) {
        boolean isValid = true;
        String invalidCharacters = "[^%/\\:*?\"\\[\\]|\n\t\r ]+";
        Pattern p = Pattern.compile(invalidCharacters);
        Matcher m = p.matcher(siteUrlName);
        if (!m.matches()) {
            isValid = false;
        }
        return isValid;
    }

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindFuncDefUtils(FunctionDefinitionUtils functionDefinitionUtils) {
        this.funcDefUtils = functionDefinitionUtils;
    }

    protected void unbindFuncDefUtils(FunctionDefinitionUtils functionDefinitionUtils) {
        if (this.funcDefUtils == functionDefinitionUtils) {
            this.funcDefUtils = null;
        }
    }

    protected void bindSiteService(CommunitySiteService communitySiteService) {
        this.siteService = communitySiteService;
    }

    protected void unbindSiteService(CommunitySiteService communitySiteService) {
        if (this.siteService == communitySiteService) {
            this.siteService = null;
        }
    }

    protected void bindGroupService(SiteActivationService siteActivationService) {
        this.groupService = siteActivationService;
    }

    protected void unbindGroupService(SiteActivationService siteActivationService) {
        if (this.groupService == siteActivationService) {
            this.groupService = null;
        }
    }

    protected void bindSiteConfigurator(SiteConfigurator siteConfigurator) {
        this.siteConfigurator = siteConfigurator;
    }

    protected void unbindSiteConfigurator(SiteConfigurator siteConfigurator) {
        if (this.siteConfigurator == siteConfigurator) {
            this.siteConfigurator = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    class SitePackageProgressTrackerListener
    implements ProgressTrackerListener {
        SitePackageProgressTrackerListener() {
        }

        @Override
        public void onError(ProgressTrackerListener.Mode arg0, String arg1, Exception arg2) {
            LOG.error("On Error " + arg2);
        }

        @Override
        public void onMessage(ProgressTrackerListener.Mode arg0, String arg1, String arg2) {
            LOG.info("On Message " + arg2);
        }
    }
}

