/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import com.adobe.cq.social.srp.internal.AbstractCache;
import com.adobe.cq.social.srp.internal.CacheEntry;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderCache
extends AbstractCache<String, Map<String, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderCache.class);
    private static final long serialVersionUID = 1L;

    public ProviderCache() {
    }

    public ProviderCache(int concurrencyLevel, int cacheStartSize, int cacheMaxSize, long ttl) {
        super(concurrencyLevel, cacheStartSize, cacheMaxSize, ttl);
    }

    @Override
    public synchronized void merge(String key, Map<String, Object> data, Map<String, Object> returnedResult) {
        CacheEntry cacheval = this.get(key);
        if (cacheval != null) {
            HashMap<String, Object> cachemap = new HashMap<String, Object>((Map)cacheval.get());
            LOGGER.debug("Original entry {}: {}", (Object)key, (Object)cachemap);
            LOGGER.debug("Data entry {}: {}", (Object)key, (Object)data);
            LOGGER.debug("Returned result {}: {}", (Object)key, (Object)returnedResult);
            if (cachemap != null) {
                for (String k : data.keySet()) {
                    Object v = data.get(k);
                    if (k.equals("$inc")) {
                        this.replaceIncrementWithResult(cachemap, (Map)v, returnedResult);
                        continue;
                    }
                    if (v == null) {
                        cachemap.remove(k);
                        continue;
                    }
                    cachemap.put(k, v);
                }
                this.put(key, new CacheEntry(cachemap));
                LOGGER.debug("Merged entry: {}", (Object)cachemap);
            }
        }
    }

    CacheEntry<Map<String, Object>> createEntry(Map<String, Object> input, Map<String, Object> result) {
        HashMap<String, Object> mapCopy = new HashMap<String, Object>(input);
        Object incObj = mapCopy.remove("$inc");
        if (incObj instanceof Map) {
            this.replaceIncrementWithResult(mapCopy, (Map)incObj, result);
        }
        return new CacheEntry<Map<String, Object>>(mapCopy);
    }

    private void replaceIncrementWithResult(Map<String, Object> cachemap, Map<String, Long> increments, Map<String, Object> returnedResult) {
        for (Map.Entry<String, Long> entry : increments.entrySet()) {
            Object val = returnedResult.get(entry.getKey());
            if (val != null) {
                cachemap.put(entry.getKey(), val);
                continue;
            }
            LOGGER.warn("Increment key {} not found in returned result: {}", (Object)entry.getKey(), (Object)returnedResult);
        }
    }
}

