/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import com.adobe.cq.social.srp.internal.AbstractSchemaMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class SolrQueryParser
extends QueryParser {
    private final AbstractSchemaMapper mapper;

    public SolrQueryParser(AbstractSchemaMapper mapper, Version matchVersion, String f, Analyzer a) {
        super(matchVersion, f, a);
        this.mapper = mapper;
    }

    @Override
    protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted) throws ParseException {
        boolean addQuote = false;
        if (quoted && !StringUtils.contains((CharSequence)queryText, 32)) {
            addQuote = true;
        }
        return super.newFieldQuery(analyzer, this.mapper.toSchemaKey(field), addQuote ? "\"" + queryText + "\"" : queryText, quoted);
    }

    @Override
    protected Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        return super.newRangeQuery(this.mapper.toSchemaKey(field), part1, part2, startInclusive, endInclusive);
    }

    public static String getQueryString(Query query) {
        return query.toString();
    }
}

