/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.launches.utils;

import com.adobe.cq.launches.api.Launch;
import com.adobe.cq.launches.api.LaunchException;
import com.day.cq.wcm.api.Page;
import com.day.text.Text;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchUtils {
    private static final Logger log = LoggerFactory.getLogger(LaunchUtils.class);
    private static final int LAUNCH_NAME_LEVEL = 2;

    public static Resource getLaunchResource(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        while (resource != null) {
            Resource contentRes = resource.getChild("jcr:content");
            if (contentRes != null && contentRes.isResourceType("wcm/launches/components/launch")) {
                return resource;
            }
            resource = resource.getParent();
        }
        return null;
    }

    public static Resource getProductionResource(Resource resource) {
        if (!LaunchUtils.isLaunchResourcePath(resource.getPath())) {
            return resource;
        }
        Resource launchResource = LaunchUtils.getLaunchResource(resource);
        return resource.getResourceResolver().getResource(resource.getPath().substring(launchResource.getPath().length()));
    }

    public static Resource getTargetResource(Resource resource, Launch target) throws LaunchException {
        String path = LaunchUtils.getTargetResourcePath(resource, target);
        return resource.getResourceResolver().getResource(path);
    }

    public static String getTargetResourcePath(Resource resource, Launch target) throws LaunchException {
        if (!LaunchUtils.isLaunchResourcePath(resource.getPath())) {
            return target == null ? resource.getPath() : null;
        }
        Launch currentLaunch = LaunchUtils.getLaunchResource(resource).adaptTo(Launch.class);
        String path = resource.getPath();
        while (target == null || currentLaunch.compareTo(target) != 0) {
            path = path.substring(currentLaunch.getResource().getPath().length());
            Resource launchResource = LaunchUtils.getLaunchResource(currentLaunch.getSourceRootResource());
            if (launchResource == null) {
                if (target == null) break;
                throw new LaunchException("The specified target launch is not a parent launch of the resource's launch");
            }
            currentLaunch = launchResource.adaptTo(Launch.class);
        }
        return path;
    }

    public static Resource getLaunchResource(Launch launch, Resource resource) throws LaunchException {
        if (launch == null || resource == null) {
            return null;
        }
        String path = LaunchUtils.getLaunchResourcePath(launch, resource);
        return resource.getResourceResolver().getResource(path);
    }

    public static String getLaunchResourcePath(Launch launch, Resource resource) throws LaunchException {
        if (launch == null || resource == null) {
            return null;
        }
        Resource res = LaunchUtils.getLaunchResource(resource);
        Launch resourceLaunch = res == null ? null : res.adaptTo(Launch.class);
        LinkedList<Launch> parents = new LinkedList<Launch>();
        Launch currentLaunch = launch;
        while (resourceLaunch == null || currentLaunch.compareTo(resourceLaunch) != 0) {
            parents.add(currentLaunch);
            Resource launchResource = LaunchUtils.getLaunchResource(currentLaunch.getSourceRootResource());
            if (launchResource == null) {
                if (resourceLaunch == null) break;
                throw new LaunchException("The specified launch is not a child launch of the resource's launch");
            }
            currentLaunch = launchResource.adaptTo(Launch.class);
            if (currentLaunch != null) continue;
            throw new LaunchException("Invalid parent launch " + launchResource.getPath());
        }
        StringBuilder path = new StringBuilder(resource.getPath());
        ListIterator reverseIterator = parents.listIterator(parents.size());
        while (reverseIterator.hasPrevious()) {
            path.insert(0, ((Launch)reverseIterator.previous()).getResource().getPath());
        }
        return path.toString();
    }

    public static boolean isLaunchBasedPath(String path) {
        return Text.isDescendantOrEqual("/content/launches", path);
    }

    static boolean isLaunchBasedPath(String path, String launchPath) {
        return Text.isDescendantOrEqual(launchPath, path);
    }

    public static boolean isLaunchResourcePath(String path) {
        return LaunchUtils.isLaunchBasedPath(path) && StringUtils.isNotEmpty(Text.getAbsoluteParent(path, 3));
    }

    public static String getLaunchPath(String path) {
        log.warn("LaunchUtils.getLaunchPath is deprecated and potentially broken. Please remove usages of this method.");
        if (LaunchUtils.isLaunchBasedPath(path)) {
            String launchPath = Text.getAbsoluteParent(path, 2);
            return StringUtils.isNotEmpty(launchPath) ? launchPath : null;
        }
        return null;
    }

    public static String getLaunchPathFromName(String launchName) {
        return Text.makeCanonicalPath("/content/launches/" + launchName);
    }

    public static String getProductionResourcePath(String path) {
        return LaunchUtils.isLaunchResourcePath(path) ? StringUtils.substringAfter(path, LaunchUtils.getLaunchPath(path)) : path;
    }

    public static String buildLaunchResourcePath(String path, String launchName) {
        log.warn("LaunchUtils#buildLaunchResourcePath is deprecated and potentially broken. Please remove usages of this method.");
        if (LaunchUtils.isLaunchResourcePath(path)) {
            return LaunchUtils.isLaunchBasedPath(path, LaunchUtils.getLaunchPathFromName(launchName)) ? path : null;
        }
        return !LaunchUtils.isLaunchBasedPath(path) ? Text.makeCanonicalPath("/content/launches/" + launchName + "/" + path) : null;
    }

    public static boolean isApprovedLaunchResource(Resource resource) {
        Page resPage;
        if (resource != null && LaunchUtils.isLaunchBasedPath(resource.getPath()) && (resPage = resource.adaptTo(Page.class)) != null) {
            ValueMap resVM = resPage.getProperties();
            String status = (String)((Object)resVM.get("status", String.class));
            return "approved".equals(status);
        }
        return false;
    }
}

