/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dam.print.ids.utils;

import com.day.cq.dam.api.Asset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

public final class PrintUIHelper {
    public static void getProperties(String rootPath, Resource topRes, Map<String, String> properties) throws RepositoryException {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        resources.add(topRes);
        while (!resources.isEmpty()) {
            Resource currNode = (Resource)resources.poll();
            PrintUIHelper.getPropertiesFromNode(rootPath, currNode, properties);
            Iterator<Resource> nodeIterator = currNode.listChildren();
            if (nodeIterator == null) continue;
            while (nodeIterator.hasNext()) {
                Resource childNode = nodeIterator.next();
                resources.add(childNode);
            }
        }
    }

    public static void getPropertiesFromNode(String rootPath, Resource res, Map<String, String> propertyList) throws RepositoryException {
        HashSet<String> propertyFilterSet = new HashSet<String>();
        propertyFilterSet.add("jcr:lastModified");
        propertyFilterSet.add("jcr:lastModifiedBy");
        propertyFilterSet.add("jcr:created");
        propertyFilterSet.add("jcr:createdBy");
        propertyFilterSet.add("jcr:primaryType");
        propertyFilterSet.add("jcr:mixinTypes");
        Node node = res.adaptTo(Node.class);
        PropertyIterator propertyIterator = node.getProperties();
        while (propertyIterator.hasNext()) {
            Property childProperty = propertyIterator.nextProperty();
            if (propertyFilterSet.contains(childProperty.getName()) || childProperty.isMultiple() || childProperty.getName().startsWith("cq:") || childProperty.getName().startsWith("sling:")) continue;
            String path = node.getPath() + "/" + childProperty.getName();
            String subPath = path.substring(rootPath.length() + 1);
            propertyList.put(subPath, childProperty.getValue().getString());
        }
    }

    public static String getProductPath(Resource catalog) {
        Asset asset;
        Resource rendRes;
        if (catalog != null && (rendRes = (asset = catalog.adaptTo(Asset.class)).getRendition("cq-indesign-print").adaptTo(Resource.class)) != null) {
            return (String)((Object)rendRes.getChild("jcr:content").getValueMap().get("productReference", String.class));
        }
        return null;
    }

    public static String getName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static boolean isImageProperty(String property, Map<String, String> properties, boolean isProductRefSet) {
        return isProductRefSet && "fileReference".equals(PrintUIHelper.getName(properties.get(property))) || properties.containsKey(property + "_assetRef");
    }

    public static boolean isPropertyMappedToProduct(Map.Entry<String, String> property, Resource productNode) {
        return productNode != null && productNode.getValueMap().containsKey(property.getKey());
    }

    public static String getPropertyValue(Map.Entry<String, String> property, Resource productNode) {
        if (productNode != null && productNode.getValueMap().containsKey(property.getValue())) {
            return (String)((Object)productNode.getValueMap().get(property.getValue(), String.class));
        }
        return property.getValue();
    }
}

