/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.config;

import com.adobe.fd.fp.config.FormsPortalSchedulerService;
import com.adobe.fd.fp.util.FormsPortalCleanUpTask;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class FormsPortalCleanUpComponent {
    @Reference
    private Scheduler scheduler;
    @Reference
    SlingRepository slingRepository;
    @Reference
    protected FormsPortalSchedulerService fpSchedulerService;
    private final Logger log = LoggerFactory.getLogger(FormsPortalCleanUpComponent.class);

    protected void activate(ComponentContext context) {
        try {
            long period = this.fpSchedulerService.getInterval();
            this.scheduler.addPeriodicJob("FormsPortalCleanUpTask", new FormsPortalCleanUpTask(this.slingRepository), null, period, true);
        }
        catch (Exception e) {
            this.log.error("error occured while scheduling FormsPortal clean up thread", e);
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindFpSchedulerService(FormsPortalSchedulerService formsPortalSchedulerService) {
        this.fpSchedulerService = formsPortalSchedulerService;
    }

    protected void unbindFpSchedulerService(FormsPortalSchedulerService formsPortalSchedulerService) {
        if (this.fpSchedulerService == formsPortalSchedulerService) {
            this.fpSchedulerService = null;
        }
    }
}

