/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.external;

import com.adobe.aemds.guide.model.FormSubmitInfo;
import com.adobe.aemds.guide.service.FormSubmitActionService;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.fd.fp.common.AdaptiveFormSubmissionBase;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.SubmitDataService;
import com.adobe.fd.fp.service.SubmitMetadataService;
import com.adobe.fd.fp.util.PortalUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

@Component(immediate=true)
@Service
public class FPSubmitServiceImpl
extends AdaptiveFormSubmissionBase
implements FormSubmitActionService {
    private static final long serialVersionUID = 3540542983992781935L;
    private static final String FORMS_PORTAl = "formsPortal";

    @Override
    public String getServiceName() {
        return FORMS_PORTAl;
    }

    @Override
    public Map<String, Object> submit(FormSubmitInfo formSubmitInfo) throws GuideException {
        return this.submit(formSubmitInfo, new HashMap<String, Object>());
    }

    public Map<String, Object> submit(FormSubmitInfo formSubmitInfo, Map<String, Object> options) throws GuideException {
        Map<String, Object> result = null;
        try {
            JSONObject jsonObj = this.submitFormInternal(formSubmitInfo, new HashMap<String, Object>());
            result = PortalUtils.convertJsonToMap(jsonObj);
            result.put("FormSubmissionComplete", Boolean.TRUE);
        }
        catch (FormsPortalException e) {
            throw new GuideException(e);
        }
        catch (JSONException e) {
            throw new GuideException(e);
        }
        return result;
    }

    @Override
    protected String saveData(byte[] formData, Map<String, Object> options) throws Exception {
        String id = null;
        if (formData != null && options != null && !StringUtils.isEmpty((String)options.get("owner"))) {
            SubmitDataService fpSubmitDataService = (SubmitDataService)PortalUtils.getService(SubmitDataService.class, this.portalUtilsComponent.getSDSFilter());
            id = fpSubmitDataService.saveDataAsynchronusly(formData, options);
        }
        return id;
    }

    @Override
    protected String saveAttachment(byte[] attachment, Map<String, Object> options) throws Exception {
        String id = null;
        if (attachment != null && options != null && !StringUtils.isEmpty((String)options.get("owner"))) {
            SubmitDataService fpSubmitDataService = (SubmitDataService)PortalUtils.getService(SubmitDataService.class, this.portalUtilsComponent.getSDSFilter());
            id = fpSubmitDataService.saveAttachmentAsynchronously(attachment, options);
        }
        return id;
    }

    @Override
    protected JSONObject saveMetadata(Map<String, Object> metadataProps, Map<String, Object> saveOptions) throws Exception {
        JSONObject json = null;
        if (metadataProps != null && saveOptions != null && !StringUtils.isEmpty((String)saveOptions.get("owner"))) {
            SubmitMetadataService fpSubmitMetadataService = (SubmitMetadataService)PortalUtils.getService(SubmitMetadataService.class, this.portalUtilsComponent.getSMSFilter());
            json = fpSubmitMetadataService.submitMetadataAsynchronously(metadataProps);
            json.put("path", "/content/forms/portal/render.dor.pdf/" + json.getString("submitID"));
        }
        return json;
    }
}

