/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.math;

public class Math2 {
    private static final int[] bits = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4};

    public static double roundHalfUp(double v) {
        return Math.floor(v + 0.5);
    }

    public static double roundHalfDown(double v) {
        return Math.ceil(v - 0.5);
    }

    public static boolean epsilonEquals(float a, float b) {
        float epsilon = 1.0E-7f;
        return Math.abs(a - b) < epsilon;
    }

    public static boolean epsilonEquals(double a, double b) {
        double epsilon = 1.0E-8;
        return Math.abs(a - b) < epsilon;
    }

    public static int powerOf2(int v) {
        if ((long)v < 0L) {
            v = -v;
        }
        if (v < 65536) {
            if (v < 256) {
                if (v < 16) {
                    return bits[v];
                }
                return bits[v >> 4] + 4;
            }
            if (v < 4096) {
                return bits[v >> 8] + 8;
            }
            return bits[v >> 12] + 12;
        }
        if (v < 0x1000000) {
            if (v < 0x100000) {
                return bits[v >> 16] + 16;
            }
            return bits[v >> 20] + 20;
        }
        if (v < 0x10000000) {
            return bits[v >> 24] + 24;
        }
        return bits[v >> 28] + 28;
    }
}

