/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.common.submitutils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

public class ParameterMap
extends TreeMap<String, RequestParameter[]>
implements RequestParameterMap {
    private Map<String, String[]> stringParameterMap;

    @Override
    public RequestParameter[] getValues(String name) {
        return (RequestParameter[])this.get(name);
    }

    @Override
    public RequestParameter getValue(String name) {
        RequestParameter[] params = (RequestParameter[])this.get(name);
        return params != null && params.length > 0 ? params[0] : null;
    }

    public String getStringValue(String name) {
        RequestParameter param = this.getValue(name);
        return param != null ? param.getString() : null;
    }

    public String[] getStringValues(String name) {
        return ParameterMap.toStringArray(this.getValues(name));
    }

    public Map<String, String[]> getStringParameterMap() {
        if (this.stringParameterMap == null) {
            LinkedHashMap pm = new LinkedHashMap();
            for (Map.Entry ppmEntry : this.entrySet()) {
                pm.put(ppmEntry.getKey(), ParameterMap.toStringArray((RequestParameter[])ppmEntry.getValue()));
            }
            this.stringParameterMap = Collections.unmodifiableMap(pm);
        }
        return this.stringParameterMap;
    }

    private static String[] toStringArray(RequestParameter[] params) {
        if (params == null) {
            return null;
        }
        String[] ps = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            ps[i] = params[i].getString();
        }
        return ps;
    }
}

