/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.common.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class XFAUtils {
    public static boolean isResourceFormsManager(Resource resource) {
        if (resource != null) {
            String resourceType = resource.getResourceType();
            return StringUtils.isNotBlank(resourceType) && resourceType.equals("fd/fm/xfaforms/render");
        }
        return false;
    }

    public static String getRequestAttribute(SlingHttpServletRequest slingRequest, String param) {
        Object valObj = slingRequest.getAttribute("submitUrl");
        String value = "";
        if (valObj != null && valObj instanceof String) {
            value = (String)valObj;
        }
        return value;
    }

    public static Resource getFormsManagerResource(SlingHttpServletRequest slingRequest, String contentRoot, String template) {
        Resource formManagerResource = null;
        if (StringUtils.isNotBlank(contentRoot) && StringUtils.isNotBlank(template)) {
            String resourcePath = contentRoot.replace("crx://", "") + "/" + template;
            Resource resource = slingRequest.getResourceResolver().getResource(resourcePath);
            if (resource != null) {
                formManagerResource = resource.getChild("jcr:content");
            }
        }
        return formManagerResource;
    }

    public static String getSubmitUrl(SlingHttpServletRequest slingRequest, String contentRoot, String template) {
        String formsManagerSubmitUrl = null;
        Resource formManagerResource = XFAUtils.getFormsManagerResource(slingRequest, contentRoot, template);
        String submitUrlParameter = slingRequest.getParameter("submitUrl");
        String submitUrlAttribute = XFAUtils.getRequestAttribute(slingRequest, "submitUrl");
        String submitUrl = "";
        if (XFAUtils.isResourceFormsManager(formManagerResource)) {
            ValueMap managerProperties = formManagerResource.getChild("metadata").adaptTo(ValueMap.class);
            formsManagerSubmitUrl = managerProperties.get("submitUrl", "");
        }
        if (StringUtils.isNotBlank(submitUrlAttribute) && !submitUrlAttribute.equals(formsManagerSubmitUrl)) {
            submitUrl = submitUrlAttribute;
        } else if (StringUtils.isNotBlank(submitUrlParameter)) {
            submitUrl = submitUrlParameter;
        }
        return submitUrl;
    }
}

