/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.service.handlers;

import com.adobe.granite.omnisearch.api.core.OmniSearchException;
import com.adobe.granite.omnisearch.spi.core.SavedSearchHandler;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.i18n.I18n;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resource.collection.ResourceCollection;
import org.apache.sling.resource.collection.ResourceCollectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormsAbstractSavedSearchHandler
implements SavedSearchHandler {
    private static final Logger logger = LoggerFactory.getLogger(FormsAbstractSavedSearchHandler.class);
    protected static final String REQUEST_PARAMETER_TITLE = "title";
    protected static final String REQUEST_PARAM_RESOURCE_PATH = "resourcePath";
    protected static final Set<String> defaultReqParams = new HashSet<String>();
    private static final String PREFERENCES_SAVED_SEARCH_PATH = "/preferences/omnisearch/forms/";
    static final String CREATE_COMMAND = "create";
    static final String UPDATE_COMMAND = "update";
    private static final String NODE_SAVEDQUERY = "savedquery";
    private static final String PARAM_SEP = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final String LOCATION_PARAM = "location";

    @Override
    public boolean deleteSavedSearch(ResourceResolver resourceResolver, String path) {
        return false;
    }

    @Override
    public Iterator<Resource> getSavedSearches(ResourceResolver resourceResolver, long limit, long offset) {
        try {
            String path = this.getSavedSearchPath(resourceResolver);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("path", path);
            map.put("type", "nt:unstructured");
            map.put("property", "sling:resourceType");
            map.put("property.value", "sling/collection");
            Session session = resourceResolver.adaptTo(Session.class);
            Query query = this.getQueryBuilder().createQuery(PredicateGroup.create(map), session);
            SearchResult result = query.getResult();
            return result.getResources();
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving saved searches for omnisearch location " + this.getID(), e);
            return Collections.emptyIterator();
        }
    }

    @Override
    public Map<String, String> getSavedSearchParameters(ResourceResolver resourceResolver, String path) {
        Resource resource = null;
        if (!StringUtils.isEmpty(path)) {
            resource = resourceResolver.getResource(path);
        }
        if (resource == null) {
            return Collections.emptyMap();
        }
        Session session = resourceResolver.adaptTo(Session.class);
        String queryPath = resource.getPath() + "/" + NODE_SAVEDQUERY;
        try {
            Query storedQuery = this.getQueryBuilder().loadQuery(queryPath, session);
            String queryParams = storedQuery.getPredicates().toURL();
            return this.parse(queryParams);
        }
        catch (Exception e) {
            logger.error("Unable to get saved search parameters", e);
            return Collections.emptyMap();
        }
    }

    @Override
    public Resource createOrUpdateSavedSearch(ResourceResolver resourceResolver, Map<String, String> requestParameters) throws OmniSearchException {
        String operation = requestParameters.get(":operation");
        Resource res = null;
        try {
            if (CREATE_COMMAND.equals(operation) || StringUtils.isEmpty(operation)) {
                res = this.createSavedSearch(resourceResolver, requestParameters);
            } else if (UPDATE_COMMAND.equals(operation)) {
                res = this.updateSavedSearch(resourceResolver, requestParameters);
            } else {
                logger.warn("Unknown saved search operation: " + operation);
            }
        }
        catch (Exception e) {
            throw new OmniSearchException(e.getMessage(), e);
        }
        return res;
    }

    private Resource createSavedSearch(ResourceResolver resourceResolver, Map<String, String> requestParameters) throws Exception {
        String resourcePath;
        String title = requestParameters.get(REQUEST_PARAMETER_TITLE);
        if (StringUtils.isEmpty(title)) {
            String errorMessage = I18n.get(resourceResolver.adaptTo(ResourceBundle.class), "Invalid request, empty name not allowed.");
            throw new OmniSearchException(errorMessage);
        }
        Session session = resourceResolver.adaptTo(Session.class);
        Node parentNode = !session.nodeExists(resourcePath = this.getSavedSearchPath(resourceResolver)) ? JcrUtil.createPath(resourcePath, "nt:unstructured", "nt:unstructured", session, false) : session.getNode(resourcePath);
        Resource resource = resourceResolver.getResource(resourcePath);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jcr:title", title);
        String nodeName = JcrUtil.createValidName(title);
        String name = JcrUtil.createValidChildName(parentNode, nodeName);
        if (!name.equalsIgnoreCase(nodeName)) {
            String errorMessage = I18n.get(resourceResolver.adaptTo(ResourceBundle.class), "Invalid request, duplicate name not allowed.");
            throw new OmniSearchException(errorMessage);
        }
        params.put("jcr:primaryType", "nt:unstructured");
        String resourceType = requestParameters.get("sling:resourceType");
        if (StringUtils.isEmpty(resourceType)) {
            resourceType = "sling/collection";
        }
        params.put("sling:resourceType", resourceType);
        ResourceCollectionManager rcMgr = resourceResolver.adaptTo(ResourceCollectionManager.class);
        ResourceCollection rc = rcMgr != null ? rcMgr.createCollection(resource, name, params) : null;
        Resource collRes = null;
        if (rc != null) {
            resourcePath = rc.getPath();
            this.saveQuery(resourceResolver, resourcePath, requestParameters);
            collRes = resourceResolver.getResource(resource, name);
            this.addMixinType(collRes);
            session.save();
        }
        return collRes;
    }

    private Resource updateSavedSearch(ResourceResolver resourceResolver, Map<String, String> requestParameters) throws Exception {
        String existingTitle;
        String resourcePath = requestParameters.get(REQUEST_PARAM_RESOURCE_PATH);
        Session session = resourceResolver.adaptTo(Session.class);
        if (StringUtils.isEmpty(resourcePath)) {
            String errorMessage = I18n.get(resourceResolver.adaptTo(ResourceBundle.class), "Invalid request, empty resource path not allowed.");
            throw new OmniSearchException(errorMessage);
        }
        Resource resource = resourceResolver.getResource(resourcePath);
        String title = requestParameters.get(REQUEST_PARAMETER_TITLE);
        ModifiableValueMap mvm = resource.adaptTo(ModifiableValueMap.class);
        if (!StringUtils.isEmpty(title) && !(existingTitle = mvm.get("jcr:title", "")).equals(title)) {
            mvm.put("jcr:title", title);
        }
        this.saveQuery(resourceResolver, resource.getPath(), requestParameters);
        session.save();
        return resource;
    }

    private String getSavedSearchPath(ResourceResolver resourceResolver) throws RepositoryException {
        String path = null;
        Authorizable user = resourceResolver.adaptTo(Authorizable.class);
        if (user != null) {
            path = user.getPath() + PREFERENCES_SAVED_SEARCH_PATH + this.getID();
        }
        return path;
    }

    private Map<String, String> parse(String query) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isBlank(query)) {
            String[] pairs;
            for (String pair : pairs = query.split(PARAM_SEP)) {
                int idx = pair.indexOf(NAME_VALUE_SEPARATOR);
                if (idx < 0) continue;
                String name = URLDecoder.decode(pair.substring(0, idx), "UTF-8");
                String value = URLDecoder.decode(pair.substring(idx + 1), "UTF-8");
                params.put(name, value);
            }
            if (params.get(LOCATION_PARAM) == null) {
                params.put(LOCATION_PARAM, this.getID());
            }
        }
        return params;
    }

    private void saveQuery(ResourceResolver resolver, String resPath, Map<String, String> requestParams) throws IOException, RepositoryException {
        Session session = resolver.adaptTo(Session.class);
        HashMap<String, String> params = new HashMap<String, String>();
        for (String nameObj : requestParams.keySet()) {
            String name = nameObj;
            if (this.ignoreParameter(name)) continue;
            params.put(name, requestParams.get(name));
        }
        PredicateGroup predicates = PredicateGroup.create(params);
        Query query = this.getQueryBuilder().createQuery(predicates, session);
        this.getQueryBuilder().storeQuery(query, resPath + "/" + NODE_SAVEDQUERY, false, session);
    }

    private boolean ignoreParameter(String parameter) {
        return defaultReqParams.contains(parameter) || parameter.startsWith("jcr:") || parameter.startsWith("sling:") || parameter.startsWith("cq:");
    }

    private void addMixinType(Resource res) throws OmniSearchException {
        Node contentNode = res.adaptTo(Node.class);
        if (contentNode != null) {
            try {
                if (contentNode.canAddMixin("mix:created")) {
                    contentNode.addMixin("mix:created");
                }
                if (contentNode.canAddMixin("mix:lastModified")) {
                    contentNode.addMixin("mix:lastModified");
                }
            }
            catch (Exception e) {
                logger.error("unable to add mixin type");
                throw new OmniSearchException(e);
            }
        }
    }

    public abstract QueryBuilder getQueryBuilder();

    static {
        defaultReqParams.add(REQUEST_PARAMETER_TITLE);
        defaultReqParams.add(":operation");
        defaultReqParams.add(REQUEST_PARAM_RESOURCE_PATH);
    }
}

