/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.encryption.PKISecurityHandler;
import com.adobe.internal.pdftoolkit.core.encryption.StandardCipherSecurityManager;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityLockPKIInterface;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityProvidersImpl;
import com.adobe.internal.pdftoolkit.core.securityframework.pki.Identities;
import java.util.Map;

public class SecurityLockPKIImpl
implements SecurityLockPKIInterface {
    private SecurityManager mSecMgr;
    private Map mEncryptParams;

    public SecurityLockPKIImpl() {
    }

    private SecurityLockPKIImpl(Map encryptParams, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        this.mSecMgr = StandardCipherSecurityManager.newInstance(encryptParams, providers);
    }

    @Override
    public SecurityLockPKIInterface makeSecurityLock(Map encryptParams, SecurityProvidersImpl providers) throws PDFSecurityException {
        return new SecurityLockPKIImpl(encryptParams, providers);
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.mSecMgr;
    }

    @Override
    public Map getEncryptParameters() {
        return this.mEncryptParams;
    }

    @Override
    public void setEncryptParameters(Map encryptParams) {
        this.mEncryptParams = encryptParams;
    }

    @Override
    public boolean shouldEncrypt() {
        return true;
    }

    @Override
    public byte[] buildRecipients(String filterName, Identities recipients, boolean inCrypt, Map encryptParams) throws PDFSecurityException {
        if (this.mSecMgr == null || filterName == null) {
            throw new PDFSecurityConfigurationException("Security Manager is not defined");
        }
        PKISecurityHandler handler = (PKISecurityHandler)this.mSecMgr.getSecurityHandler(filterName, this.mEncryptParams);
        if (handler == null) {
            throw new PDFSecurityConfigurationException("Security Handler " + filterName + " is not defined");
        }
        try {
            return handler.buildPKCS7(recipients, inCrypt, encryptParams);
        }
        catch (Exception e) {
            throw new PDFSecurityConfigurationException("Unable to build recipients", e);
        }
    }
}

