/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption.impl;

import com.adobe.internal.pdftoolkit.core.encryption.impl.KDFDataDecryptor;
import com.adobe.internal.pdftoolkit.core.encryption.impl.PKCS7Utils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyAgree;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;

public class CMSEnvelopedDataDecryptor {
    private OctetStringContainer encryptedData;
    private OctetStringContainer userKeyingMaterialContainer;
    private OctetStringContainer encryptedKey;
    private OctetStringContainer ecDataIV;
    private byte[] messageDigestOID;
    private byte[] keyEncryptionOID;
    private byte[] dataEncryptionAlgorithm;
    private byte[] originatorPublicKey;
    private boolean isKeyAgreementRecipientInfo = false;

    protected CMSEnvelopedDataDecryptor() {
    }

    protected byte[] getCMSEnvelopeData(JSAFE_PrivateKey recipientPrivateKey, byte[] pkcs7data) throws Exception {
        this.decodeEnvelopedDataPacket(pkcs7data);
        byte[] decodedData = null;
        JSAFE_SecretKey inkey = null;
        try {
            if (this.isKeyAgreementRecipientInfo) {
                byte[] secret = this.getECDHSharedSecret(recipientPrivateKey);
                KDFDataDecryptor dataDecryptor = new KDFDataDecryptor(this.encryptedKey, this.keyEncryptionOID, this.userKeyingMaterialContainer, this.messageDigestOID);
                inkey = dataDecryptor.getDecodedData(secret);
            } else {
                byte[] secretKey = this.getKeyDecrypted(recipientPrivateKey);
                inkey = PKCS7Utils.getJSAFE_SecretKey(this.dataEncryptionAlgorithm);
                inkey.setKeyData((byte[][])new byte[][]{secretKey});
            }
            decodedData = this.decryptEncryptedData(inkey);
        }
        catch (Exception exception) {
            throw new PDFException("Data missing or invalid while decrypting the enveloped Data packet." + exception);
        }
        return decodedData;
    }

    private void decodeEnvelopedDataPacket(byte[] envelopedData) throws ASN_Exception {
        EncodedContainer ecOIDContainer = new EncodedContainer(65280);
        IntegerContainer envelopedDataVersion = new IntegerContainer(0);
        EncodedContainer recipientsInfosContainer = new EncodedContainer(65280);
        EncodedContainer encryptedContentInfoContainer = new EncodedContainer(65280);
        ASN1Container[] decodeContainers = new ASN1Container[]{new SequenceContainer(0), ecOIDContainer, new ChoiceContainer(0xA0FF00), new SequenceContainer(0), envelopedDataVersion, recipientsInfosContainer, encryptedContentInfoContainer, new EndContainer(), new EndContainer(), new EndContainer()};
        ASN1.berDecode((byte[])envelopedData, (int)0, (ASN1Container[])decodeContainers);
        OfContainer recipientInfoContainer = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(65280));
        ASN1Container[] recipientInfoSet = new ASN1Container[]{recipientInfoContainer};
        ASN1.berDecode((byte[])recipientsInfosContainer.data, (int)recipientsInfosContainer.dataOffset, (ASN1Container[])recipientInfoSet);
        ASN1Container recipientInfoChoiceContainer = recipientInfoContainer.containerAt(0);
        if (recipientInfoChoiceContainer.dataPresent) {
            if (recipientInfoChoiceContainer.data[recipientInfoChoiceContainer.dataOffset] == -95) {
                this.isKeyAgreementRecipientInfo = true;
                this.decodeASN1KeyAgreeRecipientInfo(recipientsInfosContainer, encryptedContentInfoContainer, recipientInfoChoiceContainer);
            }
            if (recipientInfoChoiceContainer.data[recipientInfoChoiceContainer.dataOffset] == -93) {
                this.isKeyAgreementRecipientInfo = false;
                this.decodeASN1PasswordRecipientinfo(recipientsInfosContainer, encryptedContentInfoContainer);
            }
            if (recipientInfoChoiceContainer.data[recipientInfoChoiceContainer.dataOffset] == 48) {
                OfContainer recipientInfoSetContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(65280));
                ASN1Container[] recipientInfosSet = new ASN1Container[]{new SetContainer(0), recipientInfoSetContainer, new EndContainer()};
                ASN1.berDecode((byte[])recipientsInfosContainer.data, (int)recipientsInfosContainer.dataOffset, (ASN1Container[])recipientInfosSet);
                int count = recipientInfoSetContainer.getContainerCount();
                ASN1Container versionEncContainer = recipientInfoSetContainer.containerAt(0);
                IntegerContainer versionContainer = new IntegerContainer(0);
                ASN1.berDecode((byte[])versionEncContainer.data, (int)versionEncContainer.dataOffset, (ASN1Container[])new ASN1Container[]{versionContainer});
                int version = versionContainer.getValueAsInt();
                if (count <= 5 && version == 3) {
                    this.isKeyAgreementRecipientInfo = true;
                    this.decodeASN1KeyAgreeRecipientInfo(recipientsInfosContainer, encryptedContentInfoContainer, null);
                } else if (count <= 4 && version == 0) {
                    this.isKeyAgreementRecipientInfo = false;
                    this.decodeASN1PasswordRecipientinfo(recipientsInfosContainer, encryptedContentInfoContainer);
                }
            }
        }
        OctetStringContainer encryptedDataContainer = new OctetStringContainer(0x810000);
        OctetStringContainer ecdataIV = new OctetStringContainer(65280);
        OIDContainer dataEncryptionAlgorithmOid = new OIDContainer(65280);
        ASN1Container[] encryptedContentInfoASN1Containers = new ASN1Container[]{new SequenceContainer(0), new EncodedContainer(65280), new SequenceContainer(0), dataEncryptionAlgorithmOid, ecdataIV, new EndContainer(), encryptedDataContainer, new EndContainer()};
        ASN1.berDecode((byte[])encryptedContentInfoContainer.data, (int)encryptedContentInfoContainer.dataOffset, (ASN1Container[])encryptedContentInfoASN1Containers);
        this.encryptedData = encryptedDataContainer;
        this.dataEncryptionAlgorithm = new byte[dataEncryptionAlgorithmOid.dataLen];
        System.arraycopy(dataEncryptionAlgorithmOid.data, dataEncryptionAlgorithmOid.dataOffset, this.dataEncryptionAlgorithm, 0, this.dataEncryptionAlgorithm.length);
        this.ecDataIV = ecdataIV;
    }

    private void decodeASN1PasswordRecipientinfo(EncodedContainer recipientsInfosContainer, EncodedContainer encryptedContentInfoContainer) throws ASN_Exception {
        IntegerContainer recipientInfoVersion = new IntegerContainer(0);
        EncodedContainer publicKeyContainer = new EncodedContainer(65280);
        OIDContainer keyEncryptioAlgorithmIdentifierContainer = new OIDContainer(65280);
        OctetStringContainer encryptionKeysContainer = new OctetStringContainer(65280);
        ASN1Container[] passwordRecipientInfo = new ASN1Container[]{new SetContainer(0), new SequenceContainer(0), recipientInfoVersion, publicKeyContainer, new SequenceContainer(0), keyEncryptioAlgorithmIdentifierContainer, new EncodedContainer(65280), new EndContainer(), encryptionKeysContainer, new EndContainer(), new EndContainer()};
        ASN1.berDecode((byte[])recipientsInfosContainer.data, (int)recipientsInfosContainer.dataOffset, (ASN1Container[])passwordRecipientInfo);
        this.keyEncryptionOID = new byte[keyEncryptioAlgorithmIdentifierContainer.dataLen];
        System.arraycopy(keyEncryptioAlgorithmIdentifierContainer.data, keyEncryptioAlgorithmIdentifierContainer.dataOffset, this.keyEncryptionOID, 0, this.keyEncryptionOID.length);
        this.encryptedKey = encryptionKeysContainer;
    }

    private void decodeASN1KeyAgreeRecipientInfo(EncodedContainer recipientsInfosContainer, EncodedContainer encryptedContentInfoContainer, ASN1Container recipientInfoChoiceContainer) throws ASN_Exception {
        IntegerContainer recipientInfoVersion = new IntegerContainer(0);
        OctetStringContainer userKeyingMaterialContainer = new OctetStringContainer(65280);
        EncodedContainer keyEncryptioAlgorithmIdentifierContainer = new EncodedContainer(65280);
        EncodedContainer recipientsEncryptionKeysContainer = new EncodedContainer(65280);
        EncodedContainer publicKeyContainer = new EncodedContainer(65280);
        OIDContainer oidPublicKeyContainer = new OIDContainer(0);
        OIDContainer oidKeyAgreementContainer = new OIDContainer(0);
        OIDContainer echdOidContainer = new OIDContainer(65280);
        OIDContainer wrapOidContainer = new OIDContainer(65280);
        try {
            this.decodeASN1KARI(recipientInfoChoiceContainer, recipientInfoVersion, userKeyingMaterialContainer, keyEncryptioAlgorithmIdentifierContainer, recipientsEncryptionKeysContainer, publicKeyContainer, oidPublicKeyContainer, oidKeyAgreementContainer);
        }
        catch (Exception exception) {
            this.decodeASN1KARI_A11Old(recipientsInfosContainer, recipientInfoVersion, userKeyingMaterialContainer, keyEncryptioAlgorithmIdentifierContainer, recipientsEncryptionKeysContainer, publicKeyContainer, oidPublicKeyContainer, oidKeyAgreementContainer);
        }
        ASN1Container[] bitStringAsn1Containers = new ASN1Container[]{new SequenceContainer(0), new SequenceContainer(0), oidPublicKeyContainer, oidKeyAgreementContainer, new EndContainer(), publicKeyContainer, new EndContainer()};
        this.originatorPublicKey = ASN1.derEncode((ASN1Container[])bitStringAsn1Containers);
        ASN1Container[] keyEncryptioAlgorithmIdentifierASN1Containers = new ASN1Container[]{new SequenceContainer(0), echdOidContainer, new SequenceContainer(0), wrapOidContainer, new EndContainer(), new EndContainer()};
        ASN1.berDecode((byte[])keyEncryptioAlgorithmIdentifierContainer.data, (int)keyEncryptioAlgorithmIdentifierContainer.dataOffset, (ASN1Container[])keyEncryptioAlgorithmIdentifierASN1Containers);
        this.messageDigestOID = new byte[echdOidContainer.dataLen];
        System.arraycopy(echdOidContainer.data, echdOidContainer.dataOffset, this.messageDigestOID, 0, this.messageDigestOID.length);
        this.keyEncryptionOID = new byte[wrapOidContainer.dataLen];
        System.arraycopy(wrapOidContainer.data, wrapOidContainer.dataOffset, this.keyEncryptionOID, 0, this.keyEncryptionOID.length);
        this.userKeyingMaterialContainer = userKeyingMaterialContainer;
        OctetStringContainer encryptedKeyContainer = new OctetStringContainer(65280);
        ASN1Container[] encryptedKeyASN1Containers = new ASN1Container[]{new SequenceContainer(0), new SequenceContainer(0), new EncodedContainer(65280), encryptedKeyContainer, new EndContainer(), new EndContainer()};
        ASN1.berDecode((byte[])recipientsEncryptionKeysContainer.data, (int)recipientsEncryptionKeysContainer.dataOffset, (ASN1Container[])encryptedKeyASN1Containers);
        this.encryptedKey = encryptedKeyContainer;
    }

    private byte[] getECDHSharedSecret(JSAFE_PrivateKey recipientPrivateKey) throws Exception {
        JSAFE_KeyAgree receiver = JSAFE_KeyAgree.getInstance((String)"ECDH", (String)"Java");
        SecureRandom random = JSAFE_SecureRandom.getInstance((String)PKCS7Utils.getCurveStrength(this.keyEncryptionOID), (String)"Java");
        receiver.keyAgreeInit(recipientPrivateKey, random);
        JSAFE_PublicKey originatorPublicKey = JSAFE_PublicKey.getInstance((byte[])this.originatorPublicKey, (int)0, (String)"Java");
        return receiver.generateSharedSecret(originatorPublicKey);
    }

    byte[] getKeyDecrypted(JSAFE_PrivateKey privateKey) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, IOException, JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_InputException, JSAFE_PaddingException {
        JSAFE_AsymmetricCipher decrypter = PKCS7Utils.getAsymmetricCipher(this.keyEncryptionOID);
        decrypter.decryptInit(privateKey);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(decrypter.decryptUpdate(this.encryptedKey.data, this.encryptedKey.dataOffset, this.encryptedKey.dataLen));
        outputStream.write(decrypter.decryptFinal());
        return outputStream.toByteArray();
    }

    byte[] decryptEncryptedData(JSAFE_SecretKey inKey) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException, JSAFE_InputException, JSAFE_PaddingException, IOException {
        JSAFE_SymmetricCipher symmetricCipher = PKCS7Utils.getSymmetricCipher(this.dataEncryptionAlgorithm);
        symmetricCipher.setIV(this.ecDataIV.data, this.ecDataIV.dataOffset, this.ecDataIV.dataLen);
        symmetricCipher.decryptInit(inKey);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(symmetricCipher.decryptUpdate(this.encryptedData.data, this.encryptedData.dataOffset, this.encryptedData.dataLen));
        outputStream.write(symmetricCipher.decryptFinal());
        return outputStream.toByteArray();
    }

    private void decodeASN1KARI(ASN1Container recipientInfoChoiceContainer, IntegerContainer recipientInfoVersion, OctetStringContainer userKeyingMaterialContainer, EncodedContainer keyEncryptioAlgorithmIdentifierContainer, EncodedContainer recipientsEncryptionKeysContainer, EncodedContainer publicKeyContainer, OIDContainer oidPublicKeyContainer, OIDContainer oidKeyAgreementContainer) throws ASN_Exception {
        if (recipientInfoChoiceContainer.dataPresent && recipientInfoChoiceContainer.data[recipientInfoChoiceContainer.dataOffset] == -95) {
            OfContainer recipientInfo = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(65280));
            ASN1Container[] recipientInfos = new ASN1Container[]{new ChoiceContainer(0x800001), recipientInfo, new EndContainer()};
            ASN1.berDecode((byte[])recipientInfoChoiceContainer.data, (int)recipientInfoChoiceContainer.dataOffset, (ASN1Container[])recipientInfos);
            if (recipientInfo.dataPresent) {
                ASN1Container versionEncContainer = recipientInfo.containerAt(0);
                ASN1.berDecode((byte[])versionEncContainer.data, (int)versionEncContainer.dataOffset, (ASN1Container[])new ASN1Container[]{recipientInfoVersion});
                ASN1Container[] ukm = new ASN1Container[]{new ChoiceContainer(10551041), userKeyingMaterialContainer, new EndContainer()};
                ASN1Container ukmContainer = recipientInfo.containerAt(2);
                ASN1.berDecode((byte[])ukmContainer.data, (int)ukmContainer.dataOffset, (ASN1Container[])ukm);
                ASN1Container keyEncryptionContainer = recipientInfo.containerAt(3);
                ASN1.berDecode((byte[])keyEncryptionContainer.data, (int)keyEncryptionContainer.dataOffset, (ASN1Container[])new ASN1Container[]{keyEncryptioAlgorithmIdentifierContainer});
                ASN1Container encryptionKey = recipientInfo.containerAt(4);
                ASN1.berDecode((byte[])encryptionKey.data, (int)encryptionKey.dataOffset, (ASN1Container[])new ASN1Container[]{recipientsEncryptionKeysContainer});
                ASN1Container originatorContainer = recipientInfo.containerAt(1);
                EncodedContainer originatorOrIdentifierOrKeyEncodedContainer = new EncodedContainer(0xA0FF00);
                ASN1Container[] originatorOrIdentifierOrKey = new ASN1Container[]{originatorOrIdentifierOrKeyEncodedContainer};
                ASN1.berDecode((byte[])originatorContainer.data, (int)originatorContainer.dataOffset, (ASN1Container[])originatorOrIdentifierOrKey);
                byte[] OriginatorPublicKey = new byte[originatorOrIdentifierOrKeyEncodedContainer.dataLen - 4];
                System.arraycopy(originatorOrIdentifierOrKeyEncodedContainer.data, originatorOrIdentifierOrKeyEncodedContainer.dataOffset + 4, OriginatorPublicKey, 0, OriginatorPublicKey.length);
                OfContainer originatorPublicKeySequence = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(65280));
                ASN1Container[] originatorPublicKeyContainer = new ASN1Container[]{originatorPublicKeySequence};
                ASN1.berDecode((byte[])OriginatorPublicKey, (int)0, (ASN1Container[])originatorPublicKeyContainer);
                ASN1Container[] algorithmIdentifierContainers = new ASN1Container[]{new SequenceContainer(0), oidPublicKeyContainer, oidKeyAgreementContainer, new EndContainer()};
                ASN1Container algorithmIdentifier = originatorPublicKeySequence.containerAt(0);
                ASN1.berDecode((byte[])algorithmIdentifier.data, (int)algorithmIdentifier.dataOffset, (ASN1Container[])algorithmIdentifierContainers);
                ASN1Container publicKey = originatorPublicKeySequence.containerAt(1);
                ASN1.berDecode((byte[])publicKey.data, (int)publicKey.dataOffset, (ASN1Container[])new ASN1Container[]{publicKeyContainer});
            }
        }
    }

    private void decodeASN1KARI_A11Old(EncodedContainer recipientsInfosContainer, IntegerContainer recipientInfoVersion, OctetStringContainer userKeyingMaterialContainer, EncodedContainer keyEncryptioAlgorithmIdentifierContainer, EncodedContainer recipientsEncryptionKeysContainer, EncodedContainer publicKeyContainer, OIDContainer oidPublicKeyContainer, OIDContainer oidKeyAgreementContainer) throws ASN_Exception {
        ASN1Container[] recipientInfo = new ASN1Container[]{new SetContainer(0), new SequenceContainer(0), recipientInfoVersion, new ChoiceContainer(0xA0FF00), new SequenceContainer(0), new SequenceContainer(0), oidPublicKeyContainer, oidKeyAgreementContainer, new EndContainer(), publicKeyContainer, new EndContainer(), new EndContainer(), new ChoiceContainer(10551041), userKeyingMaterialContainer, new EndContainer(), keyEncryptioAlgorithmIdentifierContainer, recipientsEncryptionKeysContainer, new EndContainer(), new EndContainer()};
        ASN1.berDecode((byte[])recipientsInfosContainer.data, (int)recipientsInfosContainer.dataOffset, (ASN1Container[])recipientInfo);
    }
}

