/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.graphicsDOM.utils;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.TilingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GlyphAbsoluteOutlineGenerator;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class GraphicsUtils {
    public static final String DeviceGray = ASName.k_DeviceGray.asString();
    public static final String DeviceRGB = ASName.k_DeviceRGB.asString();
    public static final String DeviceCMYK = ASName.k_DeviceCMYK.asString();

    private GraphicsUtils() {
    }

    public static int readNthSample(byte[] data, int bpv, int n) {
        if (bpv == 8) {
            return data[n];
        }
        int bitPosToStartFrom = n * bpv;
        int bytePosInData = bitPosToStartFrom / 8;
        int leftBitsToIgnoreFromCurrentByte = bitPosToStartFrom - bytePosInData * 8;
        int bitsToReadFromCurrentByte = bpv < 8 - leftBitsToIgnoreFromCurrentByte ? bpv : 8 - leftBitsToIgnoreFromCurrentByte;
        int returnValue = data[bytePosInData] & 255 >> leftBitsToIgnoreFromCurrentByte;
        returnValue >>= 8 - leftBitsToIgnoreFromCurrentByte - bitsToReadFromCurrentByte;
        for (int moreBitsToRead = bpv - bitsToReadFromCurrentByte; moreBitsToRead != 0; moreBitsToRead -= bitsToReadFromCurrentByte) {
            bitsToReadFromCurrentByte = moreBitsToRead > 8 ? 8 : moreBitsToRead;
            int left = returnValue << bitsToReadFromCurrentByte;
            int right = data[++bytePosInData] >> 8 - bitsToReadFromCurrentByte;
            returnValue = left | right;
        }
        return returnValue;
    }

    public static double scaleToRange(double inputRangeMin, double inputRangeMax, double inputValueToBeScaledToRange, double outputRangeMin, double outputRangeMax) {
        return outputRangeMin + (inputValueToBeScaledToRange - inputRangeMin) * (outputRangeMin - outputRangeMax) / (inputRangeMin - inputRangeMax);
    }

    public static int rint(double a) {
        if (a - (double)((int)a) <= 0.5) {
            return (int)a;
        }
        return (int)a + 1;
    }

    public static boolean equalPaths(GeneralPath path1, GeneralPath path2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.getWindingRule() != path2.getWindingRule()) {
            return false;
        }
        PathIterator pathItr1 = path1.getPathIterator(null);
        PathIterator pathItr2 = path2.getPathIterator(null);
        double[] coords1 = new double[6];
        double[] coords2 = new double[6];
        while (!pathItr1.isDone() && !pathItr2.isDone()) {
            int segType2;
            int segType1 = pathItr1.currentSegment(coords1);
            if (segType1 != (segType2 = pathItr2.currentSegment(coords2)) || !Arrays.equals(coords1, coords2)) {
                return false;
            }
            pathItr1.next();
            pathItr2.next();
        }
        return pathItr1.isDone() && pathItr2.isDone();
    }

    public static int toARGB(double[] rgb, double alpha) {
        int a = GraphicsUtils.rint(alpha * 255.0);
        int red = GraphicsUtils.rint(rgb[0] * 255.0);
        int green = GraphicsUtils.rint(rgb[1] * 255.0);
        int blue = GraphicsUtils.rint(rgb[2] * 255.0);
        return a << 24 | red << 16 | green << 8 | blue;
    }

    public static double[] getClipBounds(TilingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> tilingPattern, Rectangle2D virtualRect, Rectangle2D patternVirtualRect, int[] posBounds) {
        double[] clipBounds = new double[]{virtualRect.getX(), virtualRect.getY() + patternVirtualRect.getHeight(), virtualRect.getX() + virtualRect.getWidth(), virtualRect.getY() + virtualRect.getHeight() + patternVirtualRect.getHeight()};
        double clipBoundsXmin = clipBounds[0] - patternVirtualRect.getWidth() - tilingPattern.getPhase()[0];
        double clipBoundsYmin = clipBounds[1] - patternVirtualRect.getHeight() - tilingPattern.getPhase()[1];
        double clipBoundsXMax = Math.ceil(clipBounds[2] + patternVirtualRect.getWidth()) - tilingPattern.getPhase()[0];
        double clipBoundsYMax = Math.ceil(clipBounds[3] + patternVirtualRect.getHeight()) - tilingPattern.getPhase()[1];
        GraphicsUtils.getExactPatternCellPositionNearby(clipBoundsXmin, clipBoundsYmin, tilingPattern, posBounds);
        GraphicsUtils.getExactPatternCellPositionNearby(clipBoundsXMax, clipBoundsYmin, tilingPattern, posBounds);
        GraphicsUtils.getExactPatternCellPositionNearby(clipBoundsXMax, clipBoundsYMax, tilingPattern, posBounds);
        GraphicsUtils.getExactPatternCellPositionNearby(clipBoundsXmin, clipBoundsYMax, tilingPattern, posBounds);
        return new double[]{clipBoundsXmin, clipBoundsYmin, clipBoundsXMax, clipBoundsYMax};
    }

    private static void getExactPatternCellPositionNearby(double X, double Y, TilingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> tilingPattern, int[] posBounds) {
        double[] xStep = tilingPattern.getXStep();
        double[] yStep = tilingPattern.getYStep();
        double posX = (X * yStep[1] - Y * yStep[0]) / (xStep[0] * yStep[1] - xStep[1] * yStep[0]);
        double posY = (Y * xStep[0] - X * xStep[1]) / (xStep[0] * yStep[1] - xStep[1] * yStep[0]);
        if ((int)posX < posBounds[0]) {
            posBounds[0] = (int)posX;
        }
        if ((int)posY < posBounds[1]) {
            posBounds[1] = (int)posY;
        }
        if ((int)posX > posBounds[2]) {
            posBounds[2] = (int)posX + 1;
        }
        if ((int)posY > posBounds[3]) {
            posBounds[3] = (int)posY + 1;
        }
    }

    public static double[] placeCell(int posX, int posY, TilingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> tilingPattern) {
        double[] xStep = tilingPattern.getXStep();
        double[] yStep = tilingPattern.getYStep();
        return new double[]{(double)posY * yStep[0] + (double)posX * xStep[0], (double)posY * yStep[1] + (double)posX * xStep[1]};
    }

    public static String generateKey(int objNumber, ASName objName, double[] rgbColor) {
        if (objNumber != 0) {
            StringBuilder key = new StringBuilder(String.valueOf(objNumber));
            if (rgbColor != null) {
                return key.append(Arrays.hashCode(rgbColor)).toString();
            }
            return key.toString();
        }
        if (objName == ASName.k_DeviceGray) {
            return DeviceGray;
        }
        if (objName == ASName.k_DeviceRGB) {
            return DeviceRGB;
        }
        if (objName == ASName.k_DeviceCMYK) {
            return DeviceCMYK;
        }
        return objName != null ? objName.asString() : null;
    }

    public static AffineTransform pdfToRasterTransform(double[] transformation, double scalingFactorW, double scalingFactorH, int width, int height, double pageHeight, boolean isTilingPattern, Graphics2D g2) {
        AffineTransform img2user = new AffineTransform();
        img2user.setTransform(transformation[0], transformation[1], transformation[2], transformation[3], 0.0, 0.0);
        img2user.scale(scalingFactorW / (double)width, -scalingFactorH / (double)height);
        Point2D.Double point = new Point2D.Double(0.0, height);
        img2user.transform(point, point);
        if (isTilingPattern) {
            AffineTransform xform = new AffineTransform();
            xform.translate(point.x, point.y - pageHeight);
            g2.transform(xform);
        }
        img2user.setTransform(transformation[0], -transformation[1], -transformation[2], transformation[3], scalingFactorW * transformation[4], pageHeight - scalingFactorH * transformation[5]);
        img2user.scale(scalingFactorW / (double)width, -scalingFactorH / (double)height);
        img2user.setTransform(img2user.getScaleX(), img2user.getShearY(), img2user.getShearX(), img2user.getScaleY(), img2user.getTranslateX() - point.x, img2user.getTranslateY() + point.y);
        img2user.scale(1.0, -1.0);
        return img2user;
    }

    public static GeneralPath getGlyphsOulines(int gid, Font font) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData fontData = ((FontImpl)font).getFontData();
        GeneralPath glyphOutline = null;
        GlyphAbsoluteOutlineGenerator glyphOutlineGenerator = new GlyphAbsoluteOutlineGenerator(null);
        fontData.getGlyphOutline(gid, glyphOutlineGenerator);
        glyphOutline = glyphOutlineGenerator.getOutline();
        return glyphOutline;
    }

    public static GeneralPath getTransformedGlyphsOutlines(GeneralPath glyphOutline, int gid, ASMatrix textMatrix, double fontSize, double textRise, Glyph glyph, Font font) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        if (glyphOutline == null) {
            glyphOutline = GraphicsUtils.getGlyphsOulines(gid, font);
        }
        ASMatrix transformationMatrix = new ASMatrix(textMatrix.geta() * fontSize, textMatrix.getb() * fontSize, textMatrix.getc() * fontSize, textMatrix.getd() * fontSize, glyph.getXPos(), glyph.getYPos() + textRise);
        glyphOutline = (GeneralPath)glyphOutline.clone();
        glyphOutline.transform(new AffineTransform(transformationMatrix.getValues()));
        glyph.setGlyphOutline(glyphOutline);
        return glyphOutline;
    }
}

