/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.legacy.services.ap.es2;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.inlineformatting.FormattingException;
import com.adobe.internal.afml.AFMLException;
import com.adobe.internal.afml.AFMLExceptionInvalidParameter;
import com.adobe.internal.afml.AFMLExceptionUnsupportedFeature;
import com.adobe.internal.agm.AGMException;
import com.adobe.internal.agm.AGMPort;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.legacy.services.xfatext.es2.FormatXFAResultInfo;
import com.adobe.internal.pdftoolkit.legacy.services.xfatext.es2.FormatXFAText;
import com.adobe.internal.pdftoolkit.legacy.services.xfatext.es2.RegionAndAnnotInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.StyleAttributes;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.DefaultFont;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGWrapOption;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TextFormatterES2Impl
implements TextFormatter {
    private static final String BODY_NAME_START = "<b";
    private static final String XML_END_TAG = ">";
    private static final String STYLE_NAME = " style";
    private static final String PARA_NAME_TEXTVALIGN = "text-valign:";
    private static final String PARA_NAME_END = ";";
    private static final String ALIGNMENT_MIDDLE = "middle";
    private static final String ALIGNMENT_TOP = "top";
    private boolean doXFACosSynch;
    private static final String BACKGROUND_HIGHLIGHT_COLOR_RED = "153";
    private static final String BACKGROUND_HIGHLIGHT_COLOR_GREEN = "193";
    private static final String BACKGROUND_HIGHLIGHT_COLOR_BLUE = "218";

    public TextFormatterES2Impl(boolean doXFACosSynch) {
        this.doXFACosSynch = doXFACosSynch;
    }

    @Override
    public AppearanceAttributes fetchAppearanceAttributes(PDFAnnotation annot, PDFResources defResources, Locale locale) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException, PDFInvalidParameterException, PDFFontException {
        PDFField field = PDFField.getInstance(annot.getCosObject());
        PDFVariableText varText = PDFVariableText.getInstance(field.getCosObject());
        PDFDocument curDoc = field.getPDFDocument();
        AppearanceAttributes appearanceAttributes = TextFormatterES2Impl.getAppearanceAttributesFromCOS(annot, field, curDoc, defResources, locale, varText);
        if (this.doXFACosSynch && curDoc.getInteractiveForm().hasXFA()) {
            try {
                XFADOMService.getXFADOM(curDoc, null, false, true);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFIOException(e);
            }
        }
        if (appearanceAttributes.getStyleAttributes().getFontSize() == 0.0) {
            appearanceAttributes.getStyleAttributes().setFontSize(DefaultFont.getDefaultSize(locale));
        }
        int fieldFlags = 0;
        if (field != null && field.hasFlags()) {
            fieldFlags = field.getFlags();
        }
        appearanceAttributes.setMultiLine((fieldFlags & 0x1000) != 0);
        if (appearanceAttributes.isMultiLine() & !appearanceAttributes.isAutoSize() || annot instanceof PDFAnnotationRedaction) {
            appearanceAttributes.getStyleAttributes().setLineHeightPrecedenceOverride("use-font-size");
        }
        double[] clipPadding = null;
        PDFBorderStyle bs = annot.getBorderStyle();
        double lineWidth = 1.0;
        if (bs != null && bs.hasWidth()) {
            lineWidth = bs.getWidth();
        }
        clipPadding = new double[]{lineWidth, lineWidth, lineWidth, lineWidth};
        appearanceAttributes.setClipPadding(clipPadding);
        String valueText = TextFormatterES2Impl.getFieldValue(appearanceAttributes.isRichText(), curDoc, field, varText, appearanceAttributes.getStyleAttributes().getStyleString(), appearanceAttributes.getPasswordChar(), this.doXFACosSynch);
        appearanceAttributes.setTextValue(valueText);
        appearanceAttributes.setField(field);
        return appearanceAttributes;
    }

    private static AppearanceAttributes getAppearanceAttributesFromCOS(PDFAnnotation annot, PDFField field, PDFDocument curDoc, PDFResources defResources, Locale locale, PDFVariableText varText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isRichText = varText.getRichText() != null;
        int quadding = varText.getQuadding();
        String fieldDefStyle = varText.getDefaultStyle();
        StyleAttributes defaultStyleAttr = null;
        RCGOptions options = null;
        boolean autoSize = false;
        if (fieldDefStyle == null) {
            String defAppearance = null;
            if (varText != null && varText.getDefaultAppearance() != null) {
                defAppearance = varText.getDefaultAppearance().asString();
            }
            if (defAppearance == null) {
                defAppearance = curDoc.getInteractiveForm().getDefaultAppearance();
            }
            autoSize = (defaultStyleAttr = AppearanceUtils.makeStyle(curDoc, defaultStyleAttr, defAppearance, quadding, defResources, locale)).getFontSize() == 0.0;
            options = TextFormatterES2Impl.getOptions(annot, field, autoSize);
            if (field instanceof PDFFieldText && ((PDFFieldText)field).isComb() && annot instanceof PDFAnnotationWidget) {
                AppearanceUtils.addCombFontSize((PDFFieldText)field, (PDFAnnotationWidget)annot, autoSize, options, defaultStyleAttr);
            }
        } else {
            defaultStyleAttr = new StyleAttributes(fieldDefStyle);
            options = TextFormatterES2Impl.getOptions(annot, field, autoSize);
        }
        AppearanceAttributes ap = new AppearanceAttributes(defaultStyleAttr, options);
        ap.setRichText(isRichText);
        ap.setAutoSize(autoSize);
        return ap;
    }

    private static String getFieldValue(boolean isRichText, PDFDocument curDoc, PDFField pdfField, PDFVariableText varText, String style, char passwordChar, boolean isXFAProcessed) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String valueText = null;
        valueText = isRichText ? (pdfField.getValueList() != null ? TextFormatterES2Impl.synchRichTextWithPlainText(curDoc, pdfField, varText, style, passwordChar, isXFAProcessed) : varText.getRichText()) : RichTextHandler.getRichTextForValue(pdfField, passwordChar, isXFAProcessed);
        if (valueText == null) {
            return "";
        }
        return valueText;
    }

    private static RCGOptions getOptions(PDFAnnotation annot, PDFField field, boolean autoSize) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isRichTextValue;
        PDFRectangle targetRect = null;
        if (annot.getNormalStateAppearance() != null) {
            PDFXObjectForm appearanceOld = annot.getNormalStateAppearance();
            targetRect = appearanceOld.getBBox();
        } else if (annot instanceof PDFAnnotationWidget) {
            targetRect = AppearanceUtils.getBBoxRectangle((PDFAnnotationWidget)annot);
        } else {
            PDFRectangle annotRect = annot.getRect();
            targetRect = PDFRectangle.newInstance(annot.getPDFDocument(), 0.0, 0.0, annotRect.width(), annotRect.height());
        }
        RCGOptions options = new RCGOptions(targetRect.width(), targetRect.height());
        double borderWidth = AppearanceUtils.getBorderWidth(annot);
        int fieldFlags = 0;
        if (field != null && field.hasFlags()) {
            fieldFlags = field.getFlags();
        }
        boolean isMultiLine = (fieldFlags & 0x1000) != 0;
        boolean bl = isRichTextValue = (fieldFlags & 0x2000000) != 0;
        if (!isMultiLine) {
            options.setVerticalAlignment(RCGAlignment.Middle);
            options.setWrap(RCGWrapOption.NoWrap);
        } else {
            options.setVerticalAlignment(RCGAlignment.Top);
            options.setWrap(RCGWrapOption.Emergency);
        }
        if (field instanceof PDFFieldChoice && !((PDFFieldChoice)field).isComboBox()) {
            options.setVerticalAlignment(RCGAlignment.Top);
        }
        if (autoSize && !isMultiLine && !isRichTextValue) {
            options.setOverflow(RCGOverflowMode.ShrinkToFit);
        } else {
            options.setOverflow(RCGOverflowMode.Auto);
        }
        if (field instanceof PDFFieldText && ((PDFFieldText)field).isComb()) {
            options.setOverflow(RCGOverflowMode.Auto);
        }
        double paddingLeft = borderWidth * 2.0;
        double paddingRight = borderWidth * 2.0;
        double paddingTop = borderWidth;
        double paddingBottom = borderWidth;
        if (isMultiLine) {
            paddingTop *= 2.0;
            if (autoSize && !isRichTextValue) {
                paddingBottom *= 2.0;
            }
        }
        try {
            if (targetRect.width() - paddingLeft - paddingRight > 0.0) {
                options.setPaddingLeft(paddingLeft);
                options.setPaddingRight(paddingRight);
            } else {
                options.setPaddingLeft(0.0);
                options.setPaddingRight(0.0);
            }
            if (targetRect.height() - paddingTop - paddingBottom > 0.0) {
                options.setPaddingTop(paddingTop);
                options.setPaddingBottom(paddingBottom);
            } else {
                options.setPaddingTop(0.0);
                options.setPaddingBottom(0.0);
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Cannot set RCGOptions.", e);
        }
        return options;
    }

    private static String synchRichTextWithPlainText(PDFDocument curDoc, PDFField pdfField, PDFVariableText varText, String style, char passwordChar, boolean isXFAProcessed) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        String styleStrippedQuote;
        boolean replaceRV = false;
        String valueText = null;
        if (varText.getRichText() != null && pdfField.getValueList() != null && pdfField instanceof PDFFieldText) {
            valueText = varText.getRichText();
            RichTextHandler handler = new RichTextHandler();
            String richTextRawString = handler.getRawContent(varText.getRichText());
            List valueVList = pdfField.getValueList();
            if (valueVList == null || valueVList.isEmpty() || richTextRawString == null || richTextRawString.length() == 0) {
                replaceRV = true;
            } else {
                boolean promotePlainText;
                if (valueVList.size() > 1) {
                    throw new PDFInvalidDocumentException("A text field has more than one value.");
                }
                String stringValue = (String)valueVList.get(0);
                stringValue = stringValue.replaceAll("(\n\r)|(\r\n)|[\n]|[\r]", "");
                boolean promoteRichText = !PDFText.isUTF16(richTextRawString = richTextRawString.replaceAll("(\n\r)|(\r\n)|[\n]|[\r]", ""));
                boolean bl = promotePlainText = !PDFText.isUTF16(stringValue);
                if (promoteRichText && !promotePlainText) {
                    PDFText rawRichTextUTF16 = PDFText.newInstance(richTextRawString, true, curDoc);
                    richTextRawString = rawRichTextUTF16.stringValue();
                }
                if (!promoteRichText && promotePlainText) {
                    PDFText plainTextUTF16 = PDFText.newInstance(stringValue, true, curDoc);
                    stringValue = plainTextUTF16.stringValue();
                }
                if (promoteRichText) {
                    richTextRawString = richTextRawString.replaceAll("\u00a0", " ");
                    stringValue = stringValue.replaceAll("\u00a0", " ");
                }
                if (!stringValue.equals(richTextRawString)) {
                    replaceRV = true;
                }
            }
        }
        if ((replaceRV || varText.getRichText() == null || pdfField instanceof PDFFieldChoice) && (valueText = RichTextHandler.getRichTextForValue(pdfField, passwordChar, isXFAProcessed)) != null && replaceRV && style != null && style.trim().length() > 0 && (valueText = TextFormatterES2Impl.insertAttributeToXMLBody(valueText, styleStrippedQuote = " style=\"" + style.replaceAll("\"", "") + "\"")) != null) {
            varText.setRichText(valueText);
        }
        return valueText;
    }

    static String insertAttributeToXMLBody(String xml, String attr) {
        String ret = null;
        int idxBodyStartBracket = xml.indexOf(BODY_NAME_START);
        int idxBodyEndBracket = xml.indexOf(XML_END_TAG, idxBodyStartBracket);
        if (xml.indexOf(BODY_NAME_START) > -1 && idxBodyEndBracket > -1) {
            ret = xml.substring(0, idxBodyEndBracket) + attr + xml.substring(idxBodyEndBracket);
        }
        return ret;
    }

    @Override
    public void formatAndRenderText(AppearanceAttributes appearanceAttributes, PDFFontSet pdfFonts, Font psFont, AGMPort agmPort) throws PDFConfigurationException, PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            PDFField field = appearanceAttributes.getField();
            String textString = appearanceAttributes.getTextValue();
            FormatXFAText textFormatter = new FormatXFAText();
            RCGOptions options = appearanceAttributes.getRcgOptions();
            StyleAttributes styleAttributes = appearanceAttributes.getStyleAttributes();
            if (field instanceof PDFFieldChoice && !((PDFFieldChoice)field).isComboBox()) {
                textString = TextFormatterES2Impl.buildListBoxAppearance(textString, field);
            }
            FormatXFAResultInfo resultInfo = TextFormatterES2Impl.preFormat(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
            if ((options.getVerticalAlignment().equals(RCGAlignment.Middle) || options.getVerticalAlignment().equals(RCGAlignment.Bottom) || appearanceAttributes.isRichText() && TextFormatterES2Impl.getFirstTextVAlignInRichText(textString).equalsIgnoreCase(ALIGNMENT_MIDDLE)) && options.getOverflowMode().equals(RCGOverflowMode.Auto)) {
                String oldLineHeight = appearanceAttributes.getStyleAttributes().getLineHeight();
                double oldAdjstBelowBaselineFactor = options.getAdjustmentBelowBaselineFactor();
                if (!appearanceAttributes.isMultiLine() && TextFormatterES2Impl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText())) {
                    styleAttributes.setLineHeight(String.valueOf(styleAttributes.getFontSize()));
                    options.setAdjustmentBelowBaselineFactor(0.0);
                    resultInfo = TextFormatterES2Impl.preFormat(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
                }
                styleAttributes.setLineHeight(oldLineHeight);
                options.setAdjustmentBelowBaselineFactor(oldAdjstBelowBaselineFactor);
                if (TextFormatterES2Impl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText())) {
                    options.setVerticalAlignment(RCGAlignment.Top);
                    textString = TextFormatterES2Impl.setTextVAlignInRichText(textString, ALIGNMENT_TOP);
                    resultInfo = null;
                    resultInfo = TextFormatterES2Impl.preFormat(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
                }
            } else if (appearanceAttributes.isMultiLine() && options.getOverflowMode().equals(RCGOverflowMode.Auto) && appearanceAttributes.isAutoSize()) {
                if (TextFormatterES2Impl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText())) {
                    options.setOverflow(RCGOverflowMode.ShrinkToFit);
                    resultInfo = null;
                    resultInfo = TextFormatterES2Impl.preFormat(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
                }
            } else if (appearanceAttributes.isMultiLine() && options.getOverflowMode().equals(RCGOverflowMode.Auto)) {
                double overflowFactor = 1.0;
                if (TextFormatterES2Impl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText())) {
                    options.setAdjustmentBelowBaselineFactor(0.0);
                    FormatXFAResultInfo tempResultInfo = TextFormatterES2Impl.preFormat(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
                    if (!TextFormatterES2Impl.isTextOverflowed(tempResultInfo, options, textString, appearanceAttributes.isRichText())) {
                        resultInfo = tempResultInfo;
                        double overflowMax = overflowFactor;
                        double overflowMin = 0.0;
                        for (int count = 0; count < 4; ++count) {
                            options.setAdjustmentBelowBaselineFactor((overflowMax + overflowMin) / 2.0);
                            tempResultInfo = TextFormatterES2Impl.preFormat(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
                            if (TextFormatterES2Impl.isTextOverflowed(tempResultInfo, options, textString, appearanceAttributes.isRichText())) {
                                overflowMax = (overflowMax + overflowMin) / 2.0;
                                continue;
                            }
                            resultInfo = tempResultInfo;
                            overflowMin = (overflowMax + overflowMin) / 2.0;
                        }
                    }
                }
            }
            resultInfo.renderRegion((Object)agmPort, 0, 0);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid Font in the Font Set.", e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFUnsupportedFeatureException("Attempt to use unsupported font type.", e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("Error loading a font.", e);
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Invalid document, error during text formatting. ", e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Formatting error. " + e.getMessage(), e);
        }
        catch (AFMLException e) {
            throw new PDFInvalidDocumentException("Formatting error. " + e.getMessage(), e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Formatting error. " + e.getMessage(), e);
        }
    }

    private static FormatXFAResultInfo preFormat(FormatXFAText textFormatter, Font psFont, PDFFontSet pdfFonts, String textString, AppearanceAttributes appearanceAttributes) throws PDFConfigurationException, PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException {
        FormatXFAResultInfo resultInfo = null;
        boolean preserve_old_behaviour = false;
        try {
            ByteArrayInputStream textValue;
            try {
                textValue = new ByteArrayInputStream(textString.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Error decoding a rich text string: ", e);
            }
            if (appearanceAttributes.getRcgOptions().getVerticalAlignment() == RCGAlignment.Middle) {
                preserve_old_behaviour = true;
            }
            resultInfo = appearanceAttributes.isRichText() ? textFormatter.processXFAText(appearanceAttributes.getRcgOptions().getTargetRegion().toString(), appearanceAttributes.getStyleAttributes().getStyleString(), (InputStream)textValue, null, pdfFonts, Boolean.valueOf(preserve_old_behaviour)) : textFormatter.processPlainText(appearanceAttributes.getRcgOptions().getTargetRegion().toString(), appearanceAttributes.getStyleAttributes().getStyleString(), (InputStream)textValue, null, psFont, pdfFonts.getFallbackFontSet(), Boolean.valueOf(preserve_old_behaviour));
        }
        catch (IOException e) {
            throw new PDFIOException("IO Exception FormatXFAText.processXFAText().", e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException("Parser Configuration Exception FormatXFAText.processXFAText().", e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("SAX Exception FormatXFAText.processXFAText()", e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid Font in the Font Set.", e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFUnsupportedFeatureException("Attempt to use unsupported font type.", e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("Error loading a font.", e);
        }
        catch (FormattingException e) {
            throw new PDFFontException("Error formatting with a fontset.", e);
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Invalid document, error during text formatting.", e);
        }
        catch (AFMLExceptionUnsupportedFeature e) {
            throw new PDFUnsupportedFeatureException("Feature not supported, error during text formatting.", e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Formatting error.", e);
        }
        catch (FontException e) {
            throw new PDFFontException("Error during text formatting.", e);
        }
        catch (PDFFontException e) {
            throw new PDFFontException("Error while gettin fallback font set", e);
        }
        if (resultInfo == null) {
            throw new PDFInvalidDocumentException("FormatXFAText returns invalid Null object.");
        }
        return resultInfo;
    }

    private static String getFirstTextVAlignInRichText(String text) {
        int idxStart = text.indexOf(PARA_NAME_TEXTVALIGN);
        if (idxStart > -1) {
            int idxEnd = text.indexOf(PARA_NAME_END, idxStart += PARA_NAME_TEXTVALIGN.length());
            if (idxEnd == -1) {
                return text.substring(idxStart).trim();
            }
            return text.substring(idxStart, idxEnd).trim();
        }
        return "";
    }

    private static String setTextVAlignInRichText(String text, String newVAlign) {
        int idxStart = text.indexOf(PARA_NAME_TEXTVALIGN);
        if (idxStart > -1) {
            int idxEnd = text.indexOf(PARA_NAME_END, idxStart);
            String replacedAttr = null;
            replacedAttr = idxEnd == -1 ? text.substring(idxStart) : text.substring(idxStart, idxEnd + 1);
            text = text.replaceAll(replacedAttr, PARA_NAME_TEXTVALIGN + newVAlign + PARA_NAME_END);
        }
        return text;
    }

    private static boolean isTextOverflowed(FormatXFAResultInfo resultInfo, RCGOptions options, String textValue, boolean isRichText) throws AFMLException, PDFInvalidDocumentException {
        ArrayList regionSizes = resultInfo.getRegionSizes();
        if (regionSizes != null) {
            if (regionSizes.size() == 1) {
                double targetHeight;
                RegionAndAnnotInfo regionInfo = (RegionAndAnnotInfo)regionSizes.get(0);
                double resultHeight = regionInfo.getTop() - regionInfo.getBottom();
                return resultHeight > (targetHeight = options.getHeight() - options.getPaddingBottom() - options.getPaddingTop());
            }
            if (regionSizes.isEmpty() && isRichText && new RichTextHandler().getRawContent(textValue) == null) {
                return false;
            }
        }
        throw new PDFInvalidDocumentException("FormatXFAText returns invalid region sizes arraylist object.");
    }

    private static String buildListBoxAppearance(String plainTextString, PDFField field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (field instanceof PDFFieldChoice && !((PDFFieldChoice)field).isComboBox()) {
            String bgCOLOR_NAME = "background-color";
            String fontHL_COLOR_ATTR = " color=\"rgb(0,0,0)\"";
            String fontHL_COLOR_CSS = ";color:#000000";
            String bgCOLOR_STYLE_ATTR = "background-color=\"rgb(153,193,218)\"";
            String bgCOLOR_STYLE_CSS = "background-color:rgb(153,193,218);";
            if (field.getValueList() != null) {
                if (field.getValueList().size() == 0) {
                    return plainTextString;
                }
                int[] indexArray = new int[1];
                if (field.getValueList().size() == 1) {
                    indexArray[0] = PDFFieldUtils.getSelectedIndexForChoiceField((String)field.getValueList().get(0), ((PDFFieldChoice)field).getOptionList(), field.getQualifiedName());
                    if (indexArray[0] == -1) {
                        return plainTextString;
                    }
                } else if (((PDFFieldChoice)field).hasIndexArray()) {
                    indexArray = ((PDFFieldChoice)field).getIndexArray();
                }
                if (indexArray.length > 0) {
                    int idxOffset = ((PDFFieldChoice)field).getTopIndex();
                    if (idxOffset > ((PDFFieldChoice)field).getOptionList().size() - 1) {
                        throw new PDFInvalidDocumentException("Top index TI is greater than the maximum of option index options for field " + field.getQualifiedName() + ".");
                    }
                    plainTextString = AppearanceUtils.insertStyleAttribute(plainTextString, "background-color:rgb(153,193,218);;color:#000000", "background-color=\"rgb(153,193,218)\" color=\"rgb(0,0,0)\"", indexArray, idxOffset);
                }
            }
        }
        return plainTextString;
    }
}

