/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import java.util.HashSet;
import java.util.LinkedList;

public class InstructionQueue {
    private LinkedList queue = new LinkedList();

    public void enqueue(Instruction instruction) {
        this.queue.addLast(instruction);
    }

    public Instruction dequeue() {
        return (Instruction)this.queue.removeFirst();
    }

    public Instruction peekNextOut() {
        return (Instruction)this.queue.getFirst();
    }

    public Instruction peekLastIn() {
        return (Instruction)this.queue.getLast();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public void clear() {
        this.queue.clear();
    }

    public boolean contains(ASName operator2) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Instruction instr = iter.next();
            if (instr.getOperator() != operator2) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnly(HashSet operatorNameSet) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Instruction instr = iter.next();
            if (operatorNameSet.contains(instr.getOperator())) continue;
            return false;
        }
        return true;
    }

    public boolean containAny(HashSet operatorNameSet) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Instruction instr = iter.next();
            if (!operatorNameSet.contains(instr.getOperator())) continue;
            return true;
        }
        return false;
    }

    public boolean beginsWith(ASName[] operators) {
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Instruction instr = iter.next();
            if (instr.getOperator() != operators[i++]) {
                return false;
            }
            if (i != operators.length) continue;
            break;
        }
        return true;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public boolean hasMarkedContentWrapper() {
        Instruction startInstr = this.peekNextOut();
        Instruction endInstr = this.peekLastIn();
        ASName startOp = startInstr.getOperator();
        ASName endOp = endInstr.getOperator();
        return (startOp == ASName.k_BMC || startOp == ASName.k_BDC) && endOp == ASName.k_EMC;
    }

    public boolean removeMarkedContentWrapper() {
        if (this.hasMarkedContentWrapper()) {
            this.queue.removeFirst();
            this.queue.removeLast();
            return true;
        }
        return false;
    }

    public class Iterator {
        private java.util.Iterator queueIter;

        public Iterator() {
            this.queueIter = InstructionQueue.this.queue.iterator();
        }

        public boolean hasNext() {
            return this.queueIter.hasNext();
        }

        public Instruction next() {
            return (Instruction)this.queueIter.next();
        }

        public void remove() {
            this.queueIter.remove();
        }
    }
}

