/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.UnsupportedFontException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

class FontWidthStore
implements Serializable {
    private static final long serialVersionUID = 3376437248636466239L;
    private transient Font font;
    private HashMap<Integer, Double> widthMap;

    public FontWidthStore(Font font) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.font = font;
        this.widthMap = new HashMap();
        this.calculateWidthData();
    }

    public FontWidthStore(Font font, HashMap<Integer, Double> widthMap) {
        this.font = font;
        this.widthMap = widthMap;
    }

    private void calculateWidthData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        for (int charCode = 32; charCode <= 127; ++charCode) {
            PDFFontDescription desc = this.font.getPDFFontDescription();
            double width = desc.getAdvance(charCode);
            double unitesPerEmX = this.font.getUnitsPerEmX();
            if (unitesPerEmX != 0.0) {
                width = width * 1000.0 / unitesPerEmX;
            }
            this.widthMap.put(charCode, width);
        }
    }

    public Set<Integer> getUnicodes() {
        return this.widthMap.keySet();
    }

    double getWidth(int unicode) {
        Double width = this.widthMap.get(unicode);
        return width == null ? -1.0 : width;
    }
}

