/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;

class MarkedContentOperator
extends ContentOperator {
    static final int MP = 1;
    static final int DP = 2;
    static final int BMC = 3;
    static final int BDC = 4;
    static final int EMC = 5;

    MarkedContentOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                ASName tag = opStack.popName();
                opHandlers.MP(tag, instruction);
                break;
            }
            case 3: {
                ASName tag = opStack.popName();
                opHandlers.BMC(tag, instruction);
                break;
            }
            case 2: {
                if (opStack.peekTypeIsDictionary()) {
                    ASDictionary properties = opStack.popDictionary();
                    ASName tag = opStack.popName();
                    opHandlers.DP(tag, properties, instruction);
                    break;
                }
                ASName name = opStack.popName();
                ASName tag = opStack.popName();
                opHandlers.DP(tag, name, instruction);
                break;
            }
            case 4: {
                if (opStack.peekTypeIsDictionary()) {
                    ASDictionary properties = opStack.popDictionary();
                    ASName tag = opStack.popName();
                    opHandlers.BDC(tag, properties, instruction);
                    break;
                }
                ASName name = opStack.popName();
                ASName tag = opStack.popName();
                opHandlers.BDC(tag, name, instruction);
                break;
            }
            case 5: {
                opHandlers.EMC(instruction);
            }
        }
    }
}

