/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class TextObjectList {
    private boolean ignoreErrors;
    private ArrayList<TextObject> textObjects = new ArrayList();

    public TextObjectList(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public TextObjectList(TextObjectList textObjects, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ignoreErrors = ignoreErrors;
        Iterator iter = textObjects.iterator();
        while (iter.hasNext()) {
            this.textObjects.add(new TextObject((TextObject)iter.next(), ignoreErrors));
        }
    }

    public void add(TextObject textObject) {
        this.textObjects.add(textObject);
    }

    public Iterator iterator() {
        return new TextObjectListIterator();
    }

    public ListIterator listIterator() {
        return new TextObjectListIterator();
    }

    public String toString() {
        return this.textObjects.toString();
    }

    public class TextObjectListIterator
    implements ListIterator {
        private ListIterator iterator;

        TextObjectListIterator() {
            this.iterator = TextObjectList.this.textObjects.listIterator();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object previous() {
            return this.iterator.previous();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

