/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.contentmodify.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.IContentStreamReader;
import java.io.IOException;

public class ContentStreamReader
extends ContentStreamProcessor
implements IContentStreamReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(ContentReader reader) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        while (reader.hasNext()) {
            Instruction instruction = null;
            try {
                instruction = reader.next();
                ContentOperator co = (ContentOperator)operators.get(instruction.getOperator());
                if (co == null) continue;
                try {
                    co.process(instruction, this.operatorHandler);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException(e);
                }
            }
            finally {
                try {
                    if (instruction == null) continue;
                    instruction.close();
                }
                catch (PDFIOException pDFIOException) {}
            }
        }
    }

    @Override
    public void setContentStreamHandler(IOperatorHandler operatorHandler) {
        this.operatorHandler = operatorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ContentReader reader = null;
        try {
            reader = ContentReader.newInstance(content);
            this.process(reader);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void process(ContentReader reader) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.parse(reader);
        }
        catch (PDFFontException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }
}

