/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFBuildData;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFAppBuildData
extends PDFBuildData {
    private PDFAppBuildData(CosDictionary cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFAppBuildData getInstance(CosDictionary cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAppBuildData pdfObject = (PDFAppBuildData)PDFCosObject.getCachedInstance(cosObject, PDFAppBuildData.class);
        if (pdfObject == null) {
            pdfObject = new PDFAppBuildData(cosObject);
        }
        return pdfObject;
    }

    public static PDFAppBuildData newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFAppBuildData pdfObject = new PDFAppBuildData(cosObject);
        return pdfObject;
    }

    public String getREx() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_REx);
    }

    public void setREx(String acrobatVersion) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_REx, acrobatVersion);
    }
}

