/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFVRIMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStreamList;

public class PDFDocumentSecurityStore
extends PDFCosDictionary {
    public static final ASName k_Certs = ASName.create("Certs");
    public static final ASName k_CRLs = ASName.create("CRLs");
    public static final ASName k_OCSPs = ASName.create("OCSPs");
    public static final ASName k_VRI = ASName.create("VRI");
    public static final ASName k_DSS = ASName.create("DSS");

    protected PDFDocumentSecurityStore(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFDocumentSecurityStore getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFDocumentSecurityStore pdfObject = (PDFDocumentSecurityStore)PDFCosObject.getCachedInstance(cosObject, PDFDocumentSecurityStore.class);
        if (pdfObject == null) {
            pdfObject = new PDFDocumentSecurityStore(cosObject);
        }
        return pdfObject;
    }

    public static PDFDocumentSecurityStore newInstance(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(doc);
        PDFDocumentSecurityStore pdfObject = new PDFDocumentSecurityStore(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_DSS);
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public PDFVRIMap getPDFVRIMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFVRIMap.getInstance(this.getDictionaryDictionaryValue(k_VRI));
    }

    public void setPDFVRIMap(PDFVRIMap vri) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_VRI, vri);
    }

    public PDFStreamList getCerts() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStreamList.getInstance(this.getDictionaryArrayValue(k_Certs));
    }

    public void setCerts(PDFStreamList certs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (certs == null) {
            this.removeValue(k_Certs);
        } else {
            this.setDictionaryArrayValue(k_Certs, certs.getCosArray());
        }
    }

    public PDFStreamList getOCSPs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStreamList.getInstance(this.getDictionaryArrayValue(k_OCSPs));
    }

    public void setOCSPs(PDFStreamList ocsps) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (ocsps == null) {
            this.removeValue(k_OCSPs);
        } else {
            this.setDictionaryArrayValue(k_OCSPs, ocsps.getCosArray());
        }
    }

    public PDFStreamList getCRLs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStreamList.getInstance(this.getDictionaryArrayValue(k_CRLs));
    }

    public void setCRLs(PDFStreamList crls) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (crls == null) {
            this.removeValue(k_CRLs);
        } else {
            this.setDictionaryArrayValue(k_CRLs, crls.getCosArray());
        }
    }
}

