/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureFilter;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFDocumentTimeStampSignature
extends PDFSignature {
    protected PDFDocumentTimeStampSignature(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFDocumentTimeStampSignature getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFDocumentTimeStampSignature pdfObject = (PDFDocumentTimeStampSignature)PDFCosObject.getCachedInstance(cosObject, PDFDocumentTimeStampSignature.class);
        if (pdfObject == null) {
            pdfObject = new PDFDocumentTimeStampSignature(cosObject);
        }
        return pdfObject;
    }

    public static PDFDocumentTimeStampSignature newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDocumentTimeStampSignature.newInstance(pdfDocument, PDFSignatureFilter.AdobePPKLite);
    }

    public static PDFDocumentTimeStampSignature newInstance(PDFDocument pdfDocument, PDFSignatureFilter filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (filter == null) {
            filter = PDFSignatureFilter.AdobePPKLite;
        }
        return PDFDocumentTimeStampSignature.newInstance(pdfDocument, ASName.create(filter.getValue()));
    }

    static PDFDocumentTimeStampSignature newInstance(PDFDocument pdfDocument, ASName filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFDocumentTimeStampSignature pdfObject = new PDFDocumentTimeStampSignature(cosObject);
        pdfObject.setType(ASName.k_DocTimeStamp);
        pdfObject.setFilterName(filter);
        pdfObject.setSubFilterName(PDFSignature.k_ETSI_RFC3161);
        return pdfObject;
    }

    @Override
    public byte[][] getCertificates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public void setCertificate(byte[] cert) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new UnsupportedOperationException("Cert can not be set for a Document TimeStamp Signature");
    }

    @Override
    public void setCertificates(byte[][] certs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new UnsupportedOperationException("Cert can not be set for a Document TimeStamp Signature");
    }

    @Override
    public PDFSignatureReferenceList getSignatureReferences() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public void setReferences(PDFSignatureReferenceList sigRefList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new UnsupportedOperationException("Reference can not be set for a Document TimeStamp Signature");
    }

    @Override
    public void setChanges(long[] changes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new UnsupportedOperationException("Changes can not be set for a Document TimeStamp Signature");
    }

    @Override
    public long[] getChanges() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public long getAuthenticationTime() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return 0L;
    }

    @Override
    public void setAuthenticationTime(Long sec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new UnsupportedOperationException("Prop_AuthTime can not be set for a Document TimeStamp Signature");
    }

    @Override
    public ASName getAuthenticationType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public void setAuthenticationType(ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new UnsupportedOperationException("Prop_AuthType can not be set for a Document TimeStamp Signature");
    }
}

