/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersUR;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURAnnots;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURDocument;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURForm;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFUsageRight;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;

public class PDFTransformParametersUB1
extends PDFTransformParametersUR {
    private static final ASName k_TimeOfUbiquitization = ASName.create("TimeOfUbiquitization");

    private PDFTransformParametersUB1(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFTransformParametersUB1 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTransformParametersUB1 pdfObject = (PDFTransformParametersUB1)PDFCosObject.getCachedInstance(cosObject, PDFTransformParametersUB1.class);
        if (pdfObject == null) {
            pdfObject = new PDFTransformParametersUB1(cosObject);
        }
        return pdfObject;
    }

    public String getTimeOfUbiquitization() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(k_TimeOfUbiquitization)) {
            return this.getDictionaryTextStringValue(k_TimeOfUbiquitization);
        }
        return "";
    }

    @Override
    public String getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValueAsString(ASName.k_V);
    }

    public String[] getRightsID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.create("RightsID"));
        if (cosArray == null || cosArray.size() == 0) {
            return null;
        }
        String[] rightsID = new String[cosArray.size()];
        int addAtPos = 0;
        for (int pos = 0; pos < cosArray.size(); ++pos) {
            ASString asString;
            if (cosArray.getType(pos) != 4 || (asString = cosArray.getString(pos)) == null) continue;
            rightsID[addAtPos++] = asString.asString();
        }
        return rightsID;
    }

    @Override
    public void setDocumentUsageRights(PDFURDocument[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new PDFUnsupportedFeatureException("Cannot set any UB1 rights");
    }

    @Override
    public void setAnnotationUsageRights(PDFURAnnots[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new PDFUnsupportedFeatureException("Cannot set any UB1 rights");
    }

    @Override
    public void setFormUsageRights(PDFURForm[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new PDFUnsupportedFeatureException("Cannot set any UB1 rights");
    }

    @Override
    void setFormExUsageRights(PDFURForm[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new PDFUnsupportedFeatureException("Cannot set any UB1 rights");
    }

    @Override
    public void setSignatureUsageRights(PDFURSignature[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new PDFUnsupportedFeatureException("Cannot set any UB1 rights");
    }

    @Override
    public void setEFUsageRights(PDFUsageRight[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new PDFUnsupportedFeatureException("Cannot set any UB1 rights");
    }

    @Override
    public void setMessage(String msg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new PDFUnsupportedFeatureException("Cannot set any UB1 rights");
    }

    @Override
    public void setRestrictPermissions(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new PDFUnsupportedFeatureException("Cannot set any UB1 rights");
    }

    @Override
    public void setVersion(String version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        throw new PDFUnsupportedFeatureException("Cannot set any UB1 rights");
    }
}

