/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFValidationRelatedInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFVRIMap
extends PDFCosDictionary {
    protected PDFVRIMap(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    protected static PDFVRIMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFVRIMap pdfObject = (PDFVRIMap)PDFCosObject.getCachedInstance(cosObject, PDFVRIMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFVRIMap(cosObject);
        }
        return pdfObject;
    }

    public static PDFVRIMap newInstance(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(doc);
        return new PDFVRIMap(cosObject);
    }

    public PDFValidationRelatedInfo getPDFVRI(byte[] digest) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName digestName = ByteOps.getHexName(digest, true);
        return this.getPDFVRI(digestName);
    }

    public PDFValidationRelatedInfo getPDFVRI(ASName digest) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFValidationRelatedInfo.getInstance(this.getDictionaryDictionaryValue(digest));
    }

    public void setPDFVRI(byte[] digest, PDFValidationRelatedInfo vri) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName digestName = ByteOps.getHexName(digest, true);
        this.setPDFVRI(digestName, vri);
    }

    public void setPDFVRI(ASName digest, PDFValidationRelatedInfo vri) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(digest, vri);
    }
}

