/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class PDFCosStream
extends PDFCosDictionary {
    public static final long STREAM_COMPRESSION_THRESHOLD = 15L;

    protected PDFCosStream(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
        if (!(cosObject instanceof CosStream)) {
            this.removeFromCache(cosObject);
            throw new PDFInvalidDocumentException("CosStream expected, found" + cosObject.getClass() + ". Object number of invalid cosObject:" + cosObject.getObjNum());
        }
    }

    public long getLength() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject length = this.getCosStream().get(ASName.k_Length);
        if (length instanceof CosNumeric) {
            return length.intValue();
        }
        return 0L;
    }

    public ASName getType() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject type = this.getCosStream().get(ASName.k_Type);
        if (type instanceof CosName) {
            return type.nameValue();
        }
        return null;
    }

    protected void setType(ASName type) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosName nameObj = this.getCosStream().getDocument().createCosName(type);
        this.getCosStream().put(ASName.k_Type, nameObj);
    }

    public ASName getSubtype() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject type = this.getCosStream().get(ASName.k_Subtype);
        if (type instanceof CosName) {
            return type.nameValue();
        }
        return null;
    }

    protected void setSubtype(ASName subtype) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        CosName nameObj = this.getCosStream().getDocument().createCosName(subtype);
        this.getCosStream().put(ASName.k_Subtype, nameObj);
    }

    public boolean hasInputFilters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosStream().getInputFiltersList() != null;
    }

    public PDFFilterList getInputFilters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFilterList.getInstance(this.getCosStream().getInputFiltersList());
    }

    public boolean hasOutputFilters() {
        return this.getCosStream().getOutputFiltersList() != null;
    }

    public PDFFilterList getOutputFilters() throws PDFInvalidDocumentException {
        return PDFFilterList.getInstance(this.getCosStream().getOutputFiltersList());
    }

    public PDFFilterList procureOutputFilters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFilterList filterList = this.getOutputFilters();
        if (filterList == null) {
            filterList = this.getInputFilters();
        }
        if (filterList == null) {
            filterList = PDFFilterList.newInstance(this.getPDFDocument());
        }
        return filterList;
    }

    public void setOutputFilters(PDFFilterList outputFilters) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.getCosStream().setOutputFiltersList(outputFilters.getCosArray());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public void setOutputFilter(ASName filterName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFilterList outputFilters = this.procureOutputFilters();
        outputFilters.clear();
        PDFFilter filter = PDFFilter.newInstance(this.getPDFDocument(), filterName, null);
        outputFilters.add(filter);
        this.setOutputFilters(outputFilters);
    }

    public void removeOutputFilters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasOutputFilters() || this.hasInputFilters()) {
            try {
                this.getCosStream().setOutputFiltersList(PDFCosStream.newCosArray(this.getPDFDocument()));
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    public boolean getStreamData(OutputStream outStm) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.getCosStream().copyStream(outStm, false);
    }

    public void getStreamData(ByteWriter outStm) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            OutputByteStream outputByteStream = this.getStreamManager().getOutputByteStream(outStm);
            this.getCosStream().copyStream(outputByteStream, false);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public void setStreamData(InputStream inStm) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.setStreamData(inStm, false);
    }

    public void setStreamData(InputStream inStm, boolean encoded) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            OutputByteStream obs = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            IO.copy(inStm, obs);
            InputByteStream ibs = obs.closeAndConvert();
            obs = null;
            if (encoded) {
                this.getCosStream().newDataEncoded(ibs);
            } else {
                this.getCosStream().newDataDecoded(ibs);
            }
            ibs = null;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public void setStreamData(ByteReader inStm) throws PDFIOException, PDFCosParseException, PDFSecurityException {
        this.setStreamData(inStm, false);
    }

    public void setStreamData(ByteReader inStm, boolean encoded) throws PDFIOException, PDFCosParseException, PDFSecurityException {
        try {
            InputByteStream byteStream = this.getStreamManager().getInputByteStream(inStm);
            if (encoded) {
                this.getCosStream().newDataEncoded(byteStream);
            } else {
                this.getCosStream().newDataDecoded(byteStream);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public static void setStreamLength(CosStream stream, int length) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        stream.put(ASName.k_Length, length);
    }

    public static void setStreamFilter(CosStream stream, PDFDocument pdfDoc, ArrayList<String> filters) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<CosName> nameList = new ArrayList<CosName>(filters.size());
        Iterator<String> fNdx = filters.iterator();
        while (fNdx.hasNext()) {
            ASName filterName = ASName.create(fNdx.next());
            nameList.add(PDFCosObject.newCosName(pdfDoc, filterName));
        }
        stream.put(ASName.k_Filter, PDFCosObject.newCosArray(pdfDoc, nameList));
    }

    public static void setStreamFilter(CosStream stream, String filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        stream.put(ASName.k_Filter, ASName.create(filter));
    }
}

