/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFMetaDataInfo;

public class PDFDocumentInfo
extends PDFMetaDataInfo {
    private PDFDocumentInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFDocumentInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFDocumentInfo pdfObject = (PDFDocumentInfo)PDFCosObject.getCachedInstance(cosObject, PDFDocumentInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFDocumentInfo(cosObject);
        }
        return pdfObject;
    }

    public static PDFDocumentInfo newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFDocumentInfo pdfObject = new PDFDocumentInfo(cosObject);
        return pdfObject;
    }
}

