/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFileInfo;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import java.io.OutputStream;

public class PDFEmbeddedFile
extends PDFCosStream {
    private PDFEmbeddedFile(CosObject cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosStream);
    }

    public static PDFEmbeddedFile getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFEmbeddedFile pdfObject = (PDFEmbeddedFile)PDFCosObject.getCachedInstance(cosObject, PDFEmbeddedFile.class);
        if (pdfObject == null) {
            pdfObject = new PDFEmbeddedFile(cosObject);
        }
        return pdfObject;
    }

    public static PDFEmbeddedFile newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream cosObject = PDFCosObject.newCosStream(pdfDocument);
        PDFEmbeddedFile pdfObject = new PDFEmbeddedFile(cosObject);
        pdfObject.setAttrs(null, false);
        return pdfObject;
    }

    public static PDFEmbeddedFile newInstance(PDFDocument pdfDocument, PDFEmbeddedFileInfo info, ByteReader data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEmbeddedFile pdfObject = PDFEmbeddedFile.newInstance(pdfDocument);
        if (data != null) {
            pdfObject.setStreamData(data);
        }
        if (info != null) {
            pdfObject.setFileInfo(info);
        }
        return pdfObject;
    }

    private void setAttrs(PDFEmbeddedFileInfo info, boolean compress) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.setType(ASName.create("EmbeddedFile"));
        if (info != null) {
            this.setParams(info);
        }
        if (compress) {
            PDFFilterFlate filter = PDFFilterFlate.newInstance(this.getPDFDocument(), null);
            PDFFilterList filterList = PDFFilterList.newInstance(this.getPDFDocument());
            filterList.add(filter);
            this.setOutputFilters(filterList);
        }
    }

    private void setParams(PDFCosObject params) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (params != null) {
            super.setDictionaryValue(ASName.k_Params, params);
        }
    }

    public void getFileData(OutputStream dest) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.getStreamData(dest);
    }

    public void getFileData(ByteWriter dest) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.getStreamData(dest);
    }

    public boolean hasFileInfo() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return this.containsKey(ASName.k_Params);
    }

    public PDFEmbeddedFileInfo getFileInfo() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return PDFEmbeddedFileInfo.getInstance(this.getDictionaryCosObjectValue(ASName.k_Params));
    }

    public PDFEmbeddedFileInfo procureFileInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasFileInfo()) {
            return this.getFileInfo();
        }
        PDFEmbeddedFileInfo fileInfo = PDFEmbeddedFileInfo.getInstance(PDFCosObject.newCosDictionary(this.getPDFDocument()));
        this.setFileInfo(fileInfo);
        return fileInfo;
    }

    public void setFileInfo(PDFEmbeddedFileInfo fileInfo) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.setParams(fileInfo);
    }

    public boolean hasMIMEType() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.getSubtype() != null;
    }

    public String getMIMEType() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASName mimeType = this.getSubtype();
        return mimeType != null ? mimeType.asString(true) : null;
    }

    public void setMIMEType(ASName type) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        this.setSubtype(type);
    }

    public CosStream getFileStream() {
        return this.getCosStream();
    }

    public void setFilter(PDFFilter filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFilterList filterList = this.procureOutputFilters();
        filterList.add(filter);
        this.setOutputFilters(filterList);
    }
}

