/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFMacSpecificFileInfo;

public class PDFEmbeddedFileInfo
extends PDFCosDictionary {
    private PDFEmbeddedFileInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFEmbeddedFileInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFEmbeddedFileInfo pdfObject = (PDFEmbeddedFileInfo)PDFCosObject.getCachedInstance(cosObject, PDFEmbeddedFileInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFEmbeddedFileInfo(cosObject);
        }
        return pdfObject;
    }

    public static PDFEmbeddedFileInfo newInstance(PDFDocument pdfDocument, int size, ASDate creationDate, ASDate modificationDate) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFEmbeddedFileInfo pdfObject = new PDFEmbeddedFileInfo(cosObject);
        pdfObject.setSize(size);
        if (creationDate != null) {
            pdfObject.setCreationDate(creationDate);
        }
        if (modificationDate != null) {
            pdfObject.setModificationDate(modificationDate);
        }
        return pdfObject;
    }

    public boolean hasModificationDate() {
        return this.getCosDictionary().containsKey(ASName.k_ModDate);
    }

    public ASDate getModificationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasModificationDate() ? this.getDictionaryDateValue(ASName.k_ModDate) : null;
    }

    public void setModificationDate(ASDate date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDateValue(ASName.k_ModDate, date);
    }

    public boolean hasCreationDate() {
        return this.getCosDictionary().containsKey(ASName.k_CreationDate);
    }

    public ASDate getCreationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasCreationDate() ? this.getDictionaryDateValue(ASName.k_CreationDate) : null;
    }

    public void setCreationDate(ASDate date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDateValue(ASName.k_CreationDate, date);
    }

    public boolean hasChecksum() {
        return this.getCosDictionary().containsKey(ASName.k_CheckSum);
    }

    public ASString getCheckSum() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasChecksum() ? this.getCosDictionary().getString(ASName.k_CheckSum) : null;
    }

    public void setCheckSum(byte[] chk) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryASStringValue(ASName.k_CheckSum, new ASString(chk));
    }

    public boolean hasSize() {
        return this.getCosDictionary().containsKey(ASName.k_Size);
    }

    public int getSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getInt(ASName.k_Size);
    }

    public void setSize(String size) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Size, size);
    }

    public void setSize(int size) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Size, size);
    }

    public PDFMacSpecificFileInfo getMac() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMacSpecificFileInfo.getInstance(this.getDictionaryCosObjectValue(ASName.k_Mac));
    }

    public void setMac(PDFMacSpecificFileInfo value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Mac, value);
    }

    public boolean hasMac() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Mac);
    }
}

