/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import java.util.HashMap;
import java.util.Map;

public class PDFExtension
extends PDFCosDictionary {
    private PDFExtension(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFExtension getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFExtension pdfObject = (PDFExtension)PDFCosObject.getCachedInstance(cosObject, PDFExtension.class);
        if (pdfObject == null) {
            pdfObject = new PDFExtension(cosObject);
        }
        return pdfObject;
    }

    public static PDFExtension newInstance(PDFDocument pdfDocument, PDFVersion baseVersion, int extensionLevel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (baseVersion == null || baseVersion.getVersionValue() == null) {
            throw new PDFInvalidDocumentException("Base version can't be null. It's a required entry");
        }
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFExtension pdfObject = new PDFExtension(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_BaseVersion, baseVersion.getVersionValue());
        pdfObject.setDictionaryIntValue(ASName.k_ExtensionLevel, extensionLevel);
        return pdfObject;
    }

    public void setBaseVerssion(PDFVersion version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryDoubleValue(ASName.k_BaseVersion, version.asString());
    }

    public void setExtensionLevel(int extensionLevel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_ExtensionLevel, extensionLevel);
    }

    private String getBaseVersionAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValueAsString(ASName.k_BaseVersion);
    }

    public PDFVersion getBaseVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String sVersion = this.getBaseVersionAsString();
        PDFVersion pdfVersion = PDFVersion.getSupportedInstance(sVersion);
        if (pdfVersion != null) {
            return pdfVersion;
        }
        return PDFVersion.getInstance(sVersion);
    }

    public int getExtensionLevel() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_ExtensionLevel);
    }

    protected static PDFExtension newInstance(PDFDocument document, Map extension) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String baseVersionString = (String)extension.get(ASName.k_BaseVersion);
        if (baseVersionString != null) {
            PDFVersion baseVersion = PDFVersion.getInstance(baseVersionString);
            Integer extensionLevelInt = (Integer)extension.get(ASName.k_ExtensionLevel);
            if (extensionLevelInt != null) {
                return PDFExtension.newInstance(document, baseVersion, extensionLevelInt);
            }
        }
        return null;
    }

    public static Map asMap(PDFVersion baseVersion, int extensionLevel) {
        HashMap<ASName, Object> extension = new HashMap<ASName, Object>();
        extension.put(ASName.k_BaseVersion, baseVersion.asString());
        extension.put(ASName.k_ExtensionLevel, extensionLevel);
        return extension;
    }

    protected Map asMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashMap<ASName, Object> extension = new HashMap<ASName, Object>();
        extension.put(ASName.k_BaseVersion, this.getBaseVersionAsString());
        extension.put(ASName.k_ExtensionLevel, this.getExtensionLevel());
        return extension;
    }
}

