/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.permissionhandlers.ADBEUIPermissionHandler;

public class PDFPermissions
extends PDFCosDictionary {
    protected PDFPermissions(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPermissions getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPermissions pdfObject = (PDFPermissions)PDFCosObject.getCachedInstance(cosObject, PDFPermissions.class);
        if (pdfObject == null) {
            pdfObject = new PDFPermissions(cosObject);
        }
        return pdfObject;
    }

    public static PDFPermissions newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFPermissions pdfObject = new PDFPermissions(cosObject);
        return pdfObject;
    }

    public PDFSignature getDocMDP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignature.getInstance(this.getDictionaryCosObjectValue(PDFSignature.k_DocMDP));
    }

    public void setDocMDP(PDFSignature docMDP) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(PDFSignature.k_DocMDP, docMDP);
    }

    public PDFSignature getUR() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignature.getInstance(this.getDictionaryCosObjectValue(PDFSignature.k_UR));
    }

    public void setUR(PDFSignature ur) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(PDFSignature.k_UR, ur);
    }

    public PDFSignature getUR3() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignature.getInstance(this.getDictionaryCosObjectValue(PDFSignature.k_UR3));
    }

    public void setUR3(PDFSignature ur3) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(PDFSignature.k_UR3, ur3);
    }

    public ADBEUIPermissionHandler getADBEUIPermHandler() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ADBEUIPermissionHandler.getInstance(this.getDictionaryCosObjectValue(ADBEUIPermissionHandler.k_ADBEUIPerms));
    }

    public void setADBEUIPermHandler(ADBEUIPermissionHandler adbeUiPermHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ADBEUIPermissionHandler.k_ADBEUIPerms, adbeUiPermHandler);
    }
}

