/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document.listener;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class DocumentListenerRegistryBase
implements DocumentListenerRegistry {
    private final Map<Object, ListenerEntry> listeners = new IdentityHashMap<Object, ListenerEntry>();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    protected PDFDocument pdfDocument;
    private boolean messageUnderway = false;

    public DocumentListenerRegistryBase(PDFDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFUnableToCompleteOperationException[] sendMessage(DocumentMessage message, boolean batchFailure) throws PDFUnableToCompleteOperationException {
        try {
            PDFUnableToCompleteOperationException[] pDFUnableToCompleteOperationExceptionArray;
            this.messageUnderway = true;
            ArrayList<PDFUnableToCompleteOperationException> exceptions = null;
            if (batchFailure) {
                exceptions = new ArrayList<PDFUnableToCompleteOperationException>();
            }
            message.setListenersDirty(this.isAnyListenerDirty());
            this.cleanValues();
            Iterator<Object> iter = this.internalGetListenerIterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                ListenerEntry listenerEntry = this.listeners.get(key);
                DocumentListener listener = listenerEntry.getListener();
                if (listener == null) continue;
                try {
                    listener.message(message);
                }
                catch (PDFUnableToCompleteOperationException e) {
                    if (batchFailure) {
                        exceptions.add(e);
                        continue;
                    }
                    throw e;
                }
            }
            this.cleanValues();
            if (exceptions != null && !exceptions.isEmpty()) {
                pDFUnableToCompleteOperationExceptionArray = exceptions.toArray(new PDFUnableToCompleteOperationException[exceptions.size()]);
                return pDFUnableToCompleteOperationExceptionArray;
            }
            pDFUnableToCompleteOperationExceptionArray = null;
            return pDFUnableToCompleteOperationExceptionArray;
        }
        finally {
            this.messageUnderway = false;
        }
    }

    @Override
    public boolean registerListener(Object listenerKey, DocumentListener listener) {
        if (this.messageUnderway) {
            return false;
        }
        this.cleanValues();
        ListenerEntry entry = this.listeners.get(listenerKey);
        if (entry != null) {
            return false;
        }
        entry = new ListenerEntry(false, this.queue, listenerKey, listener);
        this.listeners.put(listenerKey, entry);
        this.notifyListenerAdded(listenerKey, entry);
        return true;
    }

    @Override
    public boolean deregisterListener(Object listenerKey) {
        this.cleanValues();
        return this.removeListener(listenerKey);
    }

    private boolean removeListener(Object listenerKey) {
        ListenerEntry entry = this.listeners.remove(listenerKey);
        if (entry == null) {
            return false;
        }
        this.notifyListenerRemoved(listenerKey, entry);
        return true;
    }

    @Override
    public DocumentListener getListener(Object listenerKey) {
        this.cleanValues();
        ListenerEntry entry = this.listeners.get(listenerKey);
        if (entry == null) {
            return null;
        }
        DocumentListener listener = entry.getListener();
        if (listener == null) {
            this.cleanValues();
        }
        return listener;
    }

    @Override
    public boolean markDirty(Object listenerKey, boolean dirty) {
        this.cleanValues();
        ListenerEntry entry = this.listeners.get(listenerKey);
        if (entry == null) {
            return false;
        }
        boolean changed = entry.markDirty(dirty);
        if (dirty && entry.isSoft()) {
            entry.makeStrong();
            this.notifyListenerChanged(listenerKey, entry);
        } else if (!(dirty || entry.isSoft() || entry.isMarkedHoldStrongly())) {
            entry.makeSoft();
            this.notifyListenerChanged(listenerKey, entry);
        }
        this.cleanValues();
        return changed;
    }

    @Override
    public boolean isDirty(Object listenerKey) {
        ListenerEntry entry = this.listeners.get(listenerKey);
        if (entry == null) {
            return false;
        }
        boolean oldDirty = entry.isMarkedDirty();
        this.notifyListenerChanged(listenerKey, entry);
        return oldDirty;
    }

    @Override
    public boolean isAnyListenerDirty() {
        Iterator<Object> iter = this.listeners.keySet().iterator();
        while (iter.hasNext()) {
            if (!this.isDirty(iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean holdStrongly(Object listenerKey, boolean strongly) {
        this.cleanValues();
        ListenerEntry entry = this.listeners.get(listenerKey);
        if (entry == null) {
            return false;
        }
        boolean changed = entry.markHoldStrongly(strongly);
        if (strongly && entry.isSoft()) {
            entry.makeStrong();
            this.notifyListenerChanged(listenerKey, entry);
        } else if (!(strongly || entry.isSoft() || entry.isMarkedDirty())) {
            entry.makeSoft();
            this.notifyListenerChanged(listenerKey, entry);
        }
        this.cleanValues();
        return changed;
    }

    @Override
    public boolean isHeldStrongly(Object listenerKey) {
        ListenerEntry entry = this.listeners.get(listenerKey);
        if (entry == null) {
            return false;
        }
        return entry.isMarkedHoldStrongly();
    }

    public boolean isAnyListenerHeldStrongly() {
        Iterator<Object> iter = this.listeners.keySet().iterator();
        while (iter.hasNext()) {
            if (!this.isHeldStrongly(iter.next())) continue;
            return true;
        }
        return false;
    }

    protected abstract void notifyListenerAdded(Object var1, ListenerEntry var2);

    protected abstract void notifyListenerRemoved(Object var1, ListenerEntry var2);

    protected abstract void notifyListenerChanged(Object var1, ListenerEntry var2);

    protected abstract Iterator<Object> getListenerIterator();

    private Iterator<Object> internalGetListenerIterator() {
        Iterator<Object> iter = this.getListenerIterator();
        if (iter != null) {
            return iter;
        }
        return this.listeners.keySet().iterator();
    }

    private void cleanValues() {
        Reference<Object> obj;
        while ((obj = this.queue.poll()) != null) {
            SoftListener softListener = (SoftListener)obj;
            this.removeListener(softListener.getKey());
        }
    }

    protected static final class ListenerEntry {
        private boolean dirty;
        private boolean holdStrongly;
        private Object extraData;
        private boolean soft;
        private final Object key;
        private Object value;
        private final ReferenceQueue<Object> queue;

        ListenerEntry(boolean weak, ReferenceQueue<Object> queue, Object key, DocumentListener listener) {
            this.soft = weak;
            this.key = key;
            this.queue = queue;
            this.value = this.soft ? new SoftListener(this.queue, this.key, listener) : listener;
        }

        DocumentListener getListener() {
            if (this.soft) {
                return (DocumentListener)((SoftListener)this.value).get();
            }
            return (DocumentListener)this.value;
        }

        void makeSoft() {
            if (this.soft) {
                return;
            }
            this.value = new SoftListener(this.queue, this.key, this.value);
            this.soft = true;
        }

        void makeStrong() {
            if (!this.soft) {
                return;
            }
            SoftListener softListener = (SoftListener)this.value;
            Object value = softListener.get();
            softListener.clear();
            softListener.enqueue();
            this.value = value;
            this.soft = false;
        }

        boolean isSoft() {
            return this.soft;
        }

        boolean markDirty(boolean dirty) {
            boolean wasDirty = this.dirty;
            this.dirty = dirty;
            return wasDirty;
        }

        boolean isMarkedDirty() {
            return this.dirty;
        }

        boolean markHoldStrongly(boolean strongly) {
            boolean wasStrongly = this.holdStrongly;
            this.holdStrongly = strongly;
            return wasStrongly;
        }

        boolean isMarkedHoldStrongly() {
            return this.holdStrongly;
        }

        Object getExtraData() {
            return this.extraData;
        }

        void setExtraData(Object extraData) {
            this.extraData = extraData;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ListenerEntry)) {
                return false;
            }
            ListenerEntry otherEntry = (ListenerEntry)obj;
            return this.getListener().equals(otherEntry.getListener());
        }

        public int hashCode() {
            return this.getListener().hashCode();
        }
    }

    private static final class SoftListener
    extends SoftReference<Object> {
        private Object key;

        SoftListener(ReferenceQueue<Object> queue, Object key, Object value) {
            super(value, queue);
            this.key = key;
        }

        Object getKey() {
            return this.key;
        }

        @Override
        public void clear() {
            this.key = null;
            super.clear();
        }
    }
}

