/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.filters;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterCrypt;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterParams;

public class PDFFilterList
extends PDFCosArrayList<PDFFilter> {
    private PDFFilterList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFilterList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFilterList pdfObject = (PDFFilterList)PDFCosObject.getCachedInstance(cosObject, PDFFilterList.class);
        if (pdfObject == null) {
            pdfObject = new PDFFilterList(cosObject);
        }
        return pdfObject;
    }

    public static PDFFilterList newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray cosArray = pdfDocument.getCosDocument().createCosArray();
        return new PDFFilterList(cosArray);
    }

    @Override
    protected PDFFilter itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFFilter.getInstance(cosObject);
    }

    public PDFFilter get(String name) throws PDFInvalidDocumentException {
        int index = this.indexOf(name);
        if (index >= 0) {
            return (PDFFilter)super.get(index);
        }
        return null;
    }

    public boolean hasNamedCryptFilter(PDFFilterCrypt filter) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFFilter cryptFilter = this.get("Crypt");
        if (cryptFilter != null && cryptFilter instanceof PDFFilterCrypt) {
            String name = ((PDFFilterCrypt)cryptFilter).getCryptName();
            return name.equals(filter.getCryptName());
        }
        return false;
    }

    @Override
    public void add(int index, PDFFilter filter) {
        if (filter == null || this.filterAlreadyInList(filter)) {
            return;
        }
        super.add(index, filter);
    }

    public int indexOf(PDFFilter filter) {
        if (filter == null) {
            return -1;
        }
        PDFFilter filterAtIndex = null;
        PDFFilterParams params = filter.getParams();
        for (int i = 0; i < this.size(); ++i) {
            filterAtIndex = (PDFFilter)this.get(i);
            if (filter.getFilterName() != filterAtIndex.getFilterName()) continue;
            if (params == null && filterAtIndex.getParams() == null) {
                return i;
            }
            if (params == null || filterAtIndex.getParams() == null || params.getCosObject() != filterAtIndex.getParams().getCosObject()) continue;
            return i;
        }
        return -1;
    }

    public boolean filterAlreadyInList(PDFFilter filter) {
        PDFFilterParams params = filter.getParams();
        for (int i = 0; i < this.size(); ++i) {
            PDFFilter filterAtIndex = (PDFFilter)this.get(i);
            if (filter.getFilterName() != filterAtIndex.getFilterName()) continue;
            if (params == null && filterAtIndex.getParams() == null) {
                return true;
            }
            if (params == null || filterAtIndex.getParams() == null || !params.equals(filterAtIndex.getParams())) continue;
            return true;
        }
        return false;
    }

    public int indexOf(String name) {
        if (name == null) {
            return -1;
        }
        ASName toFind = ASName.create(name);
        for (int i = 0; i < this.size(); ++i) {
            if (((PDFFilter)super.get(i)).getFilterName() != toFind) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(PDFFilter filter) {
        if (filter == null) {
            return -1;
        }
        PDFFilter filterAtIndex = null;
        PDFFilterParams params = filter.getParams();
        for (int i = this.size() - 1; i >= 0; --i) {
            filterAtIndex = (PDFFilter)super.get(i);
            if (filter.getFilterName() != filterAtIndex.getFilterName()) continue;
            if (params == null && filterAtIndex.getParams() == null) {
                return i;
            }
            if (params == null || filterAtIndex.getParams() == null || params.getCosObject() != filterAtIndex.getParams().getCosObject()) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(ASName name) {
        if (name == null) {
            return -1;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!((PDFFilter)super.get(i)).getFilterName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(String name) {
        if (name == null) {
            return -1;
        }
        return this.lastIndexOf(ASName.create(name));
    }

    @Override
    public boolean add(PDFFilter filter) {
        if (filter == null || this.filterAlreadyInList(filter)) {
            return false;
        }
        super.add(filter);
        return true;
    }

    public boolean contains(PDFFilter filter) {
        return this.indexOf(filter) >= 0;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public boolean remove(PDFFilter filter) throws PDFInvalidDocumentException {
        int index = this.indexOf(filter);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public boolean remove(String name) throws PDFInvalidDocumentException {
        int index = this.indexOf(name);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public PDFFilter[] toArray() {
        PDFFilter[] filters = new PDFFilter[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            filters[i] = (PDFFilter)this.get(i);
        }
        return filters;
    }
}

