/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;

public class PDFExtGStateMap
extends PDFCosDictionaryMap<PDFExtGState> {
    private PDFExtGStateMap(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFExtGStateMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFExtGStateMap pdfObject = (PDFExtGStateMap)PDFCosObject.getCachedInstance(cosObject, PDFExtGStateMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFExtGStateMap(cosObject);
        }
        return pdfObject;
    }

    public static PDFExtGStateMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFExtGStateMap(PDFCosObject.newCosDictionary(pdfDocument));
    }

    @Override
    protected PDFExtGState itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        return PDFExtGState.getInstance(cosObject);
    }

    public void set(ASName name, PDFExtGState pdfExtGState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(name, pdfExtGState);
    }
}

