/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.color.Function;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDomain;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRange;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.FunctionCacheImpl;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFFunctionIdentity;

public abstract class PDFFunction
extends PDFCosDictionary
implements Function {
    public static final int FUNCTION_TYPE0 = 0;
    public static final int FUNCTION_TYPE2 = 2;
    public static final int FUNCTION_TYPE3 = 3;
    public static final int FUNCTION_TYPE4 = 4;
    private static final PDFFunctionIdentity identityFunc = new PDFFunctionIdentity();

    public static PDFFunctionIdentity getIdentityFunction() {
        return identityFunc;
    }

    protected PDFFunction(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public int getFunctionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_FunctionType);
    }

    public boolean hasFunctionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_FunctionType);
    }

    public boolean hasDomain() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Domain);
    }

    public PDFDomain getFunctionDomain() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDomain domain = PDFDomain.getInstance(this.getDictionaryArrayValue(ASName.k_Domain));
        if (domain == null) {
            throw new PDFInvalidDocumentException("Required Domain Entry is missing.");
        }
        return domain;
    }

    public void setFunctionDomain(PDFDomain value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Domain is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Domain, value);
    }

    public PDFRange getFunctionRange() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRange.getInstance(this.getDictionaryArrayValue(ASName.k_Range));
    }

    public void setFunctionRange(PDFRange value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int functionType = this.getFunctionType();
        if (value == null && (functionType == 0 || functionType == 4)) {
            throw new PDFInvalidParameterException("Range is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Range, value);
    }

    public boolean hasRange() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Range);
    }

    @Override
    public double[] apply(double[] inputData) {
        try {
            return new FunctionCacheImpl(this).apply(inputData);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }
}

