/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNumeric;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFFunctionUtils;

public class PDFRange
extends PDFCosArrayList<PDFCosNumeric> {
    private PDFRange(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRange getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRange pdfObject = (PDFRange)PDFCosObject.getCachedInstance(cosObject, PDFRange.class);
        if (pdfObject == null) {
            pdfObject = new PDFRange(cosObject);
        }
        return pdfObject;
    }

    public static PDFRange newInstance(PDFDocument pdfDocument, double[] rangeArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFunctionUtils.validateDomainORRangeArray(rangeArray);
        CosArray cosObject = PDFCosObject.makeCosArray(pdfDocument, 0, rangeArray, 0, rangeArray.length - 1);
        PDFRange pdfRange = new PDFRange(cosObject);
        return pdfRange;
    }

    @Override
    protected PDFCosNumeric itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFCosNumeric.getInstance(cosObject);
    }
}

