/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;

public enum PDFRotation {
    ROTATE_0(0),
    ROTATE_90(90),
    ROTATE_180(180),
    ROTATE_270(270);

    private final int rotation;

    private PDFRotation(int rotation) {
        this.rotation = rotation;
    }

    public String toString() {
        return Integer.toString(this.rotation);
    }

    public int getValue() {
        return this.rotation;
    }

    public static final PDFRotation getInstance(int angle) throws PDFInvalidParameterException {
        PDFRotation rotation = null;
        int normAngle = angle % 360;
        normAngle = normAngle >= 0 ? normAngle : normAngle + 360;
        switch (normAngle) {
            case 0: {
                rotation = ROTATE_0;
                break;
            }
            case 90: {
                rotation = ROTATE_90;
                break;
            }
            case 180: {
                rotation = ROTATE_180;
                break;
            }
            case 270: {
                rotation = ROTATE_270;
                break;
            }
            default: {
                throw new PDFInvalidParameterException("PDFRotation must be a multiple of 90 degrees.");
            }
        }
        return rotation;
    }
}

