/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;

public class PDFColorSpaceDeviceGray
extends PDFColorSpace {
    static final double[] componentsRange = new double[]{0.0, 1.0};
    static final double[] defaultColor = new double[]{0.0};

    private PDFColorSpaceDeviceGray(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceDeviceGray getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceDeviceGray pdfObject = (PDFColorSpaceDeviceGray)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceDeviceGray.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceDeviceGray(cosObject);
        }
        return pdfObject;
    }

    public static PDFColorSpaceDeviceGray newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException {
        CosName cosObject = PDFCosObject.newCosName(pdfDocument, ASName.k_DeviceGray);
        return new PDFColorSpaceDeviceGray(cosObject);
    }

    @Override
    public ASName getName() {
        return ASName.k_DeviceGray;
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public ColorSpace createColorSpace() {
        return ColorSpace.getInstance(1003);
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        if (bpc == 2) {
            boolean inverted;
            byte[] gray = new byte[4];
            boolean bl = inverted = super.isBlackIs1() || super.isImageInverted();
            if (inverted) {
                for (int i = 0; i < 4; ++i) {
                    gray[i] = (byte)(255 - i * 85);
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    gray[i] = (byte)(i * 85);
                }
            }
            return new IndexColorModel(2, 4, gray, gray, gray);
        }
        if (bpc == 1) {
            boolean inverted;
            int a = -1;
            byte[] gray = new byte[2];
            boolean bl = inverted = super.isBlackIs1() || super.isImageInverted();
            if (inverted) {
                gray[0] = a;
                gray[1] = 0;
            } else {
                gray[0] = 0;
                gray[1] = a;
            }
            return new IndexColorModel(1, 2, gray, gray, gray);
        }
        if (bpc == 4) {
            boolean inverted;
            byte[] gray = new byte[16];
            boolean bl = inverted = super.isBlackIs1() || super.isImageInverted();
            if (inverted) {
                for (int i = 0; i < 16; ++i) {
                    gray[i] = (byte)(255 - i * 17);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    gray[i] = (byte)(i * 17);
                }
            }
            return new IndexColorModel(4, 16, gray, gray, gray);
        }
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] nBits = new int[]{bpc};
        ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, false, 1, transferType);
        return colorModel;
    }

    @Override
    public double[] getRange() {
        return componentsRange;
    }

    @Override
    public double[] toRGB(double[] gray) {
        gray = super.toRGB(gray);
        return ColorManager.convertDeviceGrayToDeviceRGB(gray[0]);
    }

    @Override
    public double[] getDefaultColor() {
        return defaultColor;
    }
}

