/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFColorSpaceWithTintTransform;
import java.util.Arrays;

public class PDFColorSpaceDeviceN
extends PDFColorSpaceWithTintTransform {
    private PDFColorSpaceDeviceN(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceDeviceN getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceDeviceN pdfObject = (PDFColorSpaceDeviceN)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceDeviceN.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceDeviceN(cosObject);
        }
        return pdfObject;
    }

    @Override
    public ASName getName() {
        return ASName.k_DeviceN;
    }

    @Override
    public int getNumberOfComponents() {
        try {
            return this.getColorantNames().length;
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
    }

    public ASName[] getColorantNames() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosNames = this.getCosArray().getCosArray(1);
        int numNames = cosNames.size();
        ASName[] asNames = new ASName[numNames];
        for (int i = 0; i < numNames; ++i) {
            asNames[i] = cosNames.getName(i);
        }
        return asNames;
    }

    @Override
    public double[] getDefaultColor() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        double[] defaultColor = new double[this.getNumberOfComponents()];
        Arrays.fill(defaultColor, 1.0);
        return defaultColor;
    }
}

